/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.ExceptionUtil;

public class ScpOrdChangeSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ScpOrdChangeSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("cfmstatus");
        fieldKeys.add("cfm");
        fieldKeys.add("cfmdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            dynamicObject.set("cfmstatus", (Object)ConfirmStatusEnum.UNCONFIRM.getVal());
            dynamicObject.set("cfm", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("cfmdate", (Object)TimeServiceHelper.now());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        block7: {
            DynamicObject[] objs = e.getDataEntities();
            if (objs.length == 0) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
            if (this.getOption() != null) {
                option.setVariableValue("ishasright", this.getOption().getVariableValue("ishasright", String.valueOf(false)));
            }
            boolean isUnSubmit = false;
            try {
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"scp_ordchange", (Object[])this.getOperationResult().getSuccessPkIds().toArray(), (OperateOption)option);
                if (auditResult.isSuccess()) {
                    log.info("\u63d0\u4ea4\u5373\u5ba1\u6838\u6210\u529f\u3002");
                    List successPkIds = this.getOperationResult().getSuccessPkIds();
                    for (Object successPkId : successPkIds) {
                        WorkflowServiceHelper.tryTriggerProcess((String)successPkId.toString(), (String)"intoworkflow", (String)"pur_ordchange", null);
                    }
                    break block7;
                }
                isUnSubmit = true;
                log.info(auditResult.getMessage());
                OperationServiceHelper.executeOperate((String)"unsubmit", (String)"scp_ordchange", (Object[])this.getOperationResult().getSuccessPkIds().toArray(), (OperateOption)option);
                String message = auditResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo());
                throw new KDBizException(message);
            }
            catch (Exception ex) {
                if (!isUnSubmit) {
                    OperationServiceHelper.executeOperate((String)"unsubmit", (String)"scp_ordchange", (Object[])this.getOperationResult().getSuccessPkIds().toArray(), (OperateOption)option);
                }
                throw new KDBizException(ex.getMessage());
            }
        }
    }
}

