/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;

public class ScpOrderCfmStatusValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] rowDataEntity = this.getDataEntities();
        HashMap poBillMap = new HashMap(1024);
        for (ExtendedDataEntity dataEntity : rowDataEntity) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("materialentry");
            for (DynamicObject obj : entrys) {
                String poentryid = obj.getString("poentryid");
                if (StringUtils.isBlank((CharSequence)poentryid)) continue;
                if (!poBillMap.containsKey(poentryid)) {
                    ArrayList<ExtendedDataEntity> checkData = new ArrayList<ExtendedDataEntity>(rowDataEntity.length);
                    checkData.add(dataEntity);
                    poBillMap.put(poentryid, checkData);
                    continue;
                }
                ((List)poBillMap.get(poentryid)).add(dataEntity);
            }
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"scp_order", (String)"billno,materialentry.poentryid poentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poBillMap.keySet()).and(new QFilter("cfmstatus", "not in", (Object)new String[]{ConfirmStatusEnum.CONFIRM.getVal(), ConfirmStatusEnum.AUTOCONFIRM.getVal()}))}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String poentryid = row.getString("poentryid");
                String tempBillNo = row.getString("billno");
                List checkData = (List)poBillMap.get(poentryid);
                if (checkData == null) continue;
                for (ExtendedDataEntity extendedDataEntity : checkData) {
                    this.addErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u8ba2\u5355{0}\u4e0d\u662f\u5df2\u786e\u8ba4\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u8ba2\u5355\u540e\u518d\u53d1\u8d27\u3002", (String)"ScpSalOutSaveOp_0", (String)"scm-scp-opplugin", (Object[])new Object[0]), tempBillNo));
                }
            }
        }
    }
}

