/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.isc.util.ApiOperateUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.scp.common.util.ScpOrderChangeUtil;

public class ScpOrderChangeConfirmPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ScpOrderChangeConfirmPlugin.class);
    private final Boolean scconsistencyservice = ParamConfigUtil.getBooleanParamConfig((String)"scconsistencyservice");
    private static final String POBILLNO = "pobillno";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldsKeys = e.getFieldKeys();
        fieldsKeys.add(POBILLNO);
        fieldsKeys.add("materialentry.entrydelidate");
        fieldsKeys.add("materialentry.poentryid");
        fieldsKeys.add("pobillid");
        fieldsKeys.add("materialentry.qty");
        fieldsKeys.add("billstatus");
        e.setFieldKeys(fieldsKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        HashMap<String, String> logStatusMap = new HashMap<String, String>();
        String key = e.getOperationKey();
        DynamicObject[] orderChangeObjs = e.getDataEntities();
        String entityType = this.billEntityType.getName();
        if (("agreeorderchange".equalsIgnoreCase(key) || "confirm".equalsIgnoreCase(key)) && entityType.equals("scp_ordchange")) {
            ArrayList<DynamicObject> submitObjList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> auditObjList = new ArrayList<DynamicObject>();
            for (DynamicObject orderChange : orderChangeObjs) {
                String billStatus = orderChange.getString("billstatus");
                if (BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
                    submitObjList.add(orderChange);
                    continue;
                }
                if (!BillStatusEnum.AUDIT.getVal().equals(billStatus)) continue;
                auditObjList.add(orderChange);
            }
            if (!submitObjList.isEmpty()) {
                List idList = DynamicObjectUtil.array2ListId((DynamicObject[])submitObjList.toArray(new DynamicObject[0]), null);
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"scp_ordchange", (Object[])idList.toArray(new Object[0]), (OperateOption)option);
                if (!auditResult.isSuccess()) {
                    log.info("\u5217\u8868\u8ba2\u5355\u786e\u8ba4---->" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                    e.setCancelMessage(ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                    e.setCancel(true);
                }
            }
            if (!e.isCancel() && !ApiConfigUtil.hasCQScmConfig()) {
                if (ApiConfigUtil.hasEASScmConfig() || ApiConfigUtil.hasXKScmConfig() && !ScpOrderChangeConfirmPlugin.isNewChangeLogic()) {
                    ScpOrderChangeConfirmPlugin.writeBack(e, orderChangeObjs, entityType, auditObjList, submitObjList, logStatusMap);
                } else if (ApiConfigUtil.hasXKScmConfig() && ScpOrderChangeConfirmPlugin.isNewChangeLogic()) {
                    ScpOrderChangeConfirmPlugin.senMessageToK3Clould(e, orderChangeObjs);
                }
            }
        }
    }

    private static void senMessageToK3Clould(BeforeOperationArgs e, DynamicObject[] orderChangeObjs) {
        List poBillNoList = Arrays.stream(orderChangeObjs).map(order -> order.getString(POBILLNO)).collect(Collectors.toList());
        HashMap param = new HashMap(16);
        HashMap dataMap = new HashMap(16);
        dataMap.put("billno", poBillNoList);
        param.put("data", dataMap);
        try {
            Map msgMap;
            Object status;
            String msg = ApiOperateUtil.doExec(param, null, (String)"doOrderAlertConfirm2");
            if (!(null == msg || msg.isEmpty() || null != (status = (msgMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class)).get("status")) && status.toString().trim().equals("200"))) {
                String errorMsg = String.valueOf(msgMap.get("error"));
                e.setCancelMessage(errorMsg);
                e.setCancel(true);
            }
        }
        catch (Exception exception) {
            e.setCancelMessage(exception.getMessage());
            e.setCancel(true);
        }
    }

    private static boolean isNewChangeLogic() {
        return QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"isNewChangeLogic").and(new QFilter("paramvalue", "=", (Object)"Y"))});
    }

    private static void writeBack(BeforeOperationArgs e, DynamicObject[] orderChangeObjs, String entityType, List<DynamicObject> auditObjList, List<DynamicObject> submitObjList, Map<String, String> logStatusMap) {
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + orderChangeObjs.length);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityType, (boolean)true);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)entityType, (String)"materialentry", (boolean)true);
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])auditObjList.toArray(new DynamicObject[0]), null);
        if (idList == null || idList.isEmpty()) {
            idList = DynamicObjectUtil.array2ListId((DynamicObject[])submitObjList.toArray(new DynamicObject[0]), null);
        }
        HashMap paramMap = new HashMap(1);
        HashMap<String, List> idMap = new HashMap<String, List>(1);
        idMap.put("in", idList);
        paramMap.put("id", idMap);
        DynamicObjectCollection orderChangeCollection = ORMUtil.queryDynamicObjectCollection((String)"scp_ordchange", (String)selectFields, paramMap);
        ScpOrderChangeUtil.writeBackPurOrderInfo((DynamicObject[])orderChangeObjs, (DynamicObjectCollection)orderChangeCollection, logStatusMap);
        if (ApiConfigUtil.hasEASConfig()) {
            ScpOrderChangeConfirmPlugin.sendMessageToEASAndXK(e, orderChangeObjs, entityType, logStatusMap);
        }
    }

    private static void sendMessageToEASAndXK(BeforeOperationArgs e, DynamicObject[] orderChangeObjs, String entityType, Map<String, String> logStatusMap) {
        try {
            Map msgMap;
            Object status;
            String msg = ScpOrderChangeUtil.poChangeConfirm2EAS((DynamicObject[])orderChangeObjs, (String)entityType, logStatusMap);
            log.info("###confirm2Eas restult:" + msg);
            if (!(null == msg || msg.isEmpty() || null != (status = (msgMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class)).get("status")) && status.toString().trim().equals("200") || null == status || !status.toString().trim().equals("500"))) {
                String errorMsg = String.valueOf(msgMap.get("error"));
                e.setCancelMessage(errorMsg);
                e.setCancel(true);
            }
        }
        catch (Exception exception) {
            e.setCancelMessage(exception.getMessage());
            e.setCancel(true);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            dynamicObject.set("cfm", (Object)RequestContext.get().getUserId());
            dynamicObject.set("cfmdate", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.scconsistencyservice.booleanValue()) {
            ScDataHandleServiceHelper.executeHandle((String)"orderchangeconfirm", (DynamicObject[])e.getDataEntities());
        } else {
            ArrayList<Long> pkS = new ArrayList<Long>(e.getDataEntities().length);
            for (DynamicObject bill : e.getDataEntities()) {
                pkS.add(bill.getLong("id"));
            }
            if (!pkS.isEmpty()) {
                this.upChangeConfirmStatus(pkS);
            }
        }
    }

    private void upChangeConfirmStatus(List<Long> ids) {
        Set idSet;
        Map map = BFTrackerServiceHelper.findSourceBills((String)"pur_ordchange", (Long[])ids.toArray(new Long[ids.size()]));
        Set set = idSet = map == null ? null : (Set)map.get("pm_xpurorderbill");
        if (null != idSet) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", new ArrayList(idSet));
            params.put("status", "B");
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upChangeConfirmStatus", (Object[])new Object[]{params});
        }
    }
}

