/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.botp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.scp.business.ScpAvailableStockBasicQtyHelper;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.common.ScpVerifyResult;

public class ScpOrderToSaloutstockPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(ScpOrderToSaloutstockPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        ScpVerifyResult scpVerifyResult;
        Collection resultData;
        e.setCustFilterDesc(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5168\u90e8\u53d1\u8d27\u3002", (String)"ScpOrderToSaloutstockPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
        e.setCustFilterExpression(" ( ( materialentry.iscontrolqty=true and materialentry.saloutqtyup > ( materialentry.relateoutstockqty  - materialentry.sumrefundqty - materialentry.sumrejqty ) ) or ( materialentry.iscontrolqty=false and materialentry.qty > ( materialentry.relateoutstockqty  - materialentry.sumrefundqty - materialentry.sumrejqty ) ) ) ");
        QFilter qFilter = QFilter.of((String)"materialentry.iscontrolqty=true and materialentry.saloutqtyup > ( materialentry.relateoutstockqty - materialentry.sumrefundqty  - materialentry.sumrejqty )", (Object[])new Object[0]).or(QFilter.of((String)"materialentry.iscontrolqty=false and materialentry.qty > ( materialentry.relateoutstockqty - materialentry.sumrefundqty  - materialentry.sumrejqty )", (Object[])new Object[0]));
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        String checksource = (String)paramMap.get("ignorechecksource");
        if (!"true".equals(checksource) && !(resultData = (scpVerifyResult = ScpOrderBillHelper.verifyCanSalOutStock((List)e.getSelectedRows())).getData()).isEmpty()) {
            logger.info("message:" + scpVerifyResult.getMessage() + "data:" + SerializationUtils.toJsonString((Object)scpVerifyResult.getData()));
            e.setCustFilterDesc(scpVerifyResult.getMessage());
            e.setCustFilterExpression("materialentry.id not in (" + StringUtils.join((Object[])resultData.toArray(new Long[resultData.size()]), (String)",") + ")");
            QFilter canDel = new QFilter("materialentry.id", "not in", (Object)resultData);
            e.getCustQFilters().add(canDel);
        }
        e.getCustQFilters().add(qFilter);
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("materialentry.id");
        e.addSrcField("qty");
        e.addSrcField("basicqty");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        DynamicProperty entryIdType = (DynamicProperty)fldProperties.get("materialentry.id");
        DynamicProperty qty = (DynamicProperty)fldProperties.get("qty");
        DynamicProperty basicQty = (DynamicProperty)fldProperties.get("basicqty");
        List sourceRows = e.getSourceRows();
        HashSet<Long> orderEntryIds = new HashSet<Long>(1024);
        for (DynamicObject dynamicObject : sourceRows) {
            orderEntryIds.add(Long.parseLong(entryIdType.getValue((Object)dynamicObject).toString()));
        }
        if (!orderEntryIds.isEmpty()) {
            HashMap<String, String> customParamMap = new HashMap<String, String>(6);
            customParamMap.put("tgtbilltype", "scp_saloutstock");
            customParamMap.put("getvaluescene", "function");
            customParamMap.put("valueproperty", "relateoutstockbaseqty");
            Map orderAvailableDataMap = ScpAvailableStockBasicQtyHelper.assembleOrderAvailableBasicQty(orderEntryIds, customParamMap);
            for (DynamicObject dynamicObject : sourceRows) {
                Long entryId = Long.parseLong(entryIdType.getValue((Object)dynamicObject).toString());
                Map availableQtyMap = (Map)orderAvailableDataMap.get(entryId);
                if (availableQtyMap == null) continue;
                qty.setValue((Object)dynamicObject, availableQtyMap.get("qty"));
                basicQty.setValue((Object)dynamicObject, availableQtyMap.get("basicqty"));
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("scp_saloutstock");
        this.setDefualtQty(entitys);
        Object currentContacter = this.setCurrentContacter();
        for (ExtendedDataEntity extendedDataEntity : entitys) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            this.setDefaultValue(bill, currentContacter);
            Long settleOrg = bill.getLong("settleorg_id");
            BigDecimal sumQty = bill.getBigDecimal("sumqty");
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row2 : rows) {
                if (null == settleOrg) continue;
                row2.set("entrysettleorg", (Object)settleOrg);
            }
            rows.removeIf(row -> row.getBigDecimal("qty").compareTo(BigDecimal.ZERO) == 0);
            bill.set("sumqty", (Object)sumQty);
        }
    }

    private void setDefualtQty(ExtendedDataEntity[] entitys) {
        ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
        for (ExtendedDataEntity extendedDataEntity : entitys) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynentrys = dynamicObject.getDynamicObjectCollection("materialentry");
            if (dynentrys == null || dynentrys.isEmpty()) continue;
            for (int i = 0; i < dynentrys.size(); ++i) {
                iCalDynamic.proChanged(dynamicObject, "materialentry", "qty", i);
            }
        }
    }

    private void setDefaultValue(DynamicObject dynamicObject, Object currentContacter) {
        if (dynamicObject.get("org") == null) {
            dynamicObject.set("org", (Object)RequestContext.get().getOrgId());
        }
        if (dynamicObject.get("contacter") == null) {
            dynamicObject.set("contacter_id", currentContacter);
        }
    }

    private Object setCurrentContacter() {
        QFilter qFilter = new QFilter("user", "=", (Object)UserServiceHelper.getCurrentUserId()).and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] operators = BusinessDataServiceHelper.load((String)"scp_bizperson", (String)"masterid,name,number", (QFilter[])new QFilter[]{qFilter});
        if (operators != null && operators.length > 0) {
            return operators[0].getPkValue();
        }
        return 0L;
    }
}

