/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scm.common.util.MaterialUtil;

public class ShelfLifeDateValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ShelfLifeDateValidator", (String)"validate");){
            HashMap orgMaterialSet = new HashMap(8);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObject org = billEntity.getDynamicObject("org");
                if (org == null) continue;
                long orgid = Long.parseLong(billEntity.getDynamicObject("org").getPkValue().toString());
                DynamicObjectCollection col = billEntity.getDynamicObjectCollection("materialentry");
                HashSet<Long> materialSet = new HashSet<Long>(col.size());
                for (DynamicObject entry : col) {
                    Date produceDate = entry.getDate("proddate");
                    Date expiryDate = entry.getDate("duedate");
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null || produceDate != null && expiryDate != null) continue;
                    materialSet.add(Long.parseLong(material.getPkValue().toString()));
                }
                HashSet<Long> set = (HashSet<Long>)orgMaterialSet.get(orgid);
                if (set == null) {
                    set = new HashSet<Long>(8);
                    set.addAll(materialSet);
                } else {
                    set.addAll(materialSet);
                }
                orgMaterialSet.put(orgid, set);
            }
            HashMap materialMap = new HashMap(8);
            for (Map.Entry entry : orgMaterialSet.entrySet()) {
                long orgid = (Long)entry.getKey();
                Set materialSet = (Set)entry.getValue();
                Map map = MaterialUtil.getMaterialInventoryinfo((Set)materialSet, (long)orgid, (String)"materialid,id,enablelot,enableshelflifemgr");
                materialMap.putAll(map);
            }
            DynamicObject materialInvInfo = null;
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObjectCollection col = billEntity.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : col) {
                    Date produceDate = row.getDate("proddate");
                    Date expiryDate = row.getDate("duedate");
                    DynamicObject material = row.getDynamicObject("material");
                    if (material == null || (materialInvInfo = (DynamicObject)materialMap.get(material.getPkValue())) == null || !materialInvInfo.getBoolean("enableshelflifemgr") || produceDate != null && expiryDate != null) continue;
                    String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u8bf7\u8f93\u5165\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u3002", (String)"ShelfLifeDateValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[0]);
                    this.addMessage(entity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
                }
            }
        }
    }
}

