/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.scm.common.util.MaterialUtil;

public class SupLotValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"SupLotValidator", (String)"validate");){
            HashMap orgMaterialSet = new HashMap(8);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject org;
                String srctype;
                DynamicObject billEntity = entity.getDataEntity();
                String receipttype = billEntity.getString("receipttype");
                if (!"0".equals(receipttype) || !"1".equals(srctype = billEntity.getString("srctype")) || (org = billEntity.getDynamicObject("org")) == null) continue;
                long orgid = Long.parseLong(billEntity.getDynamicObject("org").getPkValue().toString());
                DynamicObjectCollection col = billEntity.getDynamicObjectCollection("materialentry");
                HashSet<Long> materialSet = new HashSet<Long>(col.size());
                for (DynamicObject entry : col) {
                    DynamicObject material = entry.getDynamicObject("material");
                    materialSet.add(Long.parseLong(material.getPkValue().toString()));
                }
                HashSet<Long> set = (HashSet<Long>)orgMaterialSet.get(orgid);
                if (set == null) {
                    set = new HashSet<Long>(8);
                    set.addAll(materialSet);
                } else {
                    set.addAll(materialSet);
                }
                orgMaterialSet.put(orgid, set);
            }
            HashMap materialMap = new HashMap(8);
            for (Map.Entry entry : orgMaterialSet.entrySet()) {
                long orgid = (Long)entry.getKey();
                Set materialSet = (Set)entry.getValue();
                Map map = MaterialUtil.getMaterialInventoryinfo((Set)materialSet, (long)orgid, (String)"materialid,id,enablelot,enableshelflifemgr");
                materialMap.putAll(map);
            }
            DynamicObject materialInvInfo = null;
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObjectCollection col = billEntity.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : col) {
                    DynamicObject material = row.getDynamicObject("material");
                    if (material == null) continue;
                    String suplot = row.getString("suplot");
                    materialInvInfo = (DynamicObject)materialMap.get(material.getPkValue());
                    if (materialInvInfo == null || !materialInvInfo.getBoolean("enablelot") || !StringUtils.isEmpty((String)suplot)) continue;
                    String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u7269\u6599\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u4f9b\u5e94\u5546\u6279\u53f7\u5fc5\u8f93\u3002", (String)"SupLotValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[]{row.getInt("seq")});
                    this.addMessage(entity, msg, ErrorLevel.Error);
                }
            }
        }
    }
}

