/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.helper.SRMBillEntityTypeHelper;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CheckUtils;
import kd.scm.sccore.business.CheckAvailableBasicQtyHelper;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;

public final class ScpAvailableStockBasicQtyHelper {
    private static final Log log = LogFactory.getLog(ScpAvailableStockBasicQtyHelper.class);

    public static List<DynamicObject> queryOrderDataCoreEntryIds(Collection<String> coreEntryIds, Map<String, String> customParamMap) {
        Collection properties = OrderAvailableStockQtyHelper.assmibleMustProperties();
        String valueProperty = customParamMap.getOrDefault("valueproperty", "sumoutstockbaseqty");
        properties.add(valueProperty);
        String entityFields = SRMBillEntityTypeHelper.getEntityFields((String)"pur_order", (Collection)properties);
        QFilter filter = new QFilter("materialentry.poentryid", "in", coreEntryIds);
        return OrderAvailableStockQtyHelper.queryOrderData((QFilter)filter, (String)entityFields, null, customParamMap);
    }

    public static Map<String, BigDecimal> assembleOrderVerifyBasicQty(Map<String, BigDecimal> coreEntryIdBasicQtyMap, Map<String, String> customParamMap) {
        if (coreEntryIdBasicQtyMap == null || coreEntryIdBasicQtyMap.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:orderEntryIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
        String valueProperty = "sumoutstockbaseqty";
        List<DynamicObject> orderData = ScpAvailableStockBasicQtyHelper.queryOrderDataCoreEntryIds(coreEntryIdBasicQtyMap.keySet(), customParamMap);
        Map orderAvailableBasicQtyMap = OrderAvailableStockQtyHelper.assembleOrderAvailableBasicQty(orderData);
        Map orderBasicQtyMap = OrderAvailableStockQtyHelper.assembleOrderBasicQty(orderData, customParamMap);
        HashMap<String, BigDecimal> orderAvailableDataMap = new HashMap<String, BigDecimal>(1024);
        for (DynamicObject order : orderData) {
            BigDecimal orderBasicQty;
            BigDecimal availableValueBasicQty;
            String poentryid = order.getString("poentryid");
            Long entryId = order.getLong("orderentryid");
            BigDecimal coreSumBasicQty = coreEntryIdBasicQtyMap.get(poentryid);
            if (coreSumBasicQty == null) continue;
            BigDecimal valuePropertyBasicQty = order.getBigDecimal(valueProperty);
            BigDecimal orderAvailableBasicQty = orderAvailableBasicQtyMap.getOrDefault(poentryid, BigDecimal.ZERO);
            orderAvailableDataMap.put(poentryid, orderAvailableBasicQty.compareTo(availableValueBasicQty = (orderBasicQty = orderBasicQtyMap.getOrDefault(entryId, BigDecimal.ZERO)).subtract(valuePropertyBasicQty).add(coreSumBasicQty)) <= 0 ? orderAvailableBasicQty : availableValueBasicQty);
        }
        if (log.isInfoEnabled()) {
            log.info("ScpAvailableStockBasicQtyHelper#getOrderStockBasicQty#rowMap:{}", (Object)SerializationUtils.toJsonString(orderAvailableDataMap));
        }
        return orderAvailableDataMap;
    }

    public static Map<String, BigDecimal> assembleAvailableMatchQty(Map<String, Collection<Long>> checkData) {
        HashMap customParamMap = new HashMap(2);
        HashMap<String, BigDecimal> orderAvailableDataMa = new HashMap<String, BigDecimal>(1024);
        orderAvailableDataMa.putAll((Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)"getAvailableMatchQty", (Object[])new Object[]{checkData, customParamMap}));
        return orderAvailableDataMa;
    }

    public static void assembleDetailmatchQty(Collection<DynamicObject> purDetailList) {
        HashMap<String, Collection<Long>> checkData = new HashMap<String, Collection<Long>>(1024);
        List pmOmBussnissTypeIds = BussinessTypeUtils.getPmOmBussnissTypeIds();
        for (DynamicObject row : purDetailList) {
            HashSet<Long> stepSrcEntryIds;
            String srcBillType = row.getString("srcbilltype");
            String srcEntryId = row.getString("entryid");
            Long businesstypeId = row.getLong("businesstype_in");
            if (CheckUtils.isPurInstock((String)srcBillType) && pmOmBussnissTypeIds.contains(businesstypeId)) {
                srcBillType = "im_mdc_omcmplinbill";
            }
            if ((stepSrcEntryIds = (HashSet<Long>)checkData.get(srcBillType)) == null) {
                stepSrcEntryIds = new HashSet<Long>(1024);
            }
            stepSrcEntryIds.add(Long.parseLong(srcEntryId));
            checkData.put(srcBillType, stepSrcEntryIds);
        }
        HashMap<String, BigDecimal> matchAvailableBasicQty = new HashMap<String, BigDecimal>(1024);
        if (!checkData.isEmpty()) {
            matchAvailableBasicQty.putAll(ScpAvailableStockBasicQtyHelper.assembleAvailableMatchQty(checkData));
        }
        BigDecimal availableMatchQty = null;
        for (DynamicObject row : purDetailList) {
            String srcEntryId = row.getString("entryid");
            availableMatchQty = (BigDecimal)matchAvailableBasicQty.get(srcEntryId);
            if (availableMatchQty == null) continue;
            row.set("unmatchqty", (Object)availableMatchQty);
        }
    }

    public static void assembleDetailBusinessDirect(Collection<DynamicObject> purDetailList) {
        CheckAvailableBasicQtyHelper.assembleDetailBusinessDirect(purDetailList);
    }

    public static void modifyDetailmatchQty(Collection<DynamicObject> purDetailList) {
        HashMap<String, Collection<Long>> checkData = new HashMap<String, Collection<Long>>(1024);
        List pmOmBussnissTypeIds = BussinessTypeUtils.getPmOmBussnissTypeIds();
        for (DynamicObject row : purDetailList) {
            HashSet<Long> stepSrcEntryIds;
            String srcBillType = row.getString("srcbilltype3");
            String srcEntryId = row.getString("entryid3");
            Object businesstypeObj = row.get("businesstype_in3");
            long businesstypeId = 0L;
            if (businesstypeObj != null && !businesstypeObj.equals(0)) {
                businesstypeId = ((DynamicObject)businesstypeObj).getLong("id");
            }
            if (CheckUtils.isPurInstock((String)srcBillType) && pmOmBussnissTypeIds.contains(businesstypeId)) {
                srcBillType = "im_mdc_omcmplinbill";
            }
            if ((stepSrcEntryIds = (HashSet<Long>)checkData.get(srcBillType)) == null) {
                stepSrcEntryIds = new HashSet<Long>(1024);
            }
            stepSrcEntryIds.add(Long.parseLong(srcEntryId));
            checkData.put(srcBillType, stepSrcEntryIds);
        }
        HashMap<String, BigDecimal> matchAvailableBasicQty = new HashMap<String, BigDecimal>(1024);
        if (!checkData.isEmpty()) {
            matchAvailableBasicQty.putAll(ScpAvailableStockBasicQtyHelper.assembleAvailableMatchQty(checkData));
        }
        BigDecimal availableMatchQty = null;
        for (DynamicObject row : purDetailList) {
            String srcEntryId = row.getString("entryid3");
            availableMatchQty = (BigDecimal)matchAvailableBasicQty.get(srcEntryId);
            if (availableMatchQty != null) {
                row.set("unmatchqty3", (Object)availableMatchQty);
            }
            PurCheckMappingUtils.assembleDetailUnmatchtaxamount((DynamicObject)row, (String)"unmatchtaxamount3", (String)"3");
        }
    }

    public static Map<Long, Map<String, BigDecimal>> assembleOrderAvailableBasicQty(Collection<Long> orderEntryIds, Map<String, String> customParamMap) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)"getOrderStockBasicQty", (Object[])new Object[]{orderEntryIds, customParamMap});
    }
}

