/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpModuleConsumeHelper {
    public static Map<String, BigDecimal> assambleConsumeSubQty(DynamicObjectCollection materialentrys) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
        HashSet<Long> srcbillidSet = new HashSet<Long>(8);
        for (DynamicObject materialentry : materialentrys) {
            String srcbillid = materialentry.getString("srcbillid");
            if (!StringUtils.isNotEmpty((CharSequence)srcbillid)) continue;
            srcbillidSet.add(Long.parseLong(srcbillid));
        }
        QFilter qf = new QFilter("id", "in", srcbillidSet);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"scp_order", (String)"id,materialentry.subentryentity.consumesubqty consumesubqty,materialentry.subentryentity.subsrcbillentryid subsrcbillentryid", (QFilter[])new QFilter[]{qf});
        for (DynamicObject dy : dys) {
            String subsrcbillentryid = dy.getString("subsrcbillentryid");
            BigDecimal consumesubqty = dy.getBigDecimal("consumesubqty");
            map.put(subsrcbillentryid, consumesubqty == null ? BigDecimal.ZERO : consumesubqty);
        }
        return map;
    }

    public static void assambleSubSumConQty(Map<String, BigDecimal> overQtyMap, Map<String, BigDecimal> currQtyMap, DynamicObjectCollection materialentrys) {
        Map<String, BigDecimal> map = ScpModuleConsumeHelper.assambleConsumeSubQty(materialentrys);
        for (DynamicObject materialentry : materialentrys) {
            DynamicObjectCollection subentryentitys = materialentry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subentryentity : subentryentitys) {
                String subsrcbillentryid = subentryentity.getString("subsrcbillentryid");
                String isbackflush = subentryentity.getString("isbackflush");
                String overissuecontrl = subentryentity.getString("overissuecontrl");
                BigDecimal subsumconqty = map.get(subsrcbillentryid) == null ? BigDecimal.ZERO : map.get(subsrcbillentryid);
                BigDecimal subcurrconqty = subentryentity.getBigDecimal("subcurrconqty");
                BigDecimal curSumConQty = subsumconqty.add(subcurrconqty);
                BigDecimal extraratioqty = subentryentity.getBigDecimal("extraratioqty");
                if ("B".equals(isbackflush) || !"B".equals(overissuecontrl)) {
                    overQtyMap.put(subsrcbillentryid, BigDecimal.ZERO);
                    currQtyMap.put(subsrcbillentryid, subcurrconqty);
                    continue;
                }
                if (curSumConQty.compareTo(extraratioqty) > 0) {
                    BigDecimal overQty = curSumConQty.subtract(extraratioqty);
                    BigDecimal currQty = subcurrconqty.subtract(overQty);
                    overQtyMap.put(subsrcbillentryid, overQty);
                    currQtyMap.put(subsrcbillentryid, currQty);
                    continue;
                }
                overQtyMap.put(subsrcbillentryid, BigDecimal.ZERO);
                currQtyMap.put(subsrcbillentryid, subcurrconqty);
            }
        }
    }

    public static void buildParamByOrder(DynamicObject[] bills, Set<Long> selectEntryIds, Map<Long, Collection<Long>> pushOrderData) {
        for (DynamicObject bill : bills) {
            Long purOrderId = bill.getLong("id");
            ArrayList<DynamicObject> materialentryRow = new ArrayList<DynamicObject>(8);
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                Long entryId = row.getLong("id");
                if (CollectionUtils.isEmpty(selectEntryIds) || !selectEntryIds.contains(entryId)) continue;
                materialentryRow.add(row);
            }
            ScpModuleConsumeHelper.buildPurOrderData(purOrderId, pushOrderData, materialentryRow);
        }
    }

    public static void buildPurOrderData(Long purOrderId, Map<Long, Collection<Long>> pushOrderData, List<DynamicObject> rows) {
        Collection<Long> collection;
        Boolean isFilterBackFlush = false;
        String consumeMoment = ScpSalOutStockBillHelper.getConsumeMoment();
        if ("saloutstock".equals(consumeMoment)) {
            isFilterBackFlush = true;
        }
        if ((collection = pushOrderData.get(purOrderId)) == null) {
            collection = new HashSet<Long>(8);
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection subRows = row.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subrow : subRows) {
                Long subentryentityid = subrow.getLong("id");
                String isbackflush = subrow.getString("isbackflush");
                if (isFilterBackFlush.booleanValue()) {
                    if (subentryentityid == null || "B".equals(isbackflush)) continue;
                    collection.add(subentryentityid);
                    continue;
                }
                if (subentryentityid == null) continue;
                collection.add(subentryentityid);
            }
            if (CollectionUtils.isEmpty(collection)) continue;
            pushOrderData.put(purOrderId, collection);
        }
    }

    public static String getConsumeMomentBotp(String propkey) {
        String createuserstrategy = null;
        try {
            Object param = ParamUtil.getBillParam((String)"scp_moduleconsume", (String)propkey);
            if (param != null) {
                createuserstrategy = String.valueOf(param);
            }
        }
        catch (Exception exception) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
        }
        return StringUtils.isEmpty(createuserstrategy) ? "" : createuserstrategy;
    }

    public static Map<String, String> buildParam(DynamicObject[] bills, Map<String, String> salOutInfoMap, Map<Long, Collection<Long>> pushOrderData, Map<String, BigDecimal> overQtyToCreateToMap) {
        ArrayList<DynamicObject> materialentryRow = new ArrayList<DynamicObject>(8);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                materialentryRow.add(row);
                DynamicObjectCollection subEntryEntitys = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subEntryEntitys) {
                    String subsrcbillentryid = subEntry.getString("subsrcbillentryid");
                    if (!overQtyToCreateToMap.containsKey(subsrcbillentryid)) continue;
                    ScpModuleConsumeHelper.assembleCosmicParam(subsrcbillentryid, subEntry, salOutInfoMap, overQtyToCreateToMap);
                    salOutInfoMap.put("subsrcbillno_" + subsrcbillentryid, subEntry.getString("subsrcbillno"));
                    salOutInfoMap.put("subsrcbilltype_" + subsrcbillentryid, subEntry.getString("subsrcbilltype"));
                    salOutInfoMap.put("subsrcbillid_" + subsrcbillentryid, subEntry.getString("subsrcbillid"));
                    salOutInfoMap.put("subsrcbillentryid_" + subsrcbillentryid, subEntry.getString("subsrcbillentryid"));
                }
            }
        }
        ScpModuleConsumeHelper.buildPurOrderData(pushOrderData, overQtyToCreateToMap, materialentryRow);
        return salOutInfoMap;
    }

    public static void buildPurOrderData(Map<Long, Collection<Long>> pushOrderData, Map<String, BigDecimal> overQtyToCreateToMap, List<DynamicObject> rows) {
        ArrayList<Long> purOrderBillids = new ArrayList<Long>(8);
        for (DynamicObject row : rows) {
            if (!CollectionUtils.isEmpty(overQtyToCreateToMap)) {
                DynamicObjectCollection subEntryEntitys = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subEntryEntitys) {
                    String srcbillid;
                    String subsrcbillentryid = subEntry.getString("subsrcbillentryid");
                    if (!overQtyToCreateToMap.containsKey(subsrcbillentryid) || !StringUtils.isNotEmpty((CharSequence)(srcbillid = row.getString("srcbillid")))) continue;
                    purOrderBillids.add(Long.parseLong(srcbillid));
                }
                continue;
            }
            String srcbillid = row.getString("srcbillid");
            if (!StringUtils.isNotEmpty((CharSequence)srcbillid)) continue;
            purOrderBillids.add(Long.parseLong(srcbillid));
        }
        QFilter qf = new QFilter("id", "in", purOrderBillids);
        if (!CollectionUtils.isEmpty(overQtyToCreateToMap)) {
            qf.and("materialentry.subentryentity.subsrcbillentryid", "in", overQtyToCreateToMap.keySet());
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"scp_order", (String)"id,materialentry.subentryentity.id subentryentityid", (QFilter[])new QFilter[]{qf});
        for (DynamicObject dy : dys) {
            Long subentryentityid;
            Long purOrderId = dy.getLong("id");
            Collection<Long> collection = pushOrderData.get(purOrderId);
            if (collection == null) {
                collection = new HashSet<Long>(8);
            }
            if ((subentryentityid = Long.valueOf(dy.getLong("subentryentityid"))) != null) {
                collection.add(subentryentityid);
            }
            if (CollectionUtils.isEmpty(collection)) continue;
            pushOrderData.put(purOrderId, collection);
        }
    }

    private static void assembleCosmicParam(String subsrcbillentryid, DynamicObject row, Map<String, String> salOutInfoMap, Map<String, BigDecimal> overQtyToCreateToMap) {
        BigDecimal qty = overQtyToCreateToMap.get(subsrcbillentryid);
        if (qty != null) {
            salOutInfoMap.put("curconsumesubqty_" + subsrcbillentryid, qty.toPlainString());
            salOutInfoMap.put("curconsumesubbaseqty_" + subsrcbillentryid, qty.toPlainString());
        }
    }
}

