/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.OrderUtil;
import kd.scm.scp.business.ScpAvailableStockBasicQtyHelper;
import kd.scm.scp.business.ScpBillParamHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;
import kd.scm.scp.common.ScpVerifyResult;

public final class ScpOrderBillHelper {
    public static Set<String> getBillNoSetOfConfirmStatus(DynamicObject[] objs, String confirmStatusValue) {
        HashSet<String> numbers = new HashSet<String>(3);
        for (DynamicObject bill : objs) {
            String billno = bill.getString("billno");
            if (billno.trim().length() <= 0 || !bill.getString("cfmstatus").equals(confirmStatusValue)) continue;
            numbers.add(billno);
        }
        return numbers;
    }

    @Deprecated
    public static Map<String, Object> verifyOrderCanStock(Set<Long> orderBillIds) {
        HashMap<Long, Collection<Long>> checkMap = new HashMap<Long, Collection<Long>>(orderBillIds.size());
        orderBillIds.forEach(row -> checkMap.put((Long)row, new HashSet(1)));
        return ScpOrderBillHelper.verifyOrderRowCanStock(checkMap);
    }

    public static Map<String, Object> verifyOrderRowCanStock(Map<Long, Collection<Long>> checkMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.putAll(ScpOrderBillHelper.assembleEntryCheckMessage(checkMap.keySet()));
        HashSet<String> checkSalOutEntry = new HashSet<String>(1024);
        ArrayList<Long> listEntryIds = new ArrayList<Long>(1024);
        for (Map.Entry<Long, Collection<Long>> entry : checkMap.entrySet()) {
            listEntryIds.addAll(entry.getValue());
        }
        listEntryIds.forEach(row -> checkSalOutEntry.add(row.toString()));
        if (!ScpBillParamHelper.getBooleanBillParam("scp_saloutstock", "verifydraftbill").booleanValue()) {
            resultMap.putAll(ScpSalOutStockBillHelper.verifySalOutDraftData(checkSalOutEntry, Boolean.TRUE));
        }
        listEntryIds.clear();
        checkMap.clear();
        return resultMap;
    }

    public static boolean check(BeforeDoOperationEventArgs e, List<Long> orderEntryIds) {
        HashMap<String, String> customParamMap = new HashMap<String, String>(6);
        customParamMap.put("tgtbilltype", "scp_saloutstock");
        customParamMap.put("getvaluescene", "function");
        customParamMap.put("valueproperty", "relateoutstockbaseqty");
        Map<Long, Map<String, BigDecimal>> orderAvailableDataMap = ScpAvailableStockBasicQtyHelper.assembleOrderAvailableBasicQty(orderEntryIds, customParamMap);
        boolean flag = true;
        for (Long id : orderEntryIds) {
            Map<String, BigDecimal> availableQtyMap = orderAvailableDataMap.get(id);
            BigDecimal qty = availableQtyMap.get("qty");
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            flag = false;
        }
        return flag;
    }

    public static Map<String, Object> assembleEntryCheckMessage(Set<Long> orderBillIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        Set<Long> availableBill = ScpOrderBillHelper.assembleAvailableBill(orderBillIds);
        if (availableBill.isEmpty()) {
            resultMap.put("succed", Boolean.FALSE);
            String tips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ScpOrderBillHelper_5", (String)"scm-scp-business", (Object[])new Object[0]);
            resultMap.put("message", tips);
            return resultMap;
        }
        Set<Long> allSalOutEntry = ScpOrderBillHelper.assembleAvailableEntry(orderBillIds);
        if (allSalOutEntry.isEmpty()) {
            resultMap.put("succed", Boolean.FALSE);
            String tips = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8ba2\u5355\u884c\u5df2\u5168\u90e8\u751f\u6210\u53d1\u8d27\u5355\uff0c\u53ef\u70b9\u51fb\u201c\u53d1\u8d27\u67e5\u8be2\u201d\u6309\u94ae\u67e5\u770b\uff0c\u5982\u6709\u8349\u7a3f\u53d1\u8d27\u5355\u8bf7\u53ca\u65f6\u786e\u8ba4\u53d1\u8d27\u3002", (String)"ScpOrderBillHelper_3", (String)"scm-scp-business", (Object[])new Object[0]);
            resultMap.put("message", tips);
        }
        return resultMap;
    }

    public static Set<Long> assembleAvailableBill(Set<Long> orderBillIds) {
        HashSet<Long> allSalOutEntry = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_order", (String)"id,materialentry.id entryid", (QFilter[])new QFilter[]{new QFilter("id", "in", orderBillIds)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryid = row.getLong("entryid");
                allSalOutEntry.add(entryid);
            }
        }
        return allSalOutEntry;
    }

    public static Set<Long> assembleAvailableEntry(Set<Long> orderBillIds) {
        HashSet<Long> allSalOutEntry = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_order", (String)"id,materialentry.id entryid", (QFilter[])new QFilter[]{new QFilter("id", "in", orderBillIds).and(QFilter.of((String)"materialentry.relateoutstockqty < ( materialentry.qty + materialentry.sumrefundqty )", (Object[])new Object[0]))}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryid = row.getLong("entryid");
                allSalOutEntry.add(entryid);
            }
        }
        return allSalOutEntry;
    }

    public static ScpVerifyResult verifyCanSalOutStock(List<ListSelectedRow> selectedRows) {
        Map<Long, Boolean> executeRemote = ScpOrderBillHelper.executeRemote(selectedRows);
        ScpVerifyResult scpVerifyResult = new ScpVerifyResult();
        HashSet<Long> errorIds = new HashSet<Long>(1024);
        for (Map.Entry<Long, Boolean> entry : executeRemote.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            errorIds.add(entry.getKey());
        }
        scpVerifyResult.setMessage(ResManager.loadKDString((String)"\u5df2\u521b\u5efa\u4ea4\u8d27\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u901a\u8fc7\u8ba2\u5355\u76f4\u63a5\u53d1\u8d27\u3002\u8bf7\u8fdb\u5165\u4ea4\u8d27\u8ba1\u5212\u53d1\u8d27\u3002", (String)"ScpOrderBillHelper_4", (String)"scm-scp-business", (Object[])new Object[0]));
        scpVerifyResult.setData(errorIds);
        return scpVerifyResult;
    }

    private static Map<Long, Boolean> executeRemote(List<ListSelectedRow> selectedRows) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"verifyCanSalOutStock", (Object[])new Object[]{selectedRows});
    }

    public static List<DynamicObject> getLinkOrder(Set<String> poEntryIdValues) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1024);
        if (!poEntryIdValues.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"scp_order", (String)"logstatus,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.qty qty", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryIdValues)}, (String)"id");){
                DataSet groupDataSet = dataSet.groupBy(new String[]{"logstatus", "pobillid", "poentryid", "qty"}).finish();
                dynamicObjects.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(groupDataSet));
                groupDataSet.close();
            }
        }
        return dynamicObjects;
    }

    public static void updateSrcOrderData(Map<String, BigDecimal> poEntryBasicQtyMap, BillStatusEnum updateScene) {
        DynamicObject[] dynamicObjects;
        HashSet<Long> srcOrderIds = new HashSet<Long>(1024);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"updateSrcOrderData", (String)"scp_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryBasicQtyMap.keySet())}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                srcOrderIds.add(row.getLong("id"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])srcOrderIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"scp_order"))) {
            DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection("materialentry");
            DynamicObjectType rowsDynamicObjectType = rows.getDynamicObjectType();
            DynamicProperty relateOutStockQtyProperty = rowsDynamicObjectType.getProperty("relateoutstockqty");
            DynamicProperty relateOutStockBaseQtyProperty = rowsDynamicObjectType.getProperty("relateoutstockbaseqty");
            DynamicProperty sumOutStockQtyProperty = rowsDynamicObjectType.getProperty("sumoutstockqty");
            DynamicProperty sumOutStockBaseQtyProperty = rowsDynamicObjectType.getProperty("sumoutstockbaseqty");
            for (DynamicObject row : rows) {
                String poEntryId = row.getString("poentryid");
                BigDecimal orderQty = poEntryBasicQtyMap.get(poEntryId);
                String poEntryIdBasicQtyKey = poEntryId + "basicqty";
                BigDecimal orderBasicQty = poEntryBasicQtyMap.get(poEntryIdBasicQtyKey);
                if (orderBasicQty == null || orderQty == null) continue;
                if (BillStatusEnum.AUDIT.equals((Object)updateScene)) {
                    sumOutStockBaseQtyProperty.setValue((Object)row, (Object)orderBasicQty);
                    sumOutStockQtyProperty.setValue((Object)row, (Object)orderQty);
                    continue;
                }
                if (!BillStatusEnum.SAVE.equals((Object)updateScene)) continue;
                relateOutStockBaseQtyProperty.setValue((Object)row, (Object)orderBasicQty);
                relateOutStockQtyProperty.setValue((Object)row, (Object)orderQty);
            }
        }
        OrderUtil.updateOrderCfmStatus((DynamicObject[])dynamicObjects, new ArrayList<String>(poEntryBasicQtyMap.keySet()));
    }
}

