/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.helper.transfer.SRMTransferDataHelper;
import kd.scm.common.helper.transfer.entity.TransferInfo;
import kd.scm.common.k3cloud.util.K3CloudUtil;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.scp.business.ScpDeliveryScheduleHelper;
import kd.scm.scp.business.transfer.AutoStockSupportDefault;
import net.sf.json.JSONObject;

public final class ScpSalOutStockBillHelper {
    private static final Log log = LogFactory.getLog((String)ScpSalOutStockBillHelper.class.getName());

    public static Map<String, Object> clearXKAutoReceiptInfo(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> resultOfMap = new HashMap<String, Object>(2);
        resultOfMap.put("succed", Boolean.TRUE);
        resultOfMap.put("message", "");
        HashSet<String> idSet = new HashSet<String>(1024);
        for (DynamicObject dyn : dynamicObjects) {
            idSet.add(dyn.getString("id"));
        }
        StringBuilder idStr = new StringBuilder();
        for (String id : idSet) {
            idStr.append("'").append(id).append("'").append(",");
        }
        String str = "";
        if (idStr.length() > 0) {
            str = idStr.subSequence(0, idStr.toString().length() - 1).toString();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
        paramMap.put("FormId", "PUR_ReceiveBill");
        paramMap.put("FieldKeys", "FID,FDocumentStatus");
        paramMap.put("FilterString", "F_CQ_SalDeliId in (" + str + ")");
        paramMap.put("OrderString", "");
        paramMap.put("TopRowCount", 0);
        paramMap.put("StartRow", 0);
        paramMap.put("Limit", 0);
        Object querReturnStr = K3CloudUtil.sendStandardRequest(paramMap, (String)"ExecuteBillQuery", null);
        JSONArray returnList = JSONArray.parseArray((String)String.valueOf(querReturnStr));
        HashSet XKIdSet = new HashSet(1024);
        if (returnList.size() > 0) {
            for (Object obj : returnList) {
                List objList = (List)obj;
                if (objList.get(1).equals("Z") || objList.get(1).equals("D") || objList.get(1).equals("A")) {
                    XKIdSet.add(objList.get(0));
                    continue;
                }
                resultOfMap.put("succed", Boolean.FALSE);
                resultOfMap.put("message", ResManager.loadKDString((String)"\u53d1\u8d27\u5355\u91c7\u8d2d\u65b9\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u64a4\u9500\u53d1\u8d27\uff0c\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u5220\u9664\u5bf9\u5e94\u6536\u8d27\u5355\u3002", (String)"ScpBillUnauditPlugin_1", (String)"scm-scp-opplugin", (Object[])new Object[0]));
                break;
            }
        }
        if (XKIdSet.size() > 0) {
            JSONObject resultOfXkDelete;
            Map result;
            Map responseStatusMap;
            boolean IsSuccess;
            idStr.setLength(0);
            for (Object XKid : XKIdSet) {
                idStr.append(XKid).append(",");
            }
            String idStr1 = "";
            if (idStr.length() > 0) {
                idStr1 = idStr.subSequence(0, idStr.toString().length() - 1).toString();
            }
            paramMap.clear();
            paramMap.put("CreateOrgId", 0);
            paramMap.put("Numbers", new ArrayList(1024));
            paramMap.put("Ids", idStr1);
            paramMap.put("NetworkCtrl", "");
            Object deleteReturnStr1 = K3CloudUtil.sendStandardRequest(paramMap, (String)"Delete", (String)"PUR_ReceiveBill");
            StringBuilder errStr = new StringBuilder();
            if (null != deleteReturnStr1 && !(IsSuccess = Boolean.parseBoolean(String.valueOf((responseStatusMap = (Map)(result = (Map)(resultOfXkDelete = JSONObject.fromObject((Object)deleteReturnStr1)).get("Result")).get("ResponseStatus")).get("IsSuccess"))))) {
                List errmsgList = (List)responseStatusMap.get("Errors");
                for (String msg : errmsgList) {
                    errStr.append(msg).append("/n");
                }
            }
            if (errStr.length() > 0) {
                resultOfMap.put("succed", Boolean.FALSE);
                resultOfMap.put("message", errStr);
            }
        }
        return resultOfMap;
    }

    public static Map<Long, Set<Long>> assembleStdSalOutOrderMap(DynamicObject[] dynamicObjects) {
        LinkedHashMap<Long, Set<Long>> pushOrderData = new LinkedHashMap<Long, Set<Long>>(20);
        HashSet<Long> poEntryIdSet = null;
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String poBillId = row.getString("pobillid");
                String poEntryId = row.getString("poentryid");
                if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                poEntryIdSet = (HashSet<Long>)pushOrderData.get(Long.parseLong(poBillId));
                if (poEntryIdSet == null) {
                    poEntryIdSet = new HashSet<Long>();
                    poEntryIdSet.add(Long.parseLong(poEntryId));
                    pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
                    continue;
                }
                poEntryIdSet.add(Long.parseLong(poEntryId));
                pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
            }
        }
        return pushOrderData;
    }

    public static Map<String, String> assembleStdSalOutDataMap(DynamicObject[] dynamicObjects) {
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(50);
        for (DynamicObject bill : dynamicObjects) {
            String billNo = bill.getString("billno");
            String billId = bill.getString("id");
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String entryId = row.getString("id");
                String poBillId = row.getString("pobillid");
                String poEntryId = row.getString("poentryid");
                BigDecimal qty = row.getBigDecimal("qty");
                if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
                String suplot1 = row.getString("suplot");
                Date proddate1 = row.getDate("proddate");
                Date duedate1 = row.getDate("duedate");
                salOutInfoMap.put("qty_" + poEntryId, qty.toPlainString());
                salOutInfoMap.put("saloutNo_" + poEntryId, billNo);
                salOutInfoMap.put("saloutId_" + poEntryId, billId);
                salOutInfoMap.put("saloutEntryId_" + poEntryId, entryId);
                if (suplot1 != null) {
                    salOutInfoMap.put("suplot_" + poEntryId, suplot1);
                }
                if (proddate1 != null) {
                    salOutInfoMap.put("proddate_" + poEntryId, sf.format(proddate1));
                }
                if (duedate1 == null) continue;
                salOutInfoMap.put("duedate_" + poEntryId, sf.format(duedate1));
            }
        }
        return salOutInfoMap;
    }

    public static Set<Long> assembleStdCleanAutoReceive(DynamicObject[] dynamicObjects) {
        HashSet<Long> imReceiveBillIds = new HashSet<Long>(dynamicObjects.length);
        HashSet<String> salOutBillIds = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            String billId = bill.getString("id");
            salOutBillIds.add(billId);
        }
        if (!salOutBillIds.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"im_purreceivebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.srcsysbillid", "in", salOutBillIds)}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    imReceiveBillIds.add(row.getLong("id"));
                }
            }
        }
        return imReceiveBillIds;
    }

    public static Set<Long> assembleStdCleanAutoReceive(List<DynamicObject> dynamicObjects, String targetEntity) {
        Row row2;
        Throwable throwable;
        DataSet dataSet;
        HashSet<Long> imReceiveBillIds = new HashSet<Long>(dynamicObjects.size());
        HashSet<String> salOutBillIds = new HashSet<String>(dynamicObjects.size());
        HashSet<Long> salOutPuracceptbillBillIds = new HashSet<Long>(dynamicObjects.size());
        for (DynamicObject bill : dynamicObjects) {
            String billId = bill.getString("id");
            salOutBillIds.add(billId);
            salOutPuracceptbillBillIds.add(bill.getLong("id"));
        }
        if ("pm_puracceptbill".equals(targetEntity)) {
            if (!salOutPuracceptbillBillIds.isEmpty()) {
                dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)targetEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.soubillid", "in", salOutPuracceptbillBillIds)}, (String)"id");
                throwable = null;
                try {
                    while (dataSet.hasNext()) {
                        row2 = dataSet.next();
                        imReceiveBillIds.add(row2.getLong("id"));
                    }
                }
                catch (Throwable row2) {
                    throwable = row2;
                    throw row2;
                }
                finally {
                    if (dataSet != null) {
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row2) {
                                throwable.addSuppressed(row2);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
        } else if (!salOutBillIds.isEmpty()) {
            dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)targetEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.srcsysbillid", "in", salOutBillIds)}, (String)"id");
            throwable = null;
            try {
                while (dataSet.hasNext()) {
                    row2 = dataSet.next();
                    imReceiveBillIds.add(row2.getLong("id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        return imReceiveBillIds;
    }

    public static Set<String> assembleStdAutoReceiveBillNo(DynamicObject[] dynamicObjects) {
        HashSet<String> imReceiveBillIds = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : dynamicObjectCollection) {
                String autorecbillno = row.getString("autorecbillno");
                if (autorecbillno.trim().isEmpty()) continue;
                imReceiveBillIds.add(autorecbillno);
            }
        }
        return imReceiveBillIds;
    }

    public static Set<String> assembleStdAutoReceiveBillNo(List<DynamicObject> dynamicObjects) {
        HashSet<String> imReceiveBillIds = new HashSet<String>(dynamicObjects.size());
        for (DynamicObject bill : dynamicObjects) {
            String autorecbillno = bill.getString("autorecbillno");
            if (autorecbillno.trim().isEmpty()) continue;
            imReceiveBillIds.add(autorecbillno);
        }
        return imReceiveBillIds;
    }

    public static Map<String, Object> autoEASSalOutStock(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        return resultMap;
    }

    public static Map<String, Object> cleanAutoTrdStockBill(DynamicObject[] dynamicObjects, String flowNumber) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "execute succed");
        ArrayList<String> salOutBillIds = new ArrayList<String>(dynamicObjects.length);
        HashSet<String> numberSet = new HashSet<String>(16);
        for (DynamicObject bill : dynamicObjects) {
            String billId = bill.getString("id");
            salOutBillIds.add(billId);
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String autoBillNo = row.getString("autorecbillno");
                if (autoBillNo == null || autoBillNo.isEmpty()) continue;
                numberSet.add(autoBillNo);
            }
        }
        log.info(((Object)numberSet).toString());
        if (!numberSet.isEmpty()) {
            try {
                Map iscResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{flowNumber, salOutBillIds});
                if (!iscResultMap.isEmpty()) {
                    resultMap.put("message", iscResultMap.toString());
                    resultMap.put("succed", Boolean.TRUE);
                }
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"clearSaloutEntryAutoRecBillno", (Object[])new Object[]{numberSet});
            }
            catch (Throwable throwable) {
                resultMap.put("message", throwable.getMessage());
                resultMap.put("succed", Boolean.FALSE);
                log.error(ExceptionUtil.getStackTrace((Throwable)throwable));
            }
        }
        return resultMap;
    }

    public static Map<String, String> assembleAutoExtStockBill(DynamicObject bill, Map<String, String> sdkEntryMap) {
        LinkedHashMap<String, String> extStockData = new LinkedHashMap<String, String>(16);
        extStockData.putAll(SDKTransferHelper.executeTransfer((DynamicObject)bill, sdkEntryMap));
        return extStockData;
    }

    public static Map<String, String> assembleAutoExtEntryPro() {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(16);
        TransferInfo transferInfo = SRMTransferDataHelper.getTransferInfo((String)"srmautostock");
        Map transferTypeMap = transferInfo.getTransferTypeMap();
        if (!transferTypeMap.isEmpty()) {
            String number = transferTypeMap.getOrDefault("number", "SCM_SCP_AUTOSTOCK_SUPPORT");
            String anInterface = transferTypeMap.getOrDefault("interface", "kd.sdk.scm.scp.extpoint.IAutoStockSupport");
            Class type = null;
            try {
                type = TypesContainer.getOrRegister((String)anInterface);
                sdkEntryMap.putAll(SDKTransferHelper.getSDKEntryMap((String)number, (Class)type, AutoStockSupportDefault.class));
            }
            catch (Throwable throwable) {
                log.error(throwable);
            }
        }
        return sdkEntryMap;
    }

    public static void writeBackScheduleQty(DynamicObject[] dynamicObjects, Boolean isSave) {
        LinkedHashMap<Long, Map<String, BigDecimal>> paramMap = new LinkedHashMap<Long, Map<String, BigDecimal>>(56);
        for (DynamicObject bill : dynamicObjects) {
            for (DynamicObject row : bill.getDynamicObjectCollection("materialentry")) {
                String dsentryid = row.getString("dsentryid");
                if (dsentryid.isEmpty() || "0".equals(dsentryid)) continue;
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal basicqty = row.getBigDecimal("basicqty");
                HashMap<String, BigDecimal> dataMap = (HashMap<String, BigDecimal>)paramMap.get(Long.parseLong(dsentryid));
                if (isSave.booleanValue()) {
                    if (dataMap != null) {
                        dataMap.put("qty", ((BigDecimal)dataMap.get("qty")).add(qty));
                        dataMap.put("basicqty", ((BigDecimal)dataMap.get("basicqty")).add(basicqty));
                        continue;
                    }
                    dataMap = new HashMap<String, BigDecimal>(2);
                    dataMap.put("qty", qty);
                    dataMap.put("basicqty", basicqty);
                    paramMap.put(Long.parseLong(dsentryid), dataMap);
                    continue;
                }
                BigDecimal revertQty = qty.negate();
                BigDecimal revertBasicQty = basicqty.negate();
                if (dataMap != null) {
                    dataMap.put("qty", ((BigDecimal)dataMap.get("qty")).add(revertQty));
                    dataMap.put("basicqty", ((BigDecimal)dataMap.get("basicqty")).add(revertBasicQty));
                    continue;
                }
                dataMap = new HashMap(2);
                dataMap.put("qty", revertQty);
                dataMap.put("basicqty", revertBasicQty);
                paramMap.put(Long.parseLong(dsentryid), dataMap);
            }
        }
        if (!paramMap.isEmpty()) {
            ScpDeliveryScheduleHelper.writeBackRelateSalOutQty(paramMap);
            paramMap.clear();
        }
    }

    public static Map<String, Object> verifySalOutDraftData(Set<String> orderEntryFilterIds, Boolean dsDataIsNull) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        QFilter qFilter = dsDataIsNull != false ? new QFilter("materialentry.dsentryid", "=", (Object)" ") : new QFilter("materialentry.dsentryid", "!=", (Object)" ");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_saloutstock", (String)"id,billno,materialentry.pobillno pobillno,materialentry.srcbillid srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", orderEntryFilterIds).and(new QFilter("billstatus", "=", (Object)"A")).and(qFilter)}, (String)"id");){
            HashSet<Long> salOutStockBillIds = new HashSet<Long>(16);
            LinkedHashMap<String, Set> poBillNoOfSalOutBillNos = new LinkedHashMap<String, Set>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long salId = row.getLong("id");
                String billno = row.getString("billno");
                String pobillno = row.getString("pobillno");
                salOutStockBillIds.add(salId);
                HashSet<String> tempSet = (HashSet<String>)poBillNoOfSalOutBillNos.get(pobillno);
                if (tempSet != null) {
                    tempSet.add(billno);
                    continue;
                }
                tempSet = new HashSet<String>(16);
                tempSet.add(billno);
                poBillNoOfSalOutBillNos.put(pobillno, tempSet);
            }
            if (!salOutStockBillIds.isEmpty() && !poBillNoOfSalOutBillNos.isEmpty()) {
                resultMap.put("data", salOutStockBillIds);
                String tips = ResManager.loadKDString((String)"\u8ba2\u5355", (String)"ScpOrderBillHelper_0", (String)"scm-scp-business", (Object[])new Object[0]);
                String tips2 = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8349\u7a3f\u72b6\u6001\u7684\u53d1\u8d27\u5355\u3002", (String)"ScpOrderBillHelper_1", (String)"scm-scp-business", (Object[])new Object[0]);
                String tips3 = ResManager.loadKDString((String)"\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ScpOrderBillHelper_2", (String)"scm-scp-business", (Object[])new Object[0]);
                StringBuilder message = new StringBuilder();
                poBillNoOfSalOutBillNos.forEach((key, value) -> message.append(tips).append((String)key).append(tips2).append("\uff0c").append(tips3).append("\t\n"));
                poBillNoOfSalOutBillNos.clear();
                resultMap.put("message", message.toString());
            }
        }
        return resultMap;
    }

    public static Map<String, BigDecimal> getPoEntryIdBasicQtyMap(DynamicObject[] dynamicObjects, BillStatusEnum updateScene) {
        HashMap<String, BigDecimal> poEntryBasicQtyMap = new HashMap<String, BigDecimal>(64);
        HashSet<String> srcPoEntryIds = new HashSet<String>(1024);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject row2 : rows) {
                String poEntryId = row2.getString("poentryid");
                srcPoEntryIds.add(poEntryId);
            }
        }
        QFilter qFilter = new QFilter("materialentry.poentryid", "in", srcPoEntryIds).and(new QFilter("billstatus", "=", (Object)updateScene.getVal()));
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"getPoEntryIdBasicQtyMap", (String)"scp_saloutstock", (String)"materialentry.material material,materialentry.basicunit basicunit,materialentry.unit unit,materialentry.qty qty,materialentry.basicqty basicqty,materialentry.entrystatus entrystatus, materialentry.sumreceiptqty sumreceiptqty,materialentry.suminstockqty suminstockqty,materialentry.poentryid poentryid,materialentry.sumreceiptbaseqty sumreceiptbaseqty,materialentry.suminstockbaseqty suminstockbaseqty", (QFilter[])new QFilter[]{qFilter}, (String)"id");
        DataSet dataSet = queryDataSet.copy();
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        while (queryDataSet.hasNext()) {
            Row row3 = queryDataSet.next();
            materialIds.add(row3.getLong("material"));
            unitIds.add(row3.getLong("unit"));
            unitIds.add(row3.getLong("basicunit"));
        }
        Map materialCaches = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map measureunitsCache = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        while (dataSet.hasNext()) {
            BigDecimal orderBasicQty;
            Row row4 = dataSet.next();
            String poEntryId = row4.getString("poentryid");
            String poEntryIdBasicQtyKey = poEntryId + "basicqty";
            BigDecimal basicQty = row4.getBigDecimal("basicqty");
            BigDecimal qty = row4.getBigDecimal("qty");
            String entrystatus = row4.getString("entrystatus");
            Object material = row4.get("material");
            Object unit = row4.get("unit");
            Object basicunit = row4.get("basicunit");
            BigDecimal suminstockqty = row4.getBigDecimal("suminstockqty");
            BigDecimal suminstockbaseqty = BigDecimal.ZERO;
            if (suminstockqty.compareTo(BigDecimal.ZERO) > 0) {
                suminstockbaseqty = suminstockbaseqty.compareTo(BigDecimal.ZERO) == 0 ? (unit.equals(basicunit) ? row4.getBigDecimal("suminstockbaseqty") : CommonUtil.getDesQtyConv((DynamicObject)((DynamicObject)materialCaches.get(material)), (DynamicObject)((DynamicObject)measureunitsCache.get(unit)), (BigDecimal)suminstockqty, (DynamicObject)((DynamicObject)measureunitsCache.get(basicunit)))) : row4.getBigDecimal("suminstockbaseqty");
            }
            BigDecimal sumreceiptqty = row4.getBigDecimal("sumreceiptqty");
            BigDecimal sumreceiptBasicqty = row4.getBigDecimal("sumreceiptbaseqty");
            if (sumreceiptqty.compareTo(BigDecimal.ZERO) > 0) {
                sumreceiptBasicqty = sumreceiptBasicqty.compareTo(BigDecimal.ZERO) == 0 ? (unit.equals(basicunit) ? row4.getBigDecimal("sumreceiptbaseqty") : CommonUtil.getDesQtyConv((DynamicObject)((DynamicObject)materialCaches.get(material)), (DynamicObject)((DynamicObject)measureunitsCache.get(unit)), (BigDecimal)sumreceiptqty, (DynamicObject)((DynamicObject)measureunitsCache.get(basicunit)))) : row4.getBigDecimal("sumreceiptbaseqty");
            }
            BigDecimal maxStockQty = null;
            BigDecimal maxStockBasicQty = null;
            BigDecimal orderQty = (BigDecimal)poEntryBasicQtyMap.get(poEntryId);
            if (orderQty == null) {
                orderQty = BigDecimal.ZERO;
            }
            if ((orderBasicQty = (BigDecimal)poEntryBasicQtyMap.get(poEntryIdBasicQtyKey)) == null) {
                orderBasicQty = BigDecimal.ZERO;
            }
            if (suminstockqty.compareTo(sumreceiptqty) >= 0) {
                maxStockQty = suminstockqty;
                maxStockBasicQty = suminstockbaseqty;
            } else {
                maxStockQty = sumreceiptqty;
                maxStockBasicQty = sumreceiptBasicqty;
            }
            if ("B".equals(entrystatus)) {
                orderBasicQty = orderBasicQty.add(maxStockBasicQty);
                orderQty = orderQty.add(maxStockQty);
            } else if ("A".equals(entrystatus)) {
                orderBasicQty = orderBasicQty.add(basicQty);
                orderQty = orderQty.add(qty);
            }
            poEntryBasicQtyMap.put(poEntryId, orderQty);
            poEntryBasicQtyMap.put(poEntryIdBasicQtyKey, orderBasicQty);
        }
        BigDecimal zero = BigDecimal.ZERO;
        srcPoEntryIds.forEach(row -> {
            String poEntryIdBasicQtyKey = row + "basicqty";
            if (!poEntryBasicQtyMap.containsKey(row)) {
                poEntryBasicQtyMap.put((String)row, zero);
            }
            if (!poEntryBasicQtyMap.containsKey(poEntryIdBasicQtyKey)) {
                poEntryBasicQtyMap.put(poEntryIdBasicQtyKey, zero);
            }
        });
        if (log.isInfoEnabled()) {
            log.info("ScpSalOutStockBillHelper#getPoEntryIdBasicQtyMap#poEntryBasicQtyMap:{}", (Object)SerializationUtils.toJsonString(poEntryBasicQtyMap));
        }
        return poEntryBasicQtyMap;
    }

    public static String getConsumeMoment() {
        String createuserstrategy = null;
        try {
            createuserstrategy = String.valueOf(ParamUtil.getBillParam((String)"scp_moduleconsume", (String)"consumemoment"));
        }
        catch (Exception exception) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
        }
        return StringUtils.isEmpty((Object)createuserstrategy) ? "order" : createuserstrategy;
    }

    public static List<DynamicObject> buildDynamicObjectData(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1024);
        ArrayList allRows = new ArrayList(1024);
        for (DynamicObject bill : dynamicObjects) {
            allRows.addAll(bill.getDynamicObjectCollection("materialentry"));
        }
        final Iterator allRowsIterator = allRows.iterator();
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("entryid", (DataType)DataType.LongType), new Field("jointdatachannelid", (DataType)DataType.StringType), new Field("poentryid", (DataType)DataType.StringType), new Field("businesstype", (DataType)DataType.StringType)});
        DataSet dataSet = Algo.create((String)"buildDynamicObjectData").createDataSet((Iterator)new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return allRowsIterator.hasNext();
            }

            @Override
            public Object[] next() {
                DynamicObject row = (DynamicObject)allRowsIterator.next();
                DynamicObject bill = (DynamicObject)row.getParent();
                Long id = bill.getLong("id");
                String billNo = bill.getString("id");
                Long entryid = row.getLong("id");
                String jointdatachannelid = row.getString("jointdatachannelid");
                String poentryid = row.getString("poentryid");
                DynamicObject businesstype = bill.getDynamicObject("businesstype");
                String businesstypeNumber = "";
                if (businesstype != null) {
                    businesstypeNumber = businesstype.getString("number");
                }
                return new Object[]{id, billNo, entryid, jointdatachannelid, poentryid, businesstypeNumber};
            }
        }, rowMeta);
        ORM orm = ORM.create();
        dynamicObjectList.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(dataSet));
        return dynamicObjectList;
    }
}

