/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;

public final class ScpSalOutStockOffsetJointHelper {
    private static final Log log = LogFactory.getLog(ScpSalOutStockOffsetJointHelper.class);

    public static ScDataHandleResult executeOrderConfirm(DynamicObject[] orderBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("orderconfirm", ScpSalOutStockOffsetJointHelper.getChannelIds(orderBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"orderconfirm", (DynamicObject[])orderBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult executeOrderUnConfirm(DynamicObject[] orderBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("orderunconfirm", ScpSalOutStockOffsetJointHelper.getChannelIds(orderBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"orderunconfirm", (DynamicObject[])orderBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult executeOrderReject(DynamicObject[] orderBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("orderreject", ScpSalOutStockOffsetJointHelper.getChannelIds(orderBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"orderreject", (DynamicObject[])orderBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult executeSalOutAudit(DynamicObject[] salOutStockBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("saloutstockaudit", ScpSalOutStockOffsetJointHelper.getChannelIds(salOutStockBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"saloutstockaudit", (DynamicObject[])salOutStockBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult executeSalOutUnAudit(DynamicObject[] salOutStockBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("saloutstockunaudit", ScpSalOutStockOffsetJointHelper.getChannelIds(salOutStockBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"saloutstockunaudit", (DynamicObject[])salOutStockBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult executeAuditAutoCreateBill(DynamicObject[] salOutStockBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("scpsalstockautoreceive", ScpSalOutStockOffsetJointHelper.getChannelIds(salOutStockBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"scpsaloutstocktautoreceive", (DynamicObject[])salOutStockBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult executeUnAuditAutoDeleteBill(DynamicObject[] salOutStockBills) {
        ScDataHandleResult scDataHandleResult = null;
        if (ScpSalOutStockOffsetJointHelper.verifyNeedOffset("scpsalstockdeletereceive", ScpSalOutStockOffsetJointHelper.getChannelIds(salOutStockBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"scpsaloutstockdeletereceive", (DynamicObject[])salOutStockBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    private static boolean verifyNeedOffset(String defineScene, Collection<String> channelIds) {
        HashMap<String, Boolean> channelEnableMap = new HashMap<String, Boolean>(channelIds.size());
        Map dataExecuteSchemeCacheMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_dataexecutescheme", (QFilter[])new QFilter[]{new QFilter("executescene.number", "=", (Object)defineScene).and(new QFilter("executechannel.id", "in", channelIds))});
        if (!dataExecuteSchemeCacheMap.isEmpty()) {
            for (Map.Entry entry : dataExecuteSchemeCacheMap.entrySet()) {
                DynamicObject entryValue = (DynamicObject)entry.getValue();
                String executeChannel = entryValue.getString("executechannel.id");
                boolean enable = entryValue.getBoolean("enable");
                if (!enable) continue;
                channelEnableMap.put(executeChannel, true);
            }
        }
        return channelEnableMap.size() < channelIds.size();
    }

    private static Collection<String> getChannelIds(DynamicObject[] dynamicObjects) {
        HashSet<String> jointDataChannelIds = new HashSet<String>(8);
        HashMap<Object, String> logMap = new HashMap<Object, String>(8);
        String jointChannelId = SystemJointChannelHelper.getDefaultJointChannelId();
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            DynamicProperty jointChannelProperty = rows.getDynamicObjectType().getProperty("jointdatachannelid");
            if (jointChannelProperty != null) {
                try {
                    DynamicObject row;
                    Object jointChannelIdValue;
                    if (!rows.isEmpty() && (jointChannelIdValue = jointChannelProperty.getValue((Object)(row = (DynamicObject)rows.get(0)))) != null && !"".equals(jointChannelIdValue)) {
                        jointChannelId = String.valueOf(jointChannelIdValue);
                    }
                }
                catch (RuntimeException runtimeException) {
                    logMap.put(bill.getPkValue(), runtimeException.getMessage());
                }
                jointDataChannelIds.add(jointChannelId);
                continue;
            }
            jointDataChannelIds.add(jointChannelId);
        }
        log.info("getChannelIds# logMap={}", (Object)JSON.toJSONString(logMap));
        return jointDataChannelIds;
    }
}

