/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.scp.business.ScpAvailableStockBasicQtyHelper;

public class ScpBillUtil {
    private ScpBillUtil() {
    }

    public static void updateEntryBasicQtyByLineIndex(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        BigDecimal newQty = dynamicObject.getBigDecimal("qty");
        DynamicObject materialObj = dynamicObject.getDynamicObject("material");
        DynamicObject unitObj = dynamicObject.getDynamicObject("unit");
        DynamicObject basicUnitObj = dynamicObject.getDynamicObject("basicunit");
        DynamicObject asstUnitObj = dynamicObject.getDynamicObject("asstunit");
        if (materialObj == null) {
            dynamicObject.set("basicqty", (Object)newQty);
            dynamicObject.set("asstqty", (Object)newQty);
        }
        if (null != materialObj && null != unitObj && null != basicUnitObj) {
            BigDecimal basicQty = null;
            basicQty = unitObj.getPkValue().equals(basicUnitObj.getPkValue()) ? newQty : CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)newQty, (DynamicObject)basicUnitObj);
            basicQty = null == basicQty ? BigDecimal.ZERO : basicQty;
            dynamicObject.set("basicqty", (Object)basicQty);
        }
        if (null != materialObj && null != unitObj && null != asstUnitObj) {
            BigDecimal asstQty = null;
            asstQty = unitObj.getPkValue().equals(asstUnitObj.getPkValue()) ? newQty : CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)newQty, (DynamicObject)asstUnitObj);
            asstQty = null == asstQty ? BigDecimal.ZERO : asstQty;
            dynamicObject.set("asstqty", (Object)asstQty);
        }
    }

    public static boolean compareQtyAndSumQty(DynamicObject dynamicObject, int indexRow) {
        HashMap<String, BigDecimal> coreEntryIdBasicQtyMap = new HashMap<String, BigDecimal>(1);
        DynamicObjectCollection materialDynamicCollection = dynamicObject.getDynamicObjectCollection("materialentry");
        if (materialDynamicCollection == null) {
            return false;
        }
        DynamicObject entryDynamicObject = (DynamicObject)materialDynamicCollection.get(indexRow);
        if (entryDynamicObject == null) {
            return false;
        }
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put("valueproperty", "sumoutstockbaseqty");
        String poentryid = entryDynamicObject.getString("poentryid");
        coreEntryIdBasicQtyMap.put(poentryid, entryDynamicObject.getBigDecimal("basicqty"));
        Map<String, BigDecimal> assembleOrderVerifyBasicQty = ScpAvailableStockBasicQtyHelper.assembleOrderVerifyBasicQty(coreEntryIdBasicQtyMap, customParamMap);
        if (assembleOrderVerifyBasicQty.isEmpty()) {
            return false;
        }
        BigDecimal availableBasicQty = assembleOrderVerifyBasicQty.get(poentryid);
        BigDecimal coreAvailableBasicQty = coreEntryIdBasicQtyMap.getOrDefault(poentryid, BigDecimal.ZERO);
        return availableBasicQty != null && availableBasicQty.compareTo(coreAvailableBasicQty) < 0;
    }

    private static DynamicObject getScpOrderObject(String poentryid) {
        QFilter filter = new QFilter("materialentry.poentryid", "=", (Object)poentryid);
        String selectFields = "materialentry.poentryid as poentryid,materialentry.sumoutstockqty as sumOutStockQty,materialentry.qty as qty,materialentry.iscontrolqty as iscontrolqty,materialentry.taxamount as taxamount,materialentry.iscontrolamountup as iscontrolamountup,materialentry.sumapaccepttaxamount as sumapaccepttaxamount";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"scp_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return dynamicObject;
    }

    public static void resetQty(DynamicObject dynamicObject, BigDecimal cacheQty, int indexRow) {
        DynamicObjectCollection materialDynamicCollection = dynamicObject.getDynamicObjectCollection("materialentry");
        if (materialDynamicCollection == null) {
            return;
        }
        DynamicObject entryDynamicObject = (DynamicObject)materialDynamicCollection.get(indexRow);
        if (entryDynamicObject == null) {
            return;
        }
        BigDecimal newQty = CommonUtil.getBigDecimalPro((Object)entryDynamicObject.getBigDecimal("qty"));
        if (null != cacheQty && newQty.compareTo(cacheQty) > 0) {
            entryDynamicObject.set("qty", (Object)cacheQty);
        }
    }

    @Deprecated
    public static BigDecimal getScpOrderOutStockQty(String billNo, Long materialId) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        filter.and("materialentry.id", "=", (Object)materialId);
        String selectFields = "materialentry.sumoutstockqty as sumOutStockQty,materialentry.qty as qty";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"scp_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (null == dynamicObject || dynamicObject.getBigDecimal("qty") == null) {
            return BigDecimal.ZERO;
        }
        return dynamicObject.getBigDecimal("qty").subtract(dynamicObject.getBigDecimal("sumoutstockqty"));
    }

    public static void updateEntryBasicQtyAll(DynamicObjectCollection dynamicObjectCollection) {
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            BigDecimal basicQty = dynamicObject.getBigDecimal("basicqty");
            if (basicQty == null || basicQty.compareTo(BigDecimal.ZERO) != 0) continue;
            ScpBillUtil.updateEntryBasicQtyByLineIndex(dynamicObject);
        }
    }

    public static void updateEntryBasicQtyByLineIndex(String propertyName, String basePropertyName, DynamicObject entryRowEntity) {
        if (entryRowEntity == null) {
            return;
        }
        BigDecimal newQty = entryRowEntity.getBigDecimal(propertyName);
        DynamicObject materialObj = entryRowEntity.getDynamicObject("submaterial");
        DynamicObject unitObj = entryRowEntity.getDynamicObject("subunit");
        DynamicObject basicUnitObj = entryRowEntity.getDynamicObject("subbaseunit");
        if (materialObj == null) {
            entryRowEntity.set(basePropertyName, (Object)newQty);
        }
        if (null != materialObj && null != unitObj && null != basicUnitObj) {
            BigDecimal basicQty = null;
            basicQty = unitObj.getPkValue().equals(basicUnitObj.getPkValue()) ? newQty : CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)newQty, (DynamicObject)basicUnitObj);
            basicQty = null == basicQty ? BigDecimal.ZERO : basicQty;
            entryRowEntity.set(basePropertyName, (Object)basicQty);
        }
    }

    public static boolean compareTaxAmountAndSumAmount(DynamicObject dynamicObject, int indexRow) {
        DynamicObjectCollection materialDynamicCollection = dynamicObject.getDynamicObjectCollection("materialentry");
        if (materialDynamicCollection == null) {
            return false;
        }
        DynamicObject entryDynamicObject = (DynamicObject)materialDynamicCollection.get(indexRow);
        if (entryDynamicObject == null) {
            return false;
        }
        BigDecimal taxAmount = entryDynamicObject.getBigDecimal("taxamount");
        String poentryid = entryDynamicObject.getString("poentryid");
        DynamicObject scpOrderObject = ScpBillUtil.getScpOrderObject(poentryid);
        BigDecimal sumApAcceptTaxAmount = BigDecimal.ZERO;
        if (scpOrderObject != null) {
            if (scpOrderObject.getBoolean("iscontrolamountup")) {
                return false;
            }
            if (scpOrderObject.getBigDecimal("sumapaccepttaxamount") != null) {
                sumApAcceptTaxAmount = scpOrderObject.getBigDecimal("taxamount").subtract(scpOrderObject.getBigDecimal("sumapaccepttaxamount"));
            }
        }
        return taxAmount.compareTo(sumApAcceptTaxAmount) > 0;
    }
}

