/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.helper;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.MaterialUtil;

public class ShelfLifeDateUtil {
    public static final String ENABLESHELFLIFEMGR = "enableshelflifemgr";
    public static final String SHELFLIFEUNIT = "shelflifeunit";
    public static final String SHELFLIFE = "shelflife";
    public static final String CALCULATIONFORENDDATE = "calculationforenddate";
    public static final String CALFORENDDATERULE_0 = "0";
    public static final String CALFORENDDATERULE_1 = "1";
    public static final String CALFORENDDATERULE_2 = "2";
    public static final String SHELFLIFE_DATEUNIT_DAY = "day";
    public static final String SHELFLIFE_DATEUNIT_MONTH = "month";
    public static final String SHELFLIFE_DATEUNIT_YEAR = "year";

    public static Date shelflifeDateCal(String shelflifeunit, int shelflife, Date inDate, String calculationforenddate) {
        if (SHELFLIFE_DATEUNIT_DAY.equals(shelflifeunit)) {
            if (shelflife > 36500) {
                shelflife = 36500;
            }
            if (CALFORENDDATERULE_0.equals(calculationforenddate)) {
                return DateUtil.addDays((Date)inDate, (int)shelflife);
            }
            if (CALFORENDDATERULE_1.equals(calculationforenddate)) {
                return DateUtil.addDays((Date)inDate, (int)(shelflife > 0 ? shelflife - 1 : shelflife + 1));
            }
            if (CALFORENDDATERULE_2.equals(calculationforenddate)) {
                return DateUtil.getLastMonthEndDayByDate((Date)DateUtil.addDays((Date)inDate, (int)shelflife));
            }
        }
        if (SHELFLIFE_DATEUNIT_MONTH.equals(shelflifeunit)) {
            if (shelflife > 1200) {
                shelflife = 1200;
            }
            if (CALFORENDDATERULE_0.equals(calculationforenddate)) {
                return DateUtil.addMonth((Date)inDate, (int)shelflife);
            }
            if (CALFORENDDATERULE_1.equals(calculationforenddate)) {
                Date date = DateUtil.addMonth((Date)inDate, (int)shelflife);
                if (shelflife < 0) {
                    return DateUtil.getNextDay((Date)date);
                }
                return DateUtil.addDays((Date)date, (int)-1);
            }
            if (CALFORENDDATERULE_2.equals(calculationforenddate)) {
                return DateUtil.getLastMonthEndDayByDate((Date)DateUtil.addMonth((Date)inDate, (int)shelflife));
            }
        }
        if (SHELFLIFE_DATEUNIT_YEAR.equals(shelflifeunit)) {
            if (shelflife > 99) {
                shelflife = 99;
            }
            if (CALFORENDDATERULE_0.equals(calculationforenddate)) {
                return DateUtil.addYear((Date)inDate, (int)shelflife);
            }
            if (CALFORENDDATERULE_1.equals(calculationforenddate)) {
                Date date = DateUtil.addYear((Date)inDate, (int)shelflife);
                if (shelflife < 0) {
                    return DateUtil.getNextDay((Date)date);
                }
                return DateUtil.addDays((Date)date, (int)-1);
            }
            if (CALFORENDDATERULE_2.equals(calculationforenddate)) {
                return DateUtil.getLastMonthEndDayByDate((Date)DateUtil.addYear((Date)inDate, (int)shelflife));
            }
        }
        return DateUtil.addDays((Date)inDate, (int)shelflife);
    }

    private static DynamicObject getMaterialInvInfo(DynamicObject entry, DynamicObject org) {
        if (entry == null) {
            return null;
        }
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null || org == null) {
            return null;
        }
        HashSet<Long> materialSet = new HashSet<Long>(1);
        materialSet.add(Long.parseLong(material.getPkValue().toString()));
        long orgid = Long.parseLong(org.getPkValue().toString());
        String selecor = "materialid,id,enablelot,enableshelflifemgr,shelflifeunit,shelflife,calculationforenddate";
        Map materialMap = MaterialUtil.getMaterialInventoryinfo(materialSet, (long)orgid, (String)selecor);
        DynamicObject materialInvInfo = (DynamicObject)materialMap.get(material.getPkValue());
        return materialInvInfo;
    }

    public static String changeProduceDate(DynamicObject entry, Date oldValue, Date date, DynamicObject org, int rowIndex) {
        if (date == null) {
            return null;
        }
        DynamicObject materialInvInfo = ShelfLifeDateUtil.getMaterialInvInfo(entry, org);
        if (materialInvInfo == null || !materialInvInfo.getBoolean(ENABLESHELFLIFEMGR)) {
            return null;
        }
        String shelflifeUnit = materialInvInfo.getString(SHELFLIFEUNIT);
        int shelflife = materialInvInfo.getInt(SHELFLIFE);
        String calculationForEndDate = materialInvInfo.getString(CALCULATIONFORENDDATE);
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal(shelflifeUnit, shelflife, date, calculationForEndDate);
        String msg = null;
        if (expirydate.before(date)) {
            String newExpirydateStr = DateUtil.date2str((Date)expirydate, (String)"yyyy-MM-dd");
            String newProduceDateStr = DateUtil.date2str((Date)date, (String)"yyyy-MM-dd");
            msg = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7269\u6599[{1}]\u7684\u5230\u671f\u65e5\u671f[{2}]\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f[{3}]\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4 \u7269\u6599\u5e93\u5b58\u4fe1\u606f \u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ShelfLifeDateUtil_0", (String)"scm-scp-common", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            entry.set("proddate", null);
        } else {
            entry.set("duedate", (Object)expirydate);
        }
        return msg;
    }

    public static String changeExpiryDate(DynamicObject entry, Date oldValue, Date date, DynamicObject org, int rowIndex) {
        if (oldValue != null || date == null) {
            return null;
        }
        DynamicObject materialInvInfo = ShelfLifeDateUtil.getMaterialInvInfo(entry, org);
        if (materialInvInfo == null || !materialInvInfo.getBoolean(ENABLESHELFLIFEMGR)) {
            return null;
        }
        String shelflifeUnit = materialInvInfo.getString(SHELFLIFEUNIT);
        int shelflife = materialInvInfo.getInt(SHELFLIFE);
        String calculationForEndDate = materialInvInfo.getString(CALCULATIONFORENDDATE);
        Date producedate = entry.getDate("proddate");
        String msg = null;
        if (!CALFORENDDATERULE_2.equals(calculationForEndDate)) {
            producedate = ShelfLifeDateUtil.shelflifeDateCal(shelflifeUnit, shelflife * -1, date, calculationForEndDate);
            entry.set("proddate", (Object)producedate);
        } else if (producedate != null && date.before(producedate)) {
            String newExpirydateStr = DateUtil.date2str((Date)date, (String)"yyyy-MM-dd");
            String newProduceDateStr = DateUtil.date2str((Date)producedate, (String)"yyyy-MM-dd");
            msg = String.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7684\u7269\u6599\u201c{1}\u201d\u5230\u671f\u65e5\u671f\u201c{2}\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c{3}\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\uff0c\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ShelfLifeDateUtil_1", (String)"scm-scp-common", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            entry.set("duedate", null);
        } else {
            entry.set("proddate", (Object)producedate);
        }
        return msg;
    }
}

