/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;

public final class IndexUtil {
    private static Map<String, Map<String, Object>> buildFilterMap(Date date) {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>(20);
        HashMap<String, Date> dateMap = new HashMap<String, Date>(20);
        dateMap.put("<=", DateUtil.getFormatDateEndMaxDate((Date)date));
        dateMap.put(">=", DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)5));
        filterMap.put("billdate", dateMap);
        filterMap.putAll(BizPartnerUtil.assembleBizPartner());
        return filterMap;
    }

    public static final Map<String, Object> assembleOrderCount() {
        Date today = new Date();
        ORM orm = ORM.create();
        DataSet resultData = null;
        DataSet dataSet = ORMUtil.queryDataSet((String)"scp_order", (String)"id,year(billdate)*100+month(billdate) as month", IndexUtil.buildFilterMap(today), (String)"billdate");
        resultData = dataSet.groupBy(new String[]{"month"}).count().finish();
        DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(resultData);
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(dynamicObjectCollection.size());
        ArrayList dateList = DateUtil.assembleContinuousMonth((Date)today);
        for (String month : dateList) {
            resultMap.put(month, 0);
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String month = dynamicObject.getString("month");
            Integer object = dynamicObject.getInt("count");
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!((String)entry.getKey()).equals(month)) continue;
                entry.setValue(object);
            }
        }
        return resultMap;
    }

    public static final Map<String, BigDecimal> assembleOrderAmount() {
        Date today = new Date();
        ORM orm = ORM.create();
        DataSet resultData = null;
        DataSet dataSet = ORMUtil.queryDataSet((String)"scp_order", (String)"id,year(billdate)*100+month(billdate) as month,sumtaxamount", IndexUtil.buildFilterMap(today), (String)"billdate");
        resultData = dataSet.groupBy(new String[]{"month"}).sum("sumtaxamount").finish();
        DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(resultData);
        LinkedHashMap<String, BigDecimal> resultMap = new LinkedHashMap<String, BigDecimal>(dynamicObjectCollection.size());
        ArrayList dateList = DateUtil.assembleContinuousMonth((Date)today);
        for (String month : dateList) {
            resultMap.put(month, BigDecimal.ZERO);
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String month = dynamicObject.getString("month");
            BigDecimal object = dynamicObject.getBigDecimal("sumtaxamount");
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!((String)entry.getKey()).equals(month)) continue;
                entry.setValue(object);
            }
        }
        return resultMap;
    }

    public static final Map<String, BigDecimal> assemblePaymentAmount() {
        Date today = new Date();
        ORM orm = ORM.create();
        DataSet resultData = null;
        DataSet dataSet = ORMUtil.queryDataSet((String)"scp_pay", (String)"id,year(billdate)*100+month(billdate) as month,sumpayamount", IndexUtil.buildFilterMap(today), (String)"billdate");
        resultData = dataSet.groupBy(new String[]{"month"}).sum("sumpayamount").finish();
        DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(resultData);
        LinkedHashMap<String, BigDecimal> resultMap = new LinkedHashMap<String, BigDecimal>(dynamicObjectCollection.size());
        ArrayList dateList = DateUtil.assembleContinuousMonth((Date)today);
        for (String month : dateList) {
            resultMap.put(month, BigDecimal.ZERO);
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String month = dynamicObject.getString("month");
            BigDecimal object = dynamicObject.getBigDecimal("sumpayamount");
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!((String)entry.getKey()).equals(month)) continue;
                entry.setValue(object);
            }
        }
        return resultMap;
    }
}

