/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.util;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scm.common.enums.DiscountTypeEnum;
import kd.scm.common.enums.TaxTypeEnum;

public class ScpCheckDiscounttype {
    public static boolean checkIsCompliance(IFormView view, String fielKey, Object newValue, Object oldValue, String suffix, int rowIndex) {
        IDataModel model = view.getModel();
        String discountType = (String)model.getValue("discounttype" + suffix, rowIndex);
        String taxtype = (String)model.getValue("taxtype");
        BigDecimal discountRate = (BigDecimal)model.getValue("dctrate" + suffix, rowIndex);
        BigDecimal actchecktaxprice = (BigDecimal)model.getValue("actchecktaxprice", rowIndex);
        BigDecimal actcheckprice = (BigDecimal)model.getValue("actcheckprice", rowIndex);
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        boolean isCompliance = true;
        boolean isTax = ScpCheckDiscounttype.isContainTax(taxtype);
        if (!isPresent && DiscountTypeEnum.UNITDIS.getVal().equals(discountType)) {
            if (isTax && discountRate.compareTo(actchecktaxprice) > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"ScpCheckDiscounttype_1", (String)"scm-scp-common", (Object[])new Object[0]));
                isCompliance = false;
            } else if (!isTax && discountRate.compareTo(actcheckprice) > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"ScpCheckDiscounttype_2", (String)"scm-scp-common", (Object[])new Object[0]));
                isCompliance = false;
            }
        }
        if (!isCompliance) {
            model.setValue(fielKey, oldValue, rowIndex);
        }
        return isCompliance;
    }

    protected static boolean isContainTax(String taxType) {
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }
}

