/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.scm.common.util.CommonUtil;

public class ScpCheckBillPushDownPlugin
extends AbstractConvertPlugIn {
    private static final String SALENTRYKEY = "materialentry";
    private static final String PURENTRYKEY = "entryentity1";
    private static final String PURENTRYKEY_SUFFIX = "1";
    private static final String INVOICEID = "entryinvoiceid";
    private static final String SUMTAX = "sumtax";
    private static final String SUMAMOUNT = "sumamount";
    private static final String SUM_TAXAMOUNT = "sumtaxamount";
    private static final String ENTRY_TAX = "tax";
    private static final String ENTRY_TAXAMOUNT = "taxamount";
    private static final String ENTRY_AMOUNT = "amount";

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey("scp_invoice")) {
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection salcols = obj.getDynamicObjectCollection(SALENTRYKEY);
            if (salcols.size() <= 0) continue;
            this.setHeadData(obj, salcols);
            String invoiceGroupKey = ((DynamicObject)salcols.get(0)).getString(INVOICEID);
            DynamicObjectCollection purcols = obj.getDynamicObjectCollection(PURENTRYKEY);
            List<DynamicObject> list = this.getInvoiceEntry(invoiceGroupKey, purcols);
            purcols.clear();
            purcols.addAll(list);
        }
    }

    private void setHeadData(DynamicObject obj, DynamicObjectCollection salcols) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : salcols) {
            sumTax = sumTax.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get(ENTRY_TAX)));
            sumTaxAmount = sumTaxAmount.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get(ENTRY_TAXAMOUNT)));
            sumAmount = sumAmount.add(CommonUtil.getBigDecimalPro((Object)dynamicObject.get(ENTRY_AMOUNT)));
        }
        obj.set(SUMTAX, (Object)sumTax);
        obj.set(SUM_TAXAMOUNT, (Object)sumTaxAmount);
        obj.set(SUMAMOUNT, (Object)sumAmount);
    }

    private List<DynamicObject> getInvoiceEntry(String invoiceGroupKey, DynamicObjectCollection purcols) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject col : purcols) {
            Object invoiceId = col.get("entryinvoiceid1");
            if (!invoiceGroupKey.equals(invoiceId)) continue;
            list.add(col);
        }
        return list;
    }
}

