/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.LowTimer;

public class ScpCheckInfoPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log log = LogFactory.getLog(ScpCheckInfoPlugin.class);
    private static final String ACTION_SPLITCHECK = "action_splitcheck";
    private static final String AUTOAPLIT = "autosplit";
    private static final String INSTOCK_ENTRY = "entryentity1";
    private static final String INSTOCK_ENTRY_SUFFIX = "1";
    private static final char INSTOCK_ENTRY_SUFFIX_CHAR = '1';
    private static final String INVOICE_ENTRY = "entryentity2";
    private static final String INSTOCK_SUBENTRY = "instocksubentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_autosplit", "btn_save"});
        EntryGrid saloutGrid = (EntryGrid)this.getView().getControl(INSTOCK_SUBENTRY);
        if (saloutGrid != null) {
            saloutGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
        this.getModel().setDataChanged(false);
    }

    private void initData() {
        Map<String, DynamicObject> map = this.matchInvoice(true);
        DynamicObject currDynamicObject = map.get("currDynamicObject");
        if (currDynamicObject == null) {
            return;
        }
        this.buildData(currDynamicObject);
    }

    public DynamicObject getScpCheckData(Object billid) {
        String selectfields = DynamicObjectUtil.getSelectfields((String)"scp_check", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INSTOCK_ENTRY, (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INVOICE_ENTRY, (boolean)false);
        HashMap paramMap = new HashMap(1);
        HashMap<String, Object> idMap = new HashMap<String, Object>(1);
        idMap.put("in", billid);
        paramMap.put("id", idMap);
        DynamicObject[] dynamicObjs = ORMUtil.load((String)"scp_check", (String)selectfields, paramMap);
        if (dynamicObjs.length == 0) {
            return null;
        }
        return dynamicObjs[0];
    }

    private DynamicObjectCollection getCheckCols(Object billId) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"scp_check", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"scp_check", (String)INSTOCK_ENTRY, (boolean)true);
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append(selectFields).append(',').append(INSTOCK_ENTRY).append(".id entryid");
        QFilter filter = new QFilter("id", "=", billId);
        StringBuilder orderBysSb = new StringBuilder();
        String invSeq = this.getPageCache().get("invSeq");
        if (null == invSeq) {
            orderBysSb.append(INSTOCK_ENTRY).append('.').append("taxamount").append('1');
        } else {
            invSeq = this.getFieldOrderBys(invSeq, INSTOCK_ENTRY, INSTOCK_ENTRY_SUFFIX);
            orderBysSb.append(INSTOCK_ENTRY).append('.').append("taxamount").append('1').append(',').append(invSeq);
        }
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"scp_check", (String)selectFieldsSb.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBysSb.toString());
        return cols;
    }

    public DynamicObject getSchemeData(long schemeId) {
        String selectFields = "id,number,invupamount";
        HashMap<String, Long> filterMap = new HashMap<String, Long>();
        filterMap.put("id", schemeId);
        DynamicObject returnData = null;
        returnData = ORMUtil.queryOneByPro((String)"scp_chkscheme", (String)selectFields, filterMap);
        return returnData;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "autosplit": {
                break;
            }
            case "pushtoinvoice": {
                this.pushToInvoice();
            }
        }
    }

    private void matchAndSetInvoiceData(DynamicObject currDynamicObject) {
        DynamicObjectCollection cols = currDynamicObject.getDynamicObjectCollection(INVOICE_ENTRY);
        DynamicObjectCollection invoiceEntryCols = this.getModel().getEntryEntity("entryentity");
        HashMap<String, String> entryId_invoiceKeyMap = new HashMap<String, String>();
        if (invoiceEntryCols.size() > 0) {
            for (DynamicObject invoiceEntry : invoiceEntryCols) {
                DynamicObject newCol = ORMUtil.newDynamicObject((DynamicObjectType)cols.getDynamicObjectType());
                newCol.set("invoicecode", invoiceEntry.get("invoicecode"));
                newCol.set("invoiceno", invoiceEntry.get("invoiceno"));
                newCol.set("invoicedate", (Object)new Date());
                newCol.set("invoiceamt", invoiceEntry.get("invoiceamt"));
                newCol.set("note2", invoiceEntry.get("note"));
                newCol.set("invoiceid2", invoiceEntry.get("invoicekey"));
                newCol.set("entrystatus2", (Object)BillEntryStatusEnum.COMMON.getVal());
                cols.add((Object)newCol);
                DynamicObjectCollection details = invoiceEntry.getDynamicObjectCollection(INSTOCK_SUBENTRY);
                for (DynamicObject detail : details) {
                    entryId_invoiceKeyMap.put(detail.getString("entryid2"), detail.getString("invoicekey2"));
                }
            }
        }
        DynamicObjectCollection instockCols = currDynamicObject.getDynamicObjectCollection(INSTOCK_ENTRY);
        for (DynamicObject instockCol : instockCols) {
            String invoiceKey = (String)entryId_invoiceKeyMap.get(instockCol.getPkValue().toString());
            if (null == invoiceKey) continue;
            instockCol.set("invoiceid1", (Object)invoiceKey);
        }
    }

    private Map<String, DynamicObject> matchInvoice(boolean isSplit) {
        LowTimer timer = new LowTimer();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        DynamicObject currDynamicObject = null;
        DynamicObject backUpCurrDynamicObject = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object billId = customParams.get("billid");
        if (null == billId) {
            return map;
        }
        currDynamicObject = this.getScpCheckData(billId);
        map.put("currDynamicObject", currDynamicObject);
        if (currDynamicObject == null) {
            return map;
        }
        if (!isSplit) {
            backUpCurrDynamicObject = (DynamicObject)OrmUtils.clone((IDataEntityBase)currDynamicObject, (boolean)false, (boolean)true);
            map.put("backUpCurrDynamicObject", backUpCurrDynamicObject);
        }
        if (isSplit) {
            DynamicObjectCollection cols = this.getCheckCols(billId);
            this.createInvoiceEntry(cols, isSplit, currDynamicObject);
        } else {
            this.matchAndSetInvoiceData(currDynamicObject);
        }
        this.closeInvoiceEntry(isSplit, currDynamicObject);
        log.info("###matchInvoice\u65f6\u95f4:" + timer.msValue());
        return map;
    }

    private void createInvoiceEntry(DynamicObjectCollection cols, boolean isSplit, DynamicObject currDynamicObject) {
        DynamicObjectCollection invoiceCols = currDynamicObject.getDynamicObjectCollection(INVOICE_ENTRY);
        Map<String, List<Object>> invoiceKey_entryIdMap = this.getInvoiceDataMap(cols);
        DynamicObjectCollection instockCols = currDynamicObject.getDynamicObjectCollection(INSTOCK_ENTRY);
        for (Map.Entry<String, List<Object>> data : invoiceKey_entryIdMap.entrySet()) {
            List<Object> entryIdList = data.getValue();
            BigDecimal sumInvoiceAmt = BigDecimal.ZERO;
            for (DynamicObject instockCol : instockCols) {
                if (!entryIdList.contains(instockCol.getPkValue())) continue;
                sumInvoiceAmt = sumInvoiceAmt.add(instockCol.getBigDecimal("actchecktaxamount"));
                instockCol.set("invoiceid1", (Object)data.getKey());
            }
            DynamicObject newCol = ORMUtil.newDynamicObject((DynamicObjectType)invoiceCols.getDynamicObjectType());
            newCol.set("invoicedate", (Object)new Date());
            newCol.set("invoiceamt", (Object)sumInvoiceAmt);
            newCol.set("invoiceid2", (Object)data.getKey());
            newCol.set("entrystatus2", (Object)BillEntryStatusEnum.COMMON.getVal());
            invoiceCols.add((Object)newCol);
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)currDynamicObject, (String)INVOICE_ENTRY);
    }

    private Map<String, List<Object>> getInvoiceDataMap(DynamicObjectCollection cols) {
        IPageCache cache = this.getPageCache();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BigDecimal sumTaxamount = CommonUtil.getBigDecimalPro((Object)cache.get("sumTaxAmount"));
        BigDecimal upAmount = CommonUtil.getBigDecimalPro((Object)cache.get("upAmount"));
        if (sumTaxamount.compareTo(BigDecimal.ZERO) == 0) {
            upAmount = sumTaxamount = CommonUtil.getBigDecimalPro(customParams.get("unInvoicedTaxAmount"));
        }
        if (upAmount.compareTo(BigDecimal.ZERO) == 0) {
            upAmount = sumTaxamount;
        }
        ArrayList<Object> matchedEntryIdList = new ArrayList<Object>();
        HashMap<String, List<Object>> invoiceKey_entryIdList = new HashMap<String, List<Object>>();
        String currInvoiceKey = CommonUtil.getUniqueKey();
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            Object entryId = col.get("entryid");
            String invoiceId = col.getString("invoiceid1");
            if (!invoiceId.isEmpty() && invoiceId.trim().length() > 0 || matchedEntryIdList.contains(entryId)) continue;
            ArrayList<Object> curEntryIdList = (ArrayList<Object>)invoiceKey_entryIdList.get(currInvoiceKey);
            if (null == curEntryIdList) {
                curEntryIdList = new ArrayList<Object>();
                curEntryIdList.add(entryId);
                matchedEntryIdList.add(entryId);
                invoiceKey_entryIdList.put(currInvoiceKey, curEntryIdList);
                continue;
            }
            ((List)invoiceKey_entryIdList.get(currInvoiceKey)).add(entryId);
            matchedEntryIdList.add(entryId);
        }
        return invoiceKey_entryIdList;
    }

    private void closeInvoiceEntry(boolean isSplit, DynamicObject currDynamicObject) {
        if (isSplit) {
            return;
        }
        DynamicObjectCollection cols = currDynamicObject.getDynamicObjectCollection(INVOICE_ENTRY);
        for (DynamicObject invoiceEntry : cols) {
            invoiceEntry.set("entrystatus2", (Object)BillEntryStatusEnum.CLOSED.getVal());
        }
    }

    private String getFieldOrderBys(String selectFields, String entryKey, String suffix) {
        StringBuilder orderBysKeySB = new StringBuilder();
        if (null != selectFields) {
            String[] groupKeys = selectFields.split(",");
            int i = 0;
            for (String groupKey : groupKeys) {
                if (orderBysKeySB.length() > 0 && i != 0) {
                    orderBysKeySB.append(',');
                }
                if ("billno".equals(groupKey)) {
                    orderBysKeySB.append(entryKey).append('.').append("inbillno").append(suffix);
                } else if ("billdate".equals(groupKey)) {
                    orderBysKeySB.append(entryKey).append('.').append("inbilldate").append(suffix);
                } else {
                    orderBysKeySB.append(entryKey).append('.').append(groupKey).append(suffix);
                }
                ++i;
            }
        }
        return orderBysKeySB.toString();
    }

    private void pushToInvoice() {
        Map<String, DynamicObject> map = this.matchInvoice(false);
        DynamicObject currDynamicObject = map.get("currDynamicObject");
        if (currDynamicObject != null) {
            SaveServiceHelper.save((IDataEntityType)currDynamicObject.getDataEntityType(), (Object[])new Object[]{currDynamicObject});
            this.pushDown2ScpInvoice(currDynamicObject, map.get("backUpCurrDynamicObject"));
        }
        this.getView().close();
    }

    private void pushDown2ScpInvoice(DynamicObject checkBill, DynamicObject backUpCurrDynamicObject) {
        boolean isReset = false;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("scp_check");
        pushArgs.setTargetEntityNumber("scp_invoice");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        DynamicObjectCollection cols = checkBill.getDynamicObjectCollection(INSTOCK_ENTRY);
        for (DynamicObject col : cols) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(checkBill.getPkValue());
            row.setEntryEntityKey(INSTOCK_ENTRY);
            row.setEntryPrimaryKeyValue(col.getPkValue());
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"scp_invoice");
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        if (result.isSuccess()) {
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            for (DynamicObject invoice : targetData) {
                DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection(INSTOCK_ENTRY);
                DynamicObject curr = invoice.getDynamicObject("curr");
                int scale = 2;
                if (null != curr) {
                    scale = curr.getInt("priceprecision");
                }
                BigDecimal sumtaxamount = BigDecimal.ZERO;
                for (DynamicObject entry : invoiceEntry) {
                    BigDecimal actchecktaxprice = entry.getBigDecimal("actchecktaxprice");
                    BigDecimal actchecktaxamount = entry.getBigDecimal("actchecktaxamount");
                    if (actchecktaxprice.compareTo(entry.getBigDecimal("acttaxprice1")) == 0) continue;
                    BigDecimal one = BigDecimal.ONE;
                    BigDecimal hundred = new BigDecimal("100");
                    BigDecimal dctrate1 = entry.getBigDecimal("dctrate1");
                    entry.set("taxprice1", (Object)actchecktaxprice.divide(one.subtract(dctrate1.divide(hundred)), scale, RoundingMode.HALF_UP));
                    BigDecimal taxrate = entry.getBigDecimal("taxrate1");
                    entry.set("price1", (Object)entry.getBigDecimal("taxprice1").multiply(one.subtract(taxrate.divide(hundred))));
                    entry.set("dctamount1", (Object)actchecktaxamount.multiply(dctrate1.divide(hundred)));
                    entry.set("taxamount1", (Object)actchecktaxamount.subtract(entry.getBigDecimal("dctamount1")));
                    entry.set("tax1", (Object)actchecktaxamount.multiply(taxrate.divide(hundred)));
                    entry.set("amount1", (Object)actchecktaxamount.subtract(entry.getBigDecimal("tax1")));
                    entry.set("actprice1", entry.get("price1"));
                    entry.set("acttaxprice1", (Object)actchecktaxprice);
                    sumtaxamount = sumtaxamount.add(entry.getBigDecimal("taxamount1"));
                }
                invoice.set("sumtaxamount", (Object)sumtaxamount);
            }
            OperationResult opResult = SaveServiceHelper.saveOperate((String)"scp_invoice", (DynamicObject[])targetData.toArray(new DynamicObject[0]), null);
            result.release(refDataProvider, mainType);
            if (opResult.isSuccess()) {
                this.openInvoicePage(opResult.getSuccessPkIds());
            } else {
                isReset = true;
                this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5f00\u7968\u5355\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ScpCheckInfoPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]), opResult.getMessage(), MessageTypes.Default);
            }
        } else {
            isReset = true;
            this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5f00\u7968\u5355\u5931\u8d25\u3002", (String)"ScpCheckInfoPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), result.getMessage(), MessageTypes.Default);
        }
        if (isReset) {
            DeleteServiceHelper.delete((IDataEntityType)checkBill.getDataEntityType(), (Object[])new Object[]{checkBill.getPkValue()});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{backUpCurrDynamicObject});
            this.getView().invokeOperation("refresh");
        }
    }

    private void openInvoicePage(List<Object> successPkIds) {
        if (successPkIds == null) {
            return;
        }
        if (successPkIds.size() > 1) {
            HashMap paramMap = new HashMap(1);
            HashMap<String, List<Object>> idMap = new HashMap<String, List<Object>>(1);
            idMap.put("in", successPkIds);
            paramMap.put("id", idMap);
            Object[] objs = ORMUtil.load((String)"scp_invoice", (String)"id,billno", paramMap);
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u751f\u6210\u4e86{0}\u5f20\u5f00\u7968\u5355\u3002", (String)"ScpCheckInfoPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]), successPkIds.size()), MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a{0}\u3002", (String)"ScpCheckInfoPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]), DynamicObjectUtil.getBillPro2Str((Object[])objs, (String)"billno")), MessageTypes.Default);
            ListShowParameter params = BillFormUtil.assembleShowListFormParam((String)"scp_invoice", null, null);
            this.getView().showForm((FormShowParameter)params);
        } else {
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"scp_invoice", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)successPkIds.get(0)), null, null));
        }
    }

    public void buildData(DynamicObject currDynamicObject) {
        LowTimer timer = new LowTimer();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        DynamicObjectCollection invoiceCols = currDynamicObject.getDynamicObjectCollection(INVOICE_ENTRY);
        model.deleteEntryData("entryentity");
        int i = 0;
        for (DynamicObject invoiceCol : invoiceCols) {
            String entryStatus = invoiceCol.getString("entrystatus2");
            if (BillEntryStatusEnum.CLOSED.getVal().equals(entryStatus)) continue;
            model.createNewEntryRow("entryentity");
            String invoiceKey = invoiceCol.getString("invoiceid2");
            entryGrid.selectRows(i);
            model.setValue("invoiceamt", invoiceCol.get("invoiceamt"), i);
            model.setValue("invoicedate", (Object)new Date(), i);
            model.setValue("invoicekey", (Object)invoiceKey, i);
            if (null != currDynamicObject.getDynamicObject("curr")) {
                model.setValue("curr", currDynamicObject.getDynamicObject("curr").getPkValue(), i);
            }
            this.buildDetailData(invoiceKey, currDynamicObject);
            ++i;
        }
        log.info("###buildData\u6784\u9020\u65f6\u95f4\uff1a" + timer.msValue());
    }

    public void buildDetailData(String invoiceKey, DynamicObject currDynamicObject) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntryEntity(INSTOCK_SUBENTRY).getDynamicObjectType());
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (String property : properties) {
            if ("id".equals(property) || "seq".equals(property)) continue;
            propertiesMap.put(property, property);
        }
        model.deleteEntryData(INSTOCK_SUBENTRY);
        DynamicObjectCollection saleCols = currDynamicObject.getDynamicObjectCollection(INSTOCK_ENTRY);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (DynamicObject salCol : saleCols) {
            Map salColMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)salCol);
            String salInvoiceKey = salCol.getString("invoiceid1");
            if (!salInvoiceKey.equals(invoiceKey)) continue;
            for (Map.Entry salColEntry : salColMap.entrySet()) {
                String proKey = ((String)salColEntry.getKey()).replace('1', '2');
                if (null == propertiesMap.get(proKey)) continue;
                ts.set(proKey, salColEntry.getValue(), i);
            }
            ts.set("taxprice2", salColMap.get("actchecktaxprice"), i);
            ts.set("taxamount2", salColMap.get("actchecktaxamount"), i);
            ts.set("entryid2", salCol.getPkValue(), i);
            ts.set("invoicekey2", (Object)salInvoiceKey, i);
            ++i;
        }
        model.batchCreateNewEntryRow(INSTOCK_SUBENTRY, ts);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(INSTOCK_SUBENTRY, rowIndex);
        String billNo = rowEntity.getString(fieldName);
        String entityKey = null;
        if ("pobillno2".equals(fieldName)) {
            entityKey = "scp_order";
        } else if ("outbillno2".equals(fieldName)) {
            entityKey = "scp_saloutstock";
        } else if ("inbillno2".equals(fieldName)) {
            if (QueryServiceHelper.exists((String)"scp_receipt", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)})) {
                entityKey = "scp_receipt";
            } else if (QueryServiceHelper.exists((String)"scp_instock", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)})) {
                entityKey = "scp_instock";
            }
        }
        HashMap<String, String> uniqueMap = new HashMap<String, String>(1);
        uniqueMap.put("billno", billNo);
        DynamicObject dynamicObject = ORMUtil.querySingleByPro((String)entityKey, (String)"id,billno", uniqueMap);
        if (dynamicObject != null) {
            BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)dynamicObject.getLong("id"), null, null);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }
}

