/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.scp.business.ScpBillRevokeHelper;
import kd.scm.scp.common.helper.ScpCoreListFilterHelper;
import kd.scm.scp.formplugin.ScpCoreListPlugin;

public class ScpCheckListPlugin
extends ScpCoreListPlugin {
    private static final String SPLITCHECK = "splitcheck";
    private static final String ACTION_SPLITCHECK = "action_splitcheck";
    private static final String SCP_INVOICEINFO = "scp_invoiceinfo";
    private static final String SALES_ENTRY = "materialentry";
    private static final String INSTOCK_ENTRY = "entryentity1";
    private static final String INVOICE_ENTRY = "entryentity2";
    private DynamicObject currDynamicObject = null;

    public void itemClick(ItemClickEvent evt) {
        if ("bar_revoke".equals(evt.getItemKey())) {
            IListView listView = (IListView)this.getView();
            String entityNumber = listView.getBillFormId();
            Object[] primaryKeyValues = listView.getSelectedRows().getPrimaryKeyValues();
            OperationResult operationResult = ScpBillRevokeHelper.revokeListBill((Object[])primaryKeyValues, (String)entityNumber);
            if (operationResult != null) {
                listView.showOperationResult(operationResult);
                listView.invokeOperation("refresh");
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "splitcheck": {
                    this.currDynamicObject = this.getFirstSelectedRow(false);
                    if (this.currDynamicObject == null) {
                        return;
                    }
                    String cfmStatus = this.currDynamicObject.getString("cfmstatus");
                    if (!ConfirmStatusEnum.CONFIRM.getVal().equals(cfmStatus)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u672a\u786e\u8ba4\u65e0\u6cd5\u6267\u884c\u3002", (String)"ScpCheckListPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Map<String, Object> param = this.buildParam(this.currDynamicObject);
                    BigDecimal unInvoicedAmount = CommonUtil.getBigDecimalPro((Object)param.get("unInvoicedTaxAmount"));
                    BigDecimal sumtaxamount = CommonUtil.getBigDecimalPro((Object)param.get("sumtaxamount"));
                    if (sumtaxamount.compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u786e\u8ba4\u5408\u8ba1\u91d1\u989d\u4e3a0\uff0c\u65e0\u6cd5\u5f00\u7968\u3002", (String)"ScpCheckEditPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (unInvoicedAmount.compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5168\u90e8\u751f\u6210\u5f00\u7968\u5355\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ScpCheckListPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.currDynamicObject = this.getFirstSelectedRow(false);
                    if (this.currDynamicObject == null) break;
                    param = this.buildParam(this.currDynamicObject);
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)SCP_INVOICEINFO, param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_SPLITCHECK), (ShowType)ShowType.MainNewTabPage));
                    break;
                }
            }
        }
    }

    private DynamicObject getFirstSelectedRow(boolean getAllEntry) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u751f\u6210\u5f00\u7968\u5355\u3002", (String)"ScpCheckListPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return null;
        }
        String selectfields = DynamicObjectUtil.getSelectfields((String)"scp_check", (boolean)false);
        if (!getAllEntry) {
            selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)SALES_ENTRY, (boolean)false);
            selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INSTOCK_ENTRY, (boolean)false);
        } else {
            selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)SALES_ENTRY, (boolean)false);
            selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INSTOCK_ENTRY, (boolean)false);
            selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INVOICE_ENTRY, (boolean)false);
        }
        HashMap paramMap = new HashMap(1);
        HashMap<String, Object[]> idMap = new HashMap<String, Object[]>(1);
        idMap.put("in", objects);
        paramMap.put("id", idMap);
        DynamicObject[] dynamicObjs = ORMUtil.load((String)"scp_check", (String)selectfields, paramMap);
        if (dynamicObjs.length == 0) {
            return null;
        }
        return dynamicObjs[0];
    }

    private Map<String, Object> buildParam(DynamicObject dynamicObj) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billid", dynamicObj.getPkValue());
        param.put("billno", dynamicObj.getString("billno"));
        if (dynamicObj.get("curr") != null) {
            param.put("curr", ((DynamicObject)dynamicObj.get("curr")).getPkValue());
        }
        if (dynamicObj.get("chkscheme") != null) {
            param.put("chkscheme", ((DynamicObject)dynamicObj.get("chkscheme")).getPkValue());
        }
        BigDecimal unInvoicedTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        DynamicObjectCollection entrys = dynamicObj.getDynamicObjectCollection(INSTOCK_ENTRY);
        for (DynamicObject entry : entrys) {
            String inventryId = entry.getString("invoiceid1");
            if (!inventryId.isEmpty() && !inventryId.trim().isEmpty()) continue;
            taxAmount = CommonUtil.getBigDecimalPro((Object)entry.get("taxamount1"));
            unInvoicedTaxAmount = unInvoicedTaxAmount.add(taxAmount);
        }
        param.put("unInvoicedTaxAmount", unInvoicedTaxAmount);
        param.put("sumtaxamount", dynamicObj.getBigDecimal("sumtaxamount"));
        return param;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "action_splitcheck": {
                this.getView().invokeOperation("refresh");
                Object beginCheck_condition = closedCallBackEvent.getReturnData();
                if (null != beginCheck_condition) break;
                return;
            }
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filterArrayList = e.getQFilters();
        ScpCoreListFilterHelper.setCheckListFilter((List)filterArrayList);
    }
}

