/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.invcloud.enums.InvoiceTypeEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExchrateUtil;
import kd.scm.common.util.calmodel.CalModelFactory;
import kd.scm.common.util.calmodel.ICalModel;
import kd.scm.common.util.invoice.PurInvoiceDeductionCalHelper;
import kd.scm.scp.common.util.ScpCheckDiscounttype;
import kd.scm.scp.formplugin.ScpCoreBillEditPlugin;

public class ScpInvoiceEditPlugin
extends ScpCoreBillEditPlugin {
    private boolean isNeedChange = true;

    @Override
    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        super.setEntryKey("entryentity1");
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsPersentUnable("entryentity1", "ispresent1", "actcheckprice", "actchecktaxprice", "actcheckamount", "actchecktaxamount");
    }

    private boolean isOverseasInvoices(DynamicObject invoiceTypeDy) {
        if (invoiceTypeDy == null) {
            return false;
        }
        String invoiceType = invoiceTypeDy.getString("number");
        return InvoiceTypeEnum.INVOICETYPE30.getVal().equals(invoiceType);
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey;
        switch (clickKey = evt.getItemKey()) {
            case "bar_viewinvoice": {
                String invAddress = this.getModel().getDataEntity().getString("invaddress");
                this.getView().openUrl(invAddress);
                break;
            }
            case "bar_revoke": {
                String billstatus = this.getModel().getDataEntity(true).getString("billstatus");
                if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                    this.getView().invokeOperation("unaudit");
                    break;
                }
                this.getView().invokeOperation("unsubmit");
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String operateKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryentitys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : entryentitys) {
                BigDecimal invoiceamount;
                BigDecimal invtax = dy.getBigDecimal("invtax");
                if (invtax == null) {
                    dy.set("invtax", (Object)BigDecimal.ZERO);
                }
                if ((invoiceamount = dy.getBigDecimal("invoiceamount")) != null) continue;
                dy.set("invoiceamount", (Object)BigDecimal.ZERO);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IDataModel dataModel = this.getModel();
            HashMap<String, Object> customFilter = new HashMap<String, Object>();
            customFilter.put("pkidcoll", new Object[]{dataModel.getDataEntity().getPkValue()});
            customFilter.put("ENTRY_KEY", dataModel.getDataEntity().getDataEntityType().getName());
            FormShowParameter param = null;
            switch (operateKey) {
                case "logquery": {
                    customFilter.put("isFromSupplier", Boolean.TRUE);
                    param = BillFormUtil.assembleShowDynamicFormParam((String)"scp_invlogquery", customFilter, null, (ShowType)ShowType.MainNewTabPage);
                    this.getView().showForm(param);
                    break;
                }
                case "inputdellog": {
                    param = BillFormUtil.assembleShowDynamicFormParam((String)"scp_invloginfo", customFilter, null, (ShowType)ShowType.NonModal);
                    this.getView().showForm(param);
                    break;
                }
                case "deleteentry": {
                    IDataModel model = this.getModel();
                    model.setValue("sumamount", (Object)this.calSum(model, "entryentity1", "amount1"));
                    model.setValue("sumtax", (Object)this.calSum(model, "entryentity1", "tax1"));
                    model.setValue("sumtaxamount", (Object)this.calSum(model, "entryentity1", "actchecktaxamount"));
                }
            }
        }
        if ("deleteentry".equals(operateKey)) {
            IDataModel model = this.getModel();
            model.setValue("sumamount", (Object)this.calSum(model, "entryentity1", "amount1"));
            model.setValue("sumtax", (Object)this.calSum(model, "entryentity1", "tax1"));
            model.setValue("sumtaxamount", (Object)this.calSum(model, "entryentity1", "actchecktaxamount"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String clickKey;
        super.beforeItemClick(evt);
        switch (clickKey = evt.getItemKey()) {
            case "bar_viewinvoice": {
                String invAddress = this.getModel().getDataEntity().getString("invaddress");
                if (invAddress != null && !invAddress.isEmpty() && (invAddress.startsWith("https://") || invAddress.startsWith("http://"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\u6216\u65e0\u6548\uff0c\u4e0d\u80fd\u4e0b\u8f7d\u6d4f\u89c8\u3002", (String)"ScpInvoiceEditPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        ChangeData[] changedDatas = e.getChangeSet();
        model.beginInit();
        if ("qty1".equals(propertyName) && this.isNeedChange()) {
            this.setNeedChange(false);
            BigDecimal oldVal = BigDecimal.ZERO;
            Object newVal = BigDecimal.ZERO;
            ChangeData[] changeDataArray = changedDatas;
            int n = changeDataArray.length;
            for (int i = 0; i < n; ++i) {
                ChangeData changedData = changeDataArray[i];
                int rowIndex = changedData.getRowIndex();
                oldVal = CommonUtil.getBigDecimalPro((Object)changedData.getOldValue());
                newVal = CommonUtil.getBigDecimalPro((Object)changedData.getNewValue());
                if (null == oldVal || null == newVal) continue;
                if (((BigDecimal)newVal).compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("qty1", (Object)oldVal, rowIndex);
                }
                if (oldVal.multiply((BigDecimal)newVal).compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("qty1", (Object)oldVal, rowIndex);
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("material1");
                DynamicObject srcUnit = (DynamicObject)this.getModel().getValue("unit1");
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty1");
                if (material != null) {
                    BigDecimal basicQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)srcUnit, (BigDecimal)qty, (DynamicObject)material.getDynamicObject("baseunit"));
                    this.getModel().setValue("basicqty1", (Object)basicQty, rowIndex);
                } else {
                    this.getModel().setValue("basicqty1", (Object)qty, rowIndex);
                }
                ExchrateUtil.setLocalPrice((DynamicObject)this.getModel().getDataEntity(true), (int)changedData.getRowIndex(), (String)"1", (String)"1");
            }
            this.setNeedChange(true);
        }
        ICalModel iCalDynamic = new CalModelFactory().createCal();
        block18: for (ChangeData changedData : changedDatas) {
            int rowIndex = changedData.getRowIndex();
            Object modelValue = model.getValue(propertyName, rowIndex);
            Object newValue = changedData.getNewValue();
            Object oldValue = changedData.getOldValue();
            if (null == modelValue) {
                return;
            }
            switch (propertyName) {
                case "amount1": {
                    model.setValue("sumamount", (Object)this.calSum(model, "entryentity1", propertyName));
                    continue block18;
                }
                case "tax1": {
                    model.setValue("sumtax", (Object)this.calSum(model, "entryentity1", propertyName));
                    continue block18;
                }
                case "qty1": {
                    iCalDynamic.proChanged(model, "entryentity1", "qty1", "1", rowIndex);
                    continue block18;
                }
                case "actchecktaxprice": 
                case "actcheckprice": {
                    boolean checkIsCompliance = ScpCheckDiscounttype.checkIsCompliance((IFormView)this.getView(), (String)propertyName, (Object)newValue, (Object)oldValue, (String)"1", (int)rowIndex);
                    if (checkIsCompliance) {
                        iCalDynamic.proChanged(model, "entryentity1", propertyName, "1", rowIndex);
                    }
                }
                case "actchecktaxamount": {
                    iCalDynamic.proChanged(model, "entryentity1", "actchecktaxamount", "1", rowIndex);
                    continue block18;
                }
                case "actcheckamount": {
                    iCalDynamic.proChanged(model, "entryentity1", "actcheckamount", "1", rowIndex);
                    continue block18;
                }
            }
        }
        model.endInit();
        this.getView().updateView("entryentity1");
        HashSet deductBills = null;
        String deductBillsStr = this.getPageCache().get("deductBills");
        if (StringUtils.isEmpty((String)deductBillsStr)) {
            deductBills = PurCheckMappingUtils.getDeductBill();
            this.getPageCache().put("deductBills", JSON.toJSONString((Object)deductBills));
        } else {
            List parseArray = JSON.parseArray((String)deductBillsStr, String.class);
            deductBills = new HashSet(8);
            deductBills.addAll(parseArray);
        }
        PurInvoiceDeductionCalHelper.calDeduction((IDataModel)model, deductBills);
        model.setValue("sumtaxamount", (Object)this.calSum(model, "entryentity1", "actchecktaxamount"));
        model.setValue("sumamount", (Object)this.calSum(model, "entryentity1", "amount1"));
        model.setValue("sumtax", (Object)this.calSum(model, "entryentity1", "tax1"));
        this.invoicePropChange(propertyName, model, dataEntity, changedDatas);
    }

    private void invoicePropChange(String propertyName, IDataModel model, DynamicObject dataEntity, ChangeData[] changedDatas) {
        DynamicObjectCollection entryentitys = dataEntity.getDynamicObjectCollection("entryentity");
        block8: for (ChangeData changedData : changedDatas) {
            int rowIndex = changedData.getRowIndex();
            Object modelValue = model.getValue(propertyName, rowIndex);
            Object newValue = changedData.getNewValue();
            Object oldValue = changedData.getOldValue();
            if (null == modelValue) {
                return;
            }
            switch (propertyName) {
                case "invoicetype": {
                    if (!(newValue instanceof DynamicObject)) continue block8;
                    DynamicObject invoicetype = (DynamicObject)newValue;
                    boolean newValueoverseasInvoices = this.isOverseasInvoices(invoicetype);
                    if (!CollectionUtils.isNotEmpty((Collection)entryentitys) || entryentitys.size() <= 1) continue block8;
                    for (int i = 0; i < entryentitys.size(); ++i) {
                        if (rowIndex == i) continue;
                        DynamicObject invoicetype0 = ((DynamicObject)entryentitys.get(i)).getDynamicObject("invoicetype");
                        boolean historyoverseasInvoices = this.isOverseasInvoices(invoicetype0);
                        if ((newValueoverseasInvoices || !historyoverseasInvoices) && (!newValueoverseasInvoices || historyoverseasInvoices)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f62\u5f0f\u53d1\u7968\u548c\u975e\u5f62\u5f0f\u53d1\u7968\u4e0d\u53ef\u540c\u65f6\u5f55\u5165\u3002", (String)"ScpInvoiceEditPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        model.setValue("invoicetype", oldValue, rowIndex);
                        continue block8;
                    }
                    continue block8;
                }
                case "invoiceamount": {
                    DynamicObject invoicetype;
                    if (!CollectionUtils.isNotEmpty((Collection)entryentitys) || !this.isOverseasInvoices(invoicetype = ((DynamicObject)entryentitys.get(rowIndex)).getDynamicObject("invoicetype"))) continue block8;
                    model.setValue("invamount", newValue, rowIndex);
                    model.setValue("invtax", (Object)0, rowIndex);
                    continue block8;
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String name = entryProp.getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (name) {
            case "entryentity": {
                for (RowDataEntity rowData : rowDataEntities) {
                    int insertRow = rowData.getRowIndex();
                    DynamicObjectCollection entryentitys = dataEntity.getDynamicObjectCollection("entryentity");
                    if (entryentitys != null && entryentitys.size() > 1) {
                        for (int i = 0; i < entryentitys.size(); ++i) {
                            DynamicObject invoicetype0;
                            if (insertRow == i || !this.isOverseasInvoices(invoicetype0 = ((DynamicObject)entryentitys.get(i)).getDynamicObject("invoicetype"))) continue;
                            this.getModel().setValue("invoicetype", (Object)invoicetype0, insertRow);
                            break;
                        }
                    }
                    this.setInvoiceDefaultValue(dataEntity, insertRow);
                }
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid materialSumGrid = (EntryGrid)this.getView().getControl("entryentity1");
        if (materialSumGrid != null) {
            materialSumGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String gridKey = grid.getKey();
        String property = heperLinkEvent.getFieldName();
        if (gridKey.equals("entryentity1")) {
            int rowIndex = heperLinkEvent.getRowIndex();
            if ("deductamount".equals(property)) {
                DynamicObject curr;
                EntryData entryData = grid.getEntryData();
                DynamicObject dy = entryData.getDataEntitys()[rowIndex];
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                DynamicObject material = dy.getDynamicObject("material1");
                if (material != null) {
                    customParams.put("material", material.getPkValue());
                }
                if ((curr = dataEntity.getDynamicObject("curr")) != null) {
                    customParams.put("curr", curr.getPkValue());
                }
                customParams.put("afterdeductdiscounttype", dy.getString("afterdeductdiscounttype"));
                customParams.put("deductamount", dy.getBigDecimal("deductamount"));
                customParams.put("afterdeductdctrate", dy.getBigDecimal("afterdeductdctrate"));
                customParams.put("afterdeductdctamount", dy.getBigDecimal("afterdeductdctamount"));
                customParams.put("afterdeducttax", dy.getBigDecimal("afterdeducttax"));
                customParams.put("afterdeductamount", dy.getBigDecimal("afterdeductamount"));
                customParams.put("afterdeducttaxamount", dy.getBigDecimal("afterdeducttaxamount"));
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_invoice_deduct", customParams, null, (ShowType)ShowType.Modal));
            }
        }
    }

    private void setInvoiceDefaultValue(DynamicObject dataEntity, int insertRow) {
        DynamicObject bizpartner;
        DynamicObject curr;
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org != null) {
            String ffirmname = org.getString("ffirmname");
            this.getModel().setValue("reccompany", (Object)ffirmname, insertRow);
        }
        if ((curr = dataEntity.getDynamicObject("curr")) != null) {
            this.getModel().setValue("invcurr", (Object)curr, insertRow);
        }
        if ((bizpartner = dataEntity.getDynamicObject("bizpartner")) != null) {
            String bizpartnerName = bizpartner.getString("name");
            this.getModel().setValue("invcompany", (Object)bizpartnerName, insertRow);
        }
    }

    private BigDecimal calSum(IDataModel datamodel, String entryKey, String propertyName) {
        BigDecimal sum = BigDecimal.ZERO;
        int rowCount = datamodel.getEntryRowCount(entryKey);
        for (int i = 0; i < rowCount; ++i) {
            sum = sum.add(datamodel.getEntryRowEntity(entryKey, i).getBigDecimal(propertyName));
        }
        return sum;
    }

    public boolean isNeedChange() {
        return this.isNeedChange;
    }

    public void setNeedChange(boolean isNeedChange) {
        this.isNeedChange = isNeedChange;
    }
}

