/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.AutoPushSalOutUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.scp.business.ScpBillFormHelper;
import kd.scm.scp.business.ScpModuleConsumeHelper;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.common.enums.BillStatus;
import kd.scm.scp.common.util.ScpSupInitiateChangeUtil;
import kd.scm.scp.formplugin.ScpCoreBillEditPlugin;
import kd.scm.scp.formplugin.formhelper.ScpOrderFormHelper;
import kd.scm.scp.formplugin.formhelper.ScpSaloutStockFormHelper;

public class ScpOrderEdit
extends ScpCoreBillEditPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(ScpOrderEdit.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel filePanel = (AttachmentPanel)this.getControl("supattachmentpanel");
        filePanel.addUploadListener((UploadListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        String status = (String)this.getModel().getValue("cfmstatus");
        this.setBarStatus(status);
        BasedataEdit textEdit = (BasedataEdit)this.getControl("material");
        DynamicObject businesstype = this.getModel().getDataEntity().getDynamicObject("businesstype");
        if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)businesstype)) {
            textEdit.setMustInput(false);
        } else {
            textEdit.setMustInput(true);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("execprogress")) {
            this.doExecEnableBtn(false);
            this.setEntryFieldsStatus(true, "#FFFACD");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_execsche", "bar_cancelexec"});
            this.setEntryFieldsStatus(false, "#ffffff");
            this.setPushVisiable();
        }
        if ("A".equals(this.getModel().getDataEntity().getString("cfmstatus"))) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"promiseday"});
        }
        String uploadfile = this.getPageCache().get("uploadfile");
        if (customParams.get("uploadfile") != null && StringUtils.isEmpty((CharSequence)uploadfile)) {
            this.getPageCache().put("uploadfile", "uploadfile");
            this.setContainerCollapse(true);
        } else {
            this.setContainerCollapse(false);
        }
        Object curr = this.getModel().getValue("curr");
        if (curr != null) {
            this.setDiscountRateScale(curr, "materialentry", "taxrate");
            this.setDiscountRateScale(curr, "materialentry", "dctrate");
        }
    }

    private void setPushVisiable() {
        DynamicObjectCollection materialentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("materialentry");
        if (ApiConfigUtil.hasCQScmConfig()) {
            boolean isnotacceptance = Boolean.FALSE;
            Optional<DynamicObject> notacceptanceFindAny = materialentry.stream().filter(dy -> !LineTypeUtil.isLineTypeacceptance((DynamicObject)dy)).findAny();
            if (notacceptanceFindAny.isPresent()) {
                isnotacceptance = Boolean.TRUE;
            }
            this.getView().setVisible(Boolean.valueOf(isnotacceptance), new String[]{"bar_push"});
            boolean isacceptance = Boolean.FALSE;
            Optional<DynamicObject> findAny = materialentry.stream().filter(dy -> LineTypeUtil.isLineTypeacceptance((DynamicObject)dy)).findAny();
            if (findAny.isPresent()) {
                isacceptance = Boolean.TRUE;
            }
            this.getView().setVisible(Boolean.valueOf(isacceptance), new String[]{"bar_acceptapply"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_acceptapply"});
        }
    }

    private void setContainerCollapse(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"support_page"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"sign_page"});
        Container pl_status = (Container)this.getView().getControl("pl_status");
        Container pl_baseinfo = (Container)this.getView().getControl("pl_baseinfo");
        Container pl_rejectinfo = (Container)this.getView().getControl("pl_rejectinfo");
        Container pl_orderinfo = (Container)this.getView().getControl("pl_orderinfo");
        Container pl_salinfo = (Container)this.getView().getControl("pl_salinfo");
        Container pl_loginfo = (Container)this.getView().getControl("pl_loginfo");
        Container fs_attachment = (Container)this.getView().getControl("fs_attachment");
        pl_status.setCollapse(flag);
        pl_baseinfo.setCollapse(flag);
        pl_rejectinfo.setCollapse(flag);
        pl_orderinfo.setCollapse(flag);
        pl_salinfo.setCollapse(flag);
        pl_loginfo.setCollapse(flag);
        fs_attachment.setCollapse(!flag);
    }

    private void setEntryFieldsStatus(boolean status, String color) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCOl = dataEntity.getDynamicObjectCollection("materialentry");
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("materialentry");
        int index = Integer.MAX_VALUE;
        for (int i = 0; i < entryCOl.size(); ++i) {
            DynamicObject row = (DynamicObject)entryCOl.get(i);
            String rowlogstatus = row.getString("rowlogstatus");
            String entryStatus = row.getString("entrystatus");
            if ("A".equals(entryStatus) && ("".equals(rowlogstatus) || "A".equals(rowlogstatus) || "B".equals(rowlogstatus))) {
                this.getView().setEnable(Boolean.valueOf(status), i, new String[]{"executeschedule", "scheduledetail", "executesdate"});
                if (index >= i) {
                    index = i;
                }
                if (!status) continue;
                ArrayList<CellStyle> csList = new ArrayList<CellStyle>(1024);
                this.setEntryFieldColor(csList, "executeschedule", i, color);
                this.setEntryFieldColor(csList, "scheduledetail", i, color);
                this.setEntryFieldColor(csList, "executesdate", i, color);
                grid.setCellStyle(csList);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"executeschedule", "scheduledetail", "executesdate"});
        }
        IPageCache pageCache = this.getPageCache();
        if (index >= 0 && status && null == pageCache.get("focus")) {
            grid.focusCell(index, "executeschedule");
        }
    }

    private void setEntryFieldColor(List<CellStyle> csList, String field, int i, String color) {
        CellStyle cs = new CellStyle();
        cs.setBackColor(color);
        cs.setFieldKey(field);
        cs.setRow(i);
        csList.add(cs);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if ("executeschedule".equals(property) || "scheduledetail".equals(property) || "executesdate".equals(property)) {
            IPageCache cache = this.getPageCache();
            cache.put("focus", "false");
            this.doExecEnableBtn(false);
            this.setEntryFieldsStatus(true, "#FFFACD");
        }
    }

    private void doExecEnableBtn(boolean status) {
        MainEntityType mainType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        for (ControlAp control : formMeta.getItems()) {
            String key;
            if (!(control instanceof BarItemAp) || (key = control.getKey()).equals("bar_execsche") || key.equals("bar_cancelexec")) continue;
            this.getView().setVisible(Boolean.valueOf(status), new String[]{key});
        }
        this.getView().setVisible(Boolean.valueOf(!status), new String[]{"bar_execsche", "bar_cancelexec"});
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        String logStatus = inquiryObject.getString("logstatus");
        return logStatus == null ? "" : logStatus.toLowerCase();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String validMessage;
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if ((operateKey.equals("confirm") || operateKey.equals("unconfirm") || operateKey.equals("push") || operateKey.equals("push2")) && this.getModel().getValue("billstatus").equals("D")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u7684\u8ba2\u5355\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ScpOrderEdit_0", (String)"scm-scp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)MessageFormat.format("\u8ba2\u5355\u201c{0}\u201d\u5df2\u5173\u95ed\u3002", this.getModel().getValue("billno")), (String)"ScpOrderEdit_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            e.setCancel(true);
        }
        if (operateKey.equals("agreeorder")) {
            e.setCancel(true);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"agreeorder", (String)"scp_order", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.setBarStatus("B");
                this.getView().updateView();
            } else {
                for (IOperateInfo errorInfo : operationResult.getAllErrorOrValidateInfo()) {
                    this.getView().showTipNotification(errorInfo.getMessage());
                }
            }
        }
        if (operateKey.equals("batchpush")) {
            AutoPushSalOutUtil.autoPushToSalOut();
        } else if ("push".equals(operateKey) || "push2".equals(operateKey)) {
            DynamicObject entryRow;
            boolean isCancel = false;
            LinkedHashMap checkMap = new LinkedHashMap();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
            int[] rowIndexs = entryGrid.getSelectRows();
            HashSet<Long> selectRows = new HashSet<Long>(156);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (rowIndexs.length > 0) {
                for (int rowIndex : rowIndexs) {
                    entryRow = this.getView().getModel().getEntryRowEntity("materialentry", rowIndex);
                    selectRows.add(entryRow.getLong("id"));
                }
            } else {
                Object object = dataEntity.getDynamicObjectCollection("materialentry").iterator();
                while (object.hasNext()) {
                    DynamicObject row2 = (DynamicObject)object.next();
                    selectRows.add(row2.getLong("id"));
                }
            }
            checkMap.put(this.getModel().getDataEntity().getLong("id"), selectRows);
            Map result = ScpOrderBillHelper.verifyOrderRowCanStock(checkMap);
            Set salOutStockBillIds = (Set)result.get("data");
            Object message = result.get("message");
            IFormView mainView = this.getView().getMainView();
            if (salOutStockBillIds != null && !salOutStockBillIds.isEmpty()) {
                e.setCancel(true);
                isCancel = true;
                this.getPageCache().put("salOutStockBillIds", StringUtils.join((Object[])salOutStockBillIds.toArray(new Long[salOutStockBillIds.size()]), (String)","));
                this.showConfirmPage(message.toString());
            } else if (!((Boolean)result.get("succed")).booleanValue()) {
                if (mainView != null && message != null) {
                    mainView.showTipNotification(message.toString(), Integer.valueOf(Integer.parseInt("12000")));
                    this.getView().sendFormAction(mainView);
                }
                e.setCancel(true);
                isCancel = true;
            } else {
                if (mainView != null && message != null) {
                    mainView.showTipNotification(message.toString(), Integer.valueOf(Integer.parseInt("12000")));
                    this.getView().sendFormAction(mainView);
                }
                entryRow = OperationServiceHelper.executeOperate((String)"agreeorder", (String)"scp_order", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()});
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("materialentry");
            List orderEntryIds = entryEntity.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            if (!isCancel && ScpOrderBillHelper.check((BeforeDoOperationEventArgs)e, orderEntryIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba2\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u6216\u8005\u6536\u8d27\uff0c\u4e0d\u80fd\u518d\u53d1\u8d27\u3002", (String)"ScpOrderEdit_5", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("uploadfile".equals(operateKey)) {
            this.setContainerCollapse(true);
        }
        if ("acceptapplytrackdown".equals(operateKey) || "saltrackdown".equals(operateKey)) {
            this.trackDown(operateKey);
        }
        if ("acceptapplypush".equals(operateKey)) {
            OperationServiceHelper.executeOperate((String)"confirm", (String)"scp_order", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()});
        }
        if ("initiatechange".equals(operateKey) && StringUtils.isNotBlank((CharSequence)(validMessage = ScpSupInitiateChangeUtil.permissionValid()))) {
            this.getView().showErrorNotification(validMessage);
            e.setCancel(true);
        }
    }

    private void trackDown(String operateKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ArrayList<Long> pksList = new ArrayList<Long>(8);
        pksList.add((Long)dataEntity.getPkValue());
        ScpOrderFormHelper.trackDown(this.getView(), operateKey, pksList);
    }

    private void showConfirmPage(String message) {
        HashMap<String, String> customMap = new HashMap<String, String>(16);
        customMap.put("param", "orderPush");
        customMap.put("message", message);
        this.getView().showForm(ScpBillFormHelper.assembleDraftBillConfirm(customMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orderPushEdit")));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        Object enter = callBackEvent.getReturnData();
        if (enter != null && "enter".equals(enter.toString()) && "orderPushEdit".equals(actionId)) {
            String salOutBillIds = this.getPageCache().get("salOutStockBillIds");
            List<String> billIdList = Arrays.asList(salOutBillIds.split(","));
            ArrayList<Long> salOutStockBillIds = new ArrayList<Long>(billIdList.size());
            billIdList.forEach(t -> salOutStockBillIds.add(Long.parseLong(t)));
            this.getView().showForm(ScpSaloutStockFormHelper.getShowParam(salOutStockBillIds));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "confirm": {
                    this.setBarStatus("B");
                    break;
                }
                case "agreeorder": {
                    this.setBarStatus("B");
                    break;
                }
                case "reject": {
                    this.setBarStatus("C");
                    break;
                }
                case "unconfirm": {
                    this.setBarStatus("A");
                    break;
                }
                case "execsche": 
                case "cancelexec": {
                    this.getPageCache().remove("focus");
                    this.getView().getFormShowParameter().getCustomParams().remove("execprogress");
                    this.doExecEnableBtn(true);
                    this.setEntryFieldsStatus(false, "#ffffff");
                    break;
                }
                case "execprogress": {
                    this.doExecEnableBtn(false);
                    this.setEntryFieldsStatus(true, "#FFFACD");
                    break;
                }
                case "initiatechange": {
                    ScpSupInitiateChangeUtil.initiateChangeOp((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView());
                    break;
                }
                case "push2moduleconsumegeneral": {
                    Long ruleId = 2000716804980439040L;
                    String consumemomentbotp = ScpModuleConsumeHelper.getConsumeMomentBotp((String)"consumemomentbotp");
                    if (StringUtils.isNotEmpty((CharSequence)consumemomentbotp)) {
                        ruleId = Long.parseLong(consumemomentbotp);
                    }
                    this.push2ModuleConSume(dataEntity, ruleId);
                    break;
                }
                case "push2moduleconsumeshort": {
                    Long shortRuleId = 2000890605101873152L;
                    String shortconsumemomentbotp = ScpModuleConsumeHelper.getConsumeMomentBotp((String)"shortconsumemomentbotp");
                    if (StringUtils.isNotEmpty((CharSequence)shortconsumemomentbotp)) {
                        shortRuleId = Long.parseLong(shortconsumemomentbotp);
                    }
                    this.push2ModuleConSume(dataEntity, shortRuleId);
                }
            }
            if ("cancelexec".equals(operateKey) || "execsche".equals(operateKey)) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void push2ModuleConSume(DynamicObject dataEntity, Long ruleId) {
        Object successPkIds;
        Map resultMap;
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(8);
        HashMap pushOrderData = new HashMap(8);
        HashMap paramMap = new HashMap(8);
        Set<Long> selectEntryIds = this.getSelectRows(dataEntity);
        ScpModuleConsumeHelper.buildParamByOrder((DynamicObject[])new DynamicObject[]{dataEntity}, selectEntryIds, pushOrderData);
        if (CollectionUtils.isEmpty(pushOrderData)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7ec4\u4ef6\u6d88\u8017\u6c47\u62a5/\u7ec4\u4ef6\u6d88\u8017\u9000\u56de\u7684\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"ScpOrderEdit_4", (String)"scm-scp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)MessageFormat.format("\u8ba2\u5355\u201c{0}\u201d\u5df2\u5173\u95ed\u3002", this.getModel().getValue("billno")), (String)"ScpOrderEdit_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            return;
        }
        toStockParamMap.put("sourceEntity", "scp_order");
        toStockParamMap.put("targetEntity", "scp_moduleconsume");
        toStockParamMap.put("paramMap", paramMap);
        toStockParamMap.put("botpNumber", ruleId);
        toStockParamMap.put("billStatus", BillStatus.SAVE.getVal());
        toStockParamMap.put("pushOrderData", pushOrderData);
        Object invokeBizService = DispatchServiceHelper.invokeBizService((String)"scm", (String)"scp", (String)"IScpSalOutAuditAutoModuleConsumeService", (String)"autoCreateModuleConsumeService", (Object[])new Object[]{toStockParamMap});
        if (invokeBizService instanceof Map && (resultMap = (Map)invokeBizService) != null && (successPkIds = resultMap.get("data")) instanceof Set) {
            Set pkIds = (Set)successPkIds;
            if (!pkIds.isEmpty() && pkIds.size() == 1) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("scp_moduleconsume");
                billShowParameter.setBillStatus(BillOperationStatus.EDIT);
                billShowParameter.setPkId(pkIds.iterator().next());
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)billShowParameter);
            } else if (!pkIds.isEmpty() && pkIds.size() > 1) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("scp_moduleconsume");
                listShowParameter.setFormId("bos_list");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)pkIds));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private Set<Long> getSelectRows(DynamicObject dataEntity) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        int[] rowIndexs = entryGrid.getSelectRows();
        HashSet<Long> selectRows = new HashSet<Long>(156);
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("materialentry");
        if (rowIndexs != null && rowIndexs.length > 0) {
            for (int rowIndex : rowIndexs) {
                DynamicObject entryRow = this.getView().getModel().getEntryRowEntity("materialentry", rowIndex);
                selectRows.add(entryRow.getLong("id"));
            }
        } else {
            for (DynamicObject entryRow : entryRows) {
                selectRows.add(entryRow.getLong("id"));
            }
        }
        return selectRows;
    }

    private void setBarStatus(String status) {
        if (null == status) {
            return;
        }
        switch (status) {
            case "A": {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_confirm"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_reject"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unconfirm"});
                break;
            }
            case "B": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_confirm"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_reject"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unconfirm"});
                break;
            }
            case "C": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_confirm"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_reject"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unconfirm"});
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Map<String, Object> resultMap;
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>(1024);
        HashMap<String, ArrayList<Map<String, Object>>> attachMap = new HashMap<String, ArrayList<Map<String, Object>>>(8);
        Object[] urls = evt.getUrls();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        for (Object url : urls) {
            Map attachDynMap = (Map)url;
            attachList.add(attachDynMap);
        }
        attachMap.put("supattachmentpanel", attachList);
        AttachmentServiceHelper.saveTempAttachments((String)"pur_order", (Object)dataEntity.getPkValue(), (String)"scp", attachMap);
        if (ApiConfigUtil.hasCQScmConfig() && ((resultMap = this.executeManualSceneHander(attachList, dataEntity, "A")) == null || !Boolean.parseBoolean(String.valueOf(resultMap.get("success"))))) {
            this.deleteAttach(urls, dataEntity);
            StringBuilder strBuilder = new StringBuilder();
            String loadKDString = ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25:", (String)"ScpOrderEdit_2", (String)"scm-scp-formplugin", (Object[])new Object[0]);
            strBuilder.append(loadKDString);
            strBuilder.append(resultMap != null ? resultMap.get("message") : "");
            this.getView().showErrorNotification(strBuilder.toString());
        }
        if (ApiConfigUtil.hasEASScmConfig() || ApiConfigUtil.hasXKScmConfig()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"attachsync", (String)"pur_order", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)option);
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.remove("TampAttCache" + this.getView().getPageId());
    }

    public static List<DynamicObject> buildDynamicObjectData(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1024);
        ArrayList allRows = new ArrayList(1024);
        for (DynamicObject bill : dynamicObjects) {
            allRows.addAll(bill.getDynamicObjectCollection("materialentry"));
        }
        final Iterator allRowsIterator = allRows.iterator();
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("entryid", (DataType)DataType.LongType), new Field("jointdatachannelid", (DataType)DataType.StringType), new Field("poentryid", (DataType)DataType.StringType), new Field("businesstype", (DataType)DataType.StringType)});
        DataSet dataSet = Algo.create((String)"buildDynamicObjectData").createDataSet((Iterator)new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return allRowsIterator.hasNext();
            }

            @Override
            public Object[] next() {
                DynamicObject row = (DynamicObject)allRowsIterator.next();
                DynamicObject bill = (DynamicObject)row.getParent();
                Long id = bill.getLong("id");
                String billNo = bill.getString("id");
                Long entryid = row.getLong("id");
                String jointdatachannelid = row.getString("jointdatachannelid");
                String poentryid = row.getString("poentryid");
                DynamicObject businesstype = bill.getDynamicObject("businesstype");
                String businesstypeNumber = "";
                if (businesstype != null) {
                    businesstypeNumber = businesstype.getString("number");
                }
                return new Object[]{id, billNo, entryid, jointdatachannelid, poentryid, businesstypeNumber};
            }
        }, rowMeta);
        ORM orm = ORM.create();
        dynamicObjectList.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(dataSet));
        return dynamicObjectList;
    }

    private Map<String, Object> executeManualSceneHander(List<Map<String, Object>> attachList, DynamicObject dataEntity, String type) {
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("materialentry");
        HashMap<String, String> customMap = new HashMap<String, String>(8);
        customMap.put("orderBillId", ((DynamicObject)entryCol.get(0)).getString("pobillid"));
        customMap.put("attachmentList", JSON.toJSONString(attachList));
        customMap.put("type", type);
        List<DynamicObject> arrayList = ScpOrderEdit.buildDynamicObjectData(new DynamicObject[]{dataEntity});
        MultiDataHandleResult executeManualSceneHandle = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualorderuploadfile", arrayList, customMap);
        String message = executeManualSceneHandle.getMessage();
        Map resultMap = null;
        if (StringUtils.isNotBlank((CharSequence)message)) {
            try {
                String parse = (String)SerializationUtils.fromJsonString((String)message, String.class);
                resultMap = (Map)SerializationUtils.fromJsonString((String)parse, Map.class);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }
        return resultMap;
    }

    public void afterRemove(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>(1024);
        for (Object url : urls) {
            Map attachDynMap = (Map)url;
            attachList.add(attachDynMap);
        }
        if (ApiConfigUtil.hasCQScmConfig()) {
            Map<String, Object> resultMap = this.executeManualSceneHander(attachList, dataEntity, "B");
            if (resultMap != null && Boolean.parseBoolean(String.valueOf(resultMap.get("success")))) {
                this.deleteAttach(urls, dataEntity);
            } else {
                StringBuilder strBuilder = new StringBuilder();
                String loadKDString = ResManager.loadKDString((String)"\u9644\u4ef6\u5220\u9664\u5931\u8d25:", (String)"ScpOrderEdit_3", (String)"scm-scp-formplugin", (Object[])new Object[0]);
                strBuilder.append(loadKDString);
                strBuilder.append(resultMap != null ? resultMap.get("message") : "");
                this.getView().showErrorNotification(strBuilder.toString());
            }
        }
        if (ApiConfigUtil.hasEASScmConfig() || ApiConfigUtil.hasXKScmConfig()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"attachsync", (String)"pur_order", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)option);
        }
    }

    private void deleteAttach(Object[] urls, DynamicObject dataEntity) {
        QFilter qFilters = new QFilter("fattachmentpanel", "=", (Object)"supattachmentpanel");
        qFilters.and(new QFilter("FInterID", "=", (Object)dataEntity.getString("id")));
        qFilters.and(new QFilter("FBillType", "=", (Object)"pur_order"));
        HashSet<String> attachIdset = new HashSet<String>(1024);
        for (Object url : urls) {
            Map attachDynMap = (Map)url;
            attachIdset.add(String.valueOf(attachDynMap.get("uid")));
        }
        QFilter attachfilter = new QFilter("FNUMBER", "in", attachIdset);
        qFilters.and(attachfilter);
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qFilters.toArray());
    }
}

