/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.scp.business.ScpAutoStockBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;
import kd.scm.scp.common.helper.ShelfLifeDateUtil;
import kd.scm.scp.common.util.ScpBillUtil;
import kd.scm.scp.formplugin.ScpCoreBillEditPlugin;

public class ScpSalOutStockEditPlugin
extends ScpCoreBillEditPlugin
implements IConfirmCallBack,
EntryGridBindDataListener {
    private static final String KEY_CLOSE = "bar_checkclose";
    private static final String KEY_OPEN = "bar_checkopen";
    private static final String KEY_DELIVERY = "bar_delivery";
    private static final String KEY_UNDELIVERY = "bar_undelivery";
    private static final String BILLSTATUS = "billstatus";
    private static final String CHECKSTATUS = "checkstatus";
    private static final String ENTITYENTRY = "materialentry";
    private static final String OPENSTATUS = "A";
    private static final String CLOSESTATUS = "B";
    private static final String CHECKQTY_ACTION = "checkqty_action";
    private static final String AUDITOR = "auditor";
    private static final String AUDITDATE = "auditdate";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData() {
        this.setCurrentContacter();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initBaseQty();
    }

    private Boolean getIsAutoReceive() {
        Boolean isAutoReceive = Boolean.FALSE;
        HashSet<Long> unitOrgIds = new HashSet<Long>(16);
        unitOrgIds.add(this.getModel().getDataEntity().getLong("org.id"));
        Map autoReceiptNoticeBill = ScpAutoStockBillHelper.verifyAutoReceiptBill(unitOrgIds);
        isAutoReceive = autoReceiptNoticeBill.values().stream().allMatch(row -> row);
        return isAutoReceive;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Object billstatus;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        if ("signout".equals(operate.getOperateKey()) && OPENSTATUS.equals(billstatus = this.getModel().getValue(BILLSTATUS))) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u8d27\u5355\u5904\u4e8e\u8349\u7a3f\u72b6\u6001\uff0c\u786e\u8ba4\u53d1\u8d27\u540e\u624d\u751f\u6548\uff0c\u662f\u5426\u786e\u8ba4\u53d1\u8d27\uff1f", (String)"ScpSalOutStockEditPlugin_8", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CHECKSTATUS));
        }
    }

    private void setCurrentContacter() {
        QFilter qFilter = new QFilter("user", "=", (Object)UserServiceHelper.getCurrentUserId()).and(new QFilter("status", "=", (Object)"C"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"scp_bizperson", (String)"masterid,name,number", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            IDataModel model = this.getModel();
            model.setValue("contacter", dynamicObject.getPkValue());
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            if (("unaudit".equals(operateKey) || "save".equals(operateKey)) && !ApiConfigUtil.hasEASScmConfig()) {
                this.setRowEnable();
            }
            if ("submit".equals(operateKey) || "audit".equals(operateKey) || "save".equals(operateKey)) {
                BillModel model = (BillModel)this.getModel();
                model.load(model.getPKValue());
                this.getView().updateView(BILLSTATUS);
                this.getView().updateView("logstatus");
                this.getView().updateView("materialentry.rowlogstatus");
                this.getView().updateView("delidate");
                this.getView().updateView(AUDITOR);
                this.getView().updateView(AUDITDATE);
                this.getView().updateView(ENTITYENTRY);
                this.resetButtonStatus();
            } else if ("unaudit".equals(operateKey)) {
                this.resetButtonStatus();
            }
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        super.beforeBatchFillEntry(e);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObjectCollection focusEntry = this.getView().getModel().getEntryEntity(ENTITYENTRY);
        HashSet<Long> materialSet = new HashSet<Long>(focusEntry.size());
        for (DynamicObject entry : focusEntry) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            materialSet.add(Long.parseLong(material.getPkValue().toString()));
        }
        Map materialInvInfos = MaterialUtil.getMaterialInventoryinfo(materialSet, (long)((Long)org.getPkValue()), (String)"materialid,id,enablelot,enableshelflifemgr");
        e.setPredicate(e.getPredicate().and(rowItem -> {
            int row = rowItem.getRow();
            IDataEntityProperty selProp = rowItem.getSelProp();
            switch (selProp.getName()) {
                case "proddate": 
                case "duedate": {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTITYENTRY, row);
                    DynamicObject material = entryRowEntity.getDynamicObject("material");
                    if (material == null) {
                        return false;
                    }
                    Long materialId = (Long)material.getPkValue();
                    DynamicObject materialInvInfo = (DynamicObject)materialInvInfos.get(materialId);
                    return materialInvInfo != null && materialInvInfo.getBoolean("enableshelflifemgr");
                }
            }
            return true;
        }));
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity(ENTITYENTRY);
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            qty = entry.getBigDecimal("qty");
            sumQty = sumQty.add(qty);
        }
        model.setValue("sumqty", (Object)sumQty);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String billno;
        String billStatus;
        String key = evt.getItemKey();
        DynamicObject currentObj = this.getModel().getDataEntity();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if ((key.equals(KEY_CLOSE) || key.equals(KEY_OPEN)) && !(billStatus = currentObj.getString(BILLSTATUS)).equals(BillStatusEnum.AUDIT.getVal())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u53d1\u8d27\u5355\u624d\u80fd\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c\u3002", (String)"ScpSalOutStockEditPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (key.equals(KEY_DELIVERY) && (billno = currentObj.getString("billno")).trim().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d1\u8d27\u5355\u53f7\u3002", (String)"ScpSalOutStockEditPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_checkclose": {
                this.checkClose(CLOSESTATUS, ResManager.loadKDString((String)"\u5173\u95ed", (String)"ScpSalOutStockEditPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_checkopen": {
                this.checkClose(OPENSTATUS, ResManager.loadKDString((String)"\u5f00\u542f", (String)"ScpSalOutStockEditPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_revoke": {
                String billstatus = this.getModel().getDataEntity(true).getString(BILLSTATUS);
                if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                    this.getView().invokeOperation("unaudit");
                    break;
                }
                this.getView().invokeOperation("unsubmit");
                break;
            }
        }
    }

    private void checkClose(String checkstatus, String operate) {
        DynamicObject mainDataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = mainDataEntity.getDynamicObjectCollection(ENTITYENTRY);
        if (rows == null || rows.size() == 0) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTITYENTRY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u66f4\u65b0\u7684\u5206\u5f55\uff0c\u53ef\u4ee5\u591a\u9009\u6216\u5168\u9009\u3002", (String)"ScpSalOutStockEditPlugin_4", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        int count = 0;
        for (int i = 0; i < selectRows.length; ++i) {
            int index = selectRows[i];
            if (((DynamicObject)rows.get(index)).getString(CHECKSTATUS).equals(checkstatus)) continue;
            this.getModel().setValue(CHECKSTATUS, (Object)checkstatus, index);
            ++count;
        }
        if (count == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u540e\u518d\u66f4\u65b0\u3002", (String)"ScpSalOutStockEditPlugin_5", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        SaveServiceHelper.save((IDataEntityType)mainDataEntity.getDynamicObjectType(), (Object[])new Object[]{mainDataEntity});
        this.getModel().setDataChanged(false);
        this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u72b6\u6001{0}\u6210\u529f\uff0c\u5171\u5904\u7406\u4e86{1}\u7b14\u5206\u5f55\u3002", (String)"ScpSalOutStockEditPlugin_6", (String)"scm-scp-formplugin", (Object[])new Object[0]), operate, count), MessageBoxOptions.OK);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetButtonStatus();
        this.initQtyMap();
        if (!ApiConfigUtil.hasEASScmConfig()) {
            this.setRowEnable();
        }
        if (this.getIsAutoReceive().booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"autorecbillno"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"autorecbillno"});
        }
        this.getView().setVisible(this.checkDSNoVisible(), new String[]{"dsbillno"});
        String consumeMoment = ScpSalOutStockBillHelper.getConsumeMoment();
        if ("order".equals(consumeMoment)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_submat"});
        }
    }

    private Boolean checkDSNoVisible() {
        try {
            String dsbillno = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTITYENTRY).get(0)).getString("dsbillno");
            return !dsbillno.trim().isEmpty();
        }
        catch (RuntimeException exception) {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)exception);
            return false;
        }
    }

    private void initBaseQty() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTITYENTRY);
        ScpBillUtil.updateEntryBasicQtyAll((DynamicObjectCollection)cols);
        this.getView().updateView(ENTITYENTRY);
    }

    public void resetButtonStatus() {
        DynamicObject recruitObject = this.getModel().getDataEntity(true);
        Long billId = recruitObject.getLong("id");
        Boolean loginputShow = !OPENSTATUS.equals(recruitObject.getString(BILLSTATUS)) || QueryServiceHelper.exists((String)this.getView().getEntityId(), (Object)billId);
        this.getView().setVisible(loginputShow, new String[]{"bar_loginput"});
        DynamicObjectCollection Rowcoll = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTITYENTRY);
        boolean istrue = false;
        for (DynamicObject obj : Rowcoll) {
            BigDecimal receiptqty = obj.getBigDecimal("sumreceiptqty");
            BigDecimal instockqty = obj.getBigDecimal("suminstockqty");
            if (receiptqty.compareTo(BigDecimal.ZERO) <= 0 && instockqty.compareTo(BigDecimal.ZERO) <= 0) continue;
            istrue = true;
            break;
        }
        if (istrue) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_delfix"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delfix"});
        }
        String status = recruitObject.getString(BILLSTATUS);
        if (status == null) {
            return;
        }
        switch (status) {
            case "A": 
            case "B": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DELIVERY});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_UNDELIVERY});
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DELIVERY});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_UNDELIVERY});
                break;
            }
        }
    }

    public void initQtyMap() {
        String pageId = this.getView().getPageId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Long pkValue = (Long)dataEntity.getPkValue();
        HashMap<String, String> map = new HashMap<String, String>(8);
        DynamicObjectCollection cols = dataEntity.getDynamicObjectCollection(ENTITYENTRY);
        for (int i = 0; i < cols.size(); ++i) {
            BigDecimal qty = ((DynamicObject)cols.get(i)).getBigDecimal("qty");
            Long id = ((DynamicObject)cols.get(i)).getLong("id");
            String poentryId = ((DynamicObject)cols.get(i)).getString("poentryid");
            String key = String.valueOf(id) + poentryId;
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            map.put(key, qty.toPlainString());
        }
        this.getView().getPageCache().put(pageId + pkValue.toString(), JSON.toJSONString(map));
    }

    @Deprecated
    public BigDecimal getInitQty(Long id) {
        BigDecimal ret = this.getInitQty(String.valueOf(id));
        return ret;
    }

    private BigDecimal getInitQty(String str) {
        BigDecimal ret = null;
        String pageId = this.getView().getPageId();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        String strMap = this.getView().getPageCache().get(pageId + pkValue);
        if (!StringUtils.isEmpty((CharSequence)strMap)) {
            JSONObject map = JSON.parseObject((String)strMap);
            if (CollectionUtils.isEmpty((Map)map) || !map.containsKey(str)) {
                return ret;
            }
            String qtyStr = (String)map.get(str);
            if (!StringUtils.isEmpty((CharSequence)qtyStr)) {
                ret = new BigDecimal(qtyStr);
            }
        }
        return ret;
    }

    public void releasInitQtyMap() {
        String pageId = this.getView().getPageId();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        this.getView().getPageCache().remove(pageId + pkValue.toString());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        for (ChangeData changeData : e.getChangeSet()) {
            String msg;
            IDataModel dataModel = this.getModel();
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = dataModel.getEntryCurrentRowIndex(ENTITYENTRY);
            if (rowIndex >= 0 && currentRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl(ENTITYENTRY);
                grid.selectRows(rowIndex, true);
            }
            Object oldValue = changeData.getOldValue();
            Object newValue = changeData.getNewValue();
            if ("qty".equals(property.getName())) {
                ScpBillUtil.updateEntryBasicQtyByLineIndex((DynamicObject)this.getModel().getEntryRowEntity(ENTITYENTRY, rowIndex));
                if (ScpBillUtil.compareQtyAndSumQty((DynamicObject)this.getModel().getDataEntity(true), (int)rowIndex)) {
                    this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7d2f\u8ba1\u53d1\u8d27\u6570\u91cf\u5c06\u5927\u4e8e\u6e90\u8ba2\u5355\u6570\u91cf\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8d85\u989d\u3002", (String)"ScpSalOutStockEditPlugin_7", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHECKQTY_ACTION));
                }
            } else if ("proddate".equals(property.getName())) {
                msg = ShelfLifeDateUtil.changeProduceDate((DynamicObject)this.getModel().getEntryRowEntity(ENTITYENTRY, rowIndex), (Date)((Date)oldValue), (Date)((Date)newValue), (DynamicObject)this.getModel().getDataEntity().getDynamicObject("org"), (int)rowIndex);
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    this.getView().showErrorNotification(msg);
                    this.getModel().setValue("proddate", null, rowIndex);
                }
            } else if ("duedate".equals(property.getName()) && StringUtils.isNotEmpty((CharSequence)(msg = ShelfLifeDateUtil.changeExpiryDate((DynamicObject)this.getModel().getEntryRowEntity(ENTITYENTRY, rowIndex), (Date)((Date)oldValue), (Date)((Date)newValue), (DynamicObject)this.getModel().getDataEntity().getDynamicObject("org"), (int)rowIndex)))) {
                this.getView().showErrorNotification(msg);
                this.getModel().setValue("duedate", null, rowIndex);
            }
            if (!"curconsumesubqty".equals(property.getName())) continue;
            ScpBillUtil.updateEntryBasicQtyByLineIndex((String)property.getName(), (String)"curconsumesubbaseqty", (DynamicObject)this.getModel().getEntryRowEntity("subentryentity", rowIndex));
        }
        super.propertyChanged(e);
        if (!ApiConfigUtil.hasEASScmConfig()) {
            this.setRowEnable();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(CHECKQTY_ACTION) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Cancel)) {
            String index = this.getPageCache().get("rowIndex");
            int rowIndex = 0;
            rowIndex = null == index ? this.getModel().getEntryCurrentRowIndex(ENTITYENTRY) : Integer.parseInt(index.toString());
            DynamicObject entryObj = this.getModel().getEntryRowEntity(ENTITYENTRY, rowIndex);
            Long id = entryObj.getLong("id");
            String poentryId = entryObj.getString("poentryid");
            BigDecimal qty = this.getInitQty(String.valueOf(id) + poentryId);
            ScpBillUtil.resetQty((DynamicObject)this.getModel().getDataEntity(true), (BigDecimal)qty, (int)rowIndex);
            this.getView().updateView(ENTITYENTRY);
        } else if (CHECKSTATUS.equals(callBackId)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                OperationResult result = this.getView().invokeOperation("submit");
                if (result.isSuccess()) {
                    this.getView().close();
                }
            } else {
                this.getView().close();
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releasInitQtyMap();
        e.setCheckDataChange(false);
    }

    private void setRowEnable() {
        IFormView view = this.getView();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection col = data.getDynamicObjectCollection(ENTITYENTRY);
        HashSet<Long> materialSet = new HashSet<Long>(col.size());
        DynamicObject material = null;
        int rowIndex = 0;
        for (DynamicObject entry : col) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"proddate"});
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"duedate"});
            material = entry.getDynamicObject("material");
            if (material != null) {
                materialSet.add(Long.parseLong(material.getPkValue().toString()));
            }
            ++rowIndex;
        }
        long orgid = 0L;
        if (data.getDynamicObject("org") != null) {
            orgid = Long.parseLong(data.getDynamicObject("org").getPkValue().toString());
        }
        if (materialSet.size() == 0 || orgid == 0L) {
            return;
        }
        Map materialMap = MaterialUtil.getMaterialInventoryinfo(materialSet, (long)orgid, (String)"materialid,id,enablelot,enableshelflifemgr");
        DynamicObject materialInvInfo = null;
        rowIndex = 0;
        for (DynamicObject entry : col) {
            material = entry.getDynamicObject("material");
            if (material == null) {
                ++rowIndex;
                continue;
            }
            materialInvInfo = (DynamicObject)materialMap.get(material.getPkValue());
            if (materialInvInfo != null) {
                boolean isEnableShelfLife = materialInvInfo.getBoolean("enableshelflifemgr");
                view.setEnable(Boolean.valueOf(isEnableShelfLife), rowIndex, new String[]{"proddate"});
                view.setEnable(Boolean.valueOf(isEnableShelfLife), rowIndex, new String[]{"duedate"});
            }
            ++rowIndex;
        }
    }
}

