/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.scp.common.util.ScpIminventorySyncTaskUtil;
import kd.scm.scp.formplugin.ScpVMIPanelService;

public class ScpVMIPanelPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(ScpVMIPanelPlugin.class);
    private final ScpVMIPanelService scpVMIPanelService = new ScpVMIPanelService();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(ApiConfigUtil.hasCQScmConfig() || ApiConfigUtil.hasXKScmConfig()), new String[]{"barrep"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData(null);
    }

    private QFilter initData(HashSet<String> materialFilters) {
        QFilter invqFilter = this.scpVMIPanelService.getInitCommonQfilter();
        Map customParam = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Object ids = customParam.get("ids");
        String isrefresh = this.getPageCache().get("isrefresh");
        if (null != ids && StringUtils.isEmpty((CharSequence)isrefresh)) {
            invqFilter.and(new QFilter("id", "in", ids));
        }
        RequestContext rc = RequestContext.get();
        Set idSet = BizPartnerUtil.getBizPartnerIds();
        HasPermOrgResult permission = PermissionServiceHelper.getAllPermOrgs((long)rc.getCurrUserId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (boolean)false, null, (String)"scp_vmipanel", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("supplier.bizpartner", "in", (Object)idSet);
        qFilter.and(new QFilter("createorg", "in", (Object)permission.getHasPermOrgs()));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("entryentity.entryusestatus", "=", (Object)"1"));
        DynamicObjectCollection pur_conmatreials = QueryServiceHelper.query((String)"pur_conmatreial", (String)"entryentity.material,entryentity.entryusestatus", (QFilter[])qFilter.toArray());
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        if (pur_conmatreials.size() > 0) {
            for (DynamicObject row : pur_conmatreials) {
                if (!"1".equals(row.getString("entryentity.entryusestatus"))) continue;
                materialIdSet.add(row.getLong("entryentity.material"));
            }
        }
        if (null != materialFilters && materialFilters.size() > 0) {
            QFilter materialNameFilter = this.getSearchFilter("material.name", materialFilters);
            QFilter materialNumFilter = this.getSearchFilter("material.number", materialFilters);
            if (null != materialNameFilter && null != materialNumFilter) {
                invqFilter.and(materialNameFilter.or(materialNumFilter));
            }
            QFilter entryMaterialNameFilter = this.getSearchFilter("entryentity.material.name", materialFilters);
            QFilter entryMaterialNumFilter = this.getSearchFilter("entryentity.material.number", materialFilters);
            if (null != entryMaterialNameFilter && null != entryMaterialNumFilter) {
                qFilter.and(entryMaterialNameFilter.or(entryMaterialNumFilter));
            }
        }
        this.initImInventory(invqFilter, materialIdSet, permission.getHasPermOrgs(), qFilter);
        return invqFilter;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if ("barrep".equals(itemKey)) {
            this.checkBarrep(selectRows, model, view, evt);
        }
        if ("updatainv".equals(itemKey)) {
            this.checkUpdatainv(model, view, evt);
        }
    }

    private void checkUpdatainv(IDataModel model, IFormView view, BeforeItemClickEvent evt) {
        DynamicObjectCollection pur_iminventory = this.scpVMIPanelService.initImInventory(this.initData(null), false);
        if (pur_iminventory.size() > 0) {
            DynamicObject dyn = (DynamicObject)pur_iminventory.get(0);
            Date update = dyn.getDate("updatetime");
            Date currentSystemTime = TimeServiceHelper.getCurrentSystemTime();
            Calendar datatdate = Calendar.getInstance();
            Calendar sysdate = Calendar.getInstance();
            datatdate.setTime(update);
            sysdate.setTime(currentSystemTime);
            long datatime = datatdate.getTimeInMillis();
            long systime = sysdate.getTimeInMillis();
            long minute = (systime - datatime) / 60000L;
            if (minute < 10L) {
                view.showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpVMIPanelPlugin_31", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List curSupplierId = BizPartnerUtil.getSupplierByUserOfBizPartner();
            if (curSupplierId.size() == 0) {
                view.showMessage(ResManager.loadKDString((String)"\u7528\u6237\u672a\u5173\u8054\u4f9b\u5e94\u5546\u3002", (String)"ScpVMIPanelPlugin_32", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void checkBarrep(int[] selectRows, IDataModel model, IFormView view, BeforeItemClickEvent evt) {
        if (selectRows.length > 0) {
            if (selectRows.length > 1) {
                Boolean isSame = true;
                for (int i = 0; i < selectRows.length - 1; ++i) {
                    DynamicObject srcDyObj = model.getEntryRowEntity("entryentity", selectRows[i]);
                    DynamicObject tarDyObj = model.getEntryRowEntity("entryentity", selectRows[i + 1]);
                    DynamicObject srcRecorg = srcDyObj.getDynamicObject("recorg");
                    DynamicObject tarRecorg = tarDyObj.getDynamicObject("recorg");
                    if (null == srcRecorg || null == tarRecorg || srcRecorg.getString("id").equals(tarRecorg.getString("id"))) continue;
                    isSame = false;
                    break;
                }
                if (!isSame.booleanValue()) {
                    view.showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ScpVMIPanelPlugin_23", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.checkOutQty(selectRows, model, view, evt);
            } else {
                this.checkOutQty(selectRows, model, view, evt);
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u8fdb\u884c\u8865\u8d27\u3002", (String)"ScpVMIPanelPlugin_22", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private void checkOutQty(int[] selectRows, IDataModel model, IFormView view, BeforeItemClickEvent evt) {
        Boolean isOutStatus = true;
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject srcDyObj = model.getEntryRowEntity("entryentity", selectRows[i]);
            if (null == srcDyObj || !"C".equals(srcDyObj.getString("status"))) continue;
            isOutStatus = false;
            break;
        }
        if (!isOutStatus.booleanValue()) {
            view.showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5b58\u5728\u8d85\u91cf\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ScpVMIPanelPlugin_30", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public Long getCurSupplierId() {
        RequestContext rc = RequestContext.get();
        if (null == rc.getBizPartnerId()) {
            return -1L;
        }
        long curBizPartner = rc.getBizPartnerId();
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)curBizPartner)});
        return supplier == null ? 0L : supplier.getLong("id");
    }

    private QFilter getSearchFilter(String name, HashSet<String> materialFilters) {
        QFilter qFilter = null;
        for (String key : materialFilters) {
            if (qFilter == null) {
                qFilter = new QFilter(name, "like", (Object)("%" + key + "%"));
                continue;
            }
            qFilter.or(new QFilter(name, "like", (Object)("%" + key + "%")));
        }
        return qFilter;
    }

    private void initImInventory(QFilter commonFilter, Set<Long> materialIdSet, List<Long> orgs, QFilter commaterialFilter) {
        DynamicObjectCollection newImInv = this.scpVMIPanelService.newinitImInventory(commonFilter, false, materialIdSet, orgs, commaterialFilter);
        if (newImInv != null && newImInv.size() > 0) {
            this.initEntry(newImInv);
        } else {
            this.getModel().deleteEntryData("entryentity");
            this.setPanelCountNum(0, 0, 0);
        }
    }

    private void initEntry(DynamicObjectCollection pur_iminventorys) {
        this.getModel().deleteEntryData("entryentity");
        this.scpVMIPanelService.doDealMinMaxQty(pur_iminventorys, false);
        this.scpVMIPanelService.doDealQtyFiled(pur_iminventorys);
        this.scpVMIPanelService.doDealReqQty(pur_iminventorys, null, null);
        this.scpVMIPanelService.doDealOrderQty(pur_iminventorys, null, null);
        this.scpVMIPanelService.doDealInQty(pur_iminventorys, null, null);
        this.scpVMIPanelService.doDealStatus(pur_iminventorys);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DataEntityPropertyCollection properties = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity").getDynamicObjectType().getProperties();
        List props = properties.stream().map(x -> x.getName()).collect(Collectors.toList());
        DataEntityPropertyCollection properties1 = null;
        if (pur_iminventorys.size() > 0) {
            properties1 = ((DynamicObject)pur_iminventorys.get(0)).getDataEntityType().getProperties();
        }
        int outCount = 0;
        int normalCount = 0;
        int excessCount = 0;
        int index = 0;
        String status = this.getView().getPageCache().get("status");
        Boolean isAddIndex = false;
        for (int i = 0; i < pur_iminventorys.size(); ++i) {
            DynamicObject dyn = (DynamicObject)pur_iminventorys.get(i);
            if (dyn.getString("status").equals("A")) {
                ++outCount;
            }
            if (dyn.getString("status").equals("B")) {
                ++normalCount;
            }
            if (dyn.getString("status").equals("C")) {
                ++excessCount;
            }
            if (null != status && !dyn.getString("status").equals(status)) continue;
            if (null == properties1) break;
            for (IDataEntityProperty pro : properties1) {
                String name = pro.getName();
                if (!props.contains(name) && !props.contains(name.replace(".id", ""))) continue;
                if (name.contains(".id")) {
                    vs.set(name.replace(".id", "") + "_id", dyn.get(name), index);
                } else {
                    vs.set(name, dyn.get(name), index);
                }
                isAddIndex = true;
            }
            if (!isAddIndex.booleanValue()) continue;
            ++index;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.setPanelCountNum(outCount, normalCount, excessCount);
        this.scpVMIPanelService.setStatusColor(this.getView(), "status");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setPageIndex(1);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addDataBindListener(new EntryGridBindDataListener(){

            public void entryGridBindData(EntryGridBindDataEvent e) {
                ScpVMIPanelPlugin.this.scpVMIPanelService.setStatusColor(ScpVMIPanelPlugin.this.getView(), "status");
            }
        });
        Container outstockpanel = (Container)this.getControl("outstockpanel");
        Container outstocknumpanel = (Container)this.getControl("outstocknumpanel");
        Container normalscorepanel = (Container)this.getControl("normalscorepanel");
        Container normalscorepanelnum = (Container)this.getControl("normalscorepanelnum");
        Container excessscoredpanel = (Container)this.getControl("excessscoredpanel");
        Container excessscorednumpanel = (Container)this.getControl("excessscorednumpanel");
        outstockpanel.addClickListener((ClickListener)this);
        outstocknumpanel.addClickListener((ClickListener)this);
        normalscorepanel.addClickListener((ClickListener)this);
        normalscorepanelnum.addClickListener((ClickListener)this);
        excessscoredpanel.addClickListener((ClickListener)this);
        excessscorednumpanel.addClickListener((ClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent searchEnterEvent) {
                ScpVMIPanelPlugin.this.searchByMaterial(searchEnterEvent);
            }
        });
        EntryGrid billList = (EntryGrid)this.getView().getControl("entryentity");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void searchByMaterial(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        if (searchFields == null) {
            this.initData(null);
            return;
        }
        HashSet<String> materialFilters = new HashSet<String>(1);
        for (Map searchField : searchFields) {
            List fieldNames = (List)searchField.get("fieldName");
            List values = (List)searchField.get("value");
            if (CollectionUtils.isEmpty((Collection)values) || !fieldNames.contains("materialname") && !fieldNames.contains("material")) continue;
            materialFilters.addAll(values);
        }
        this.initData(materialFilters);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "outstockpanel": 
            case "outstocknumpanel": {
                this.getView().getPageCache().put("status", "A");
                this.initData(null);
                break;
            }
            case "normalscorepanel": 
            case "normalscorepanelnum": {
                this.getView().getPageCache().put("status", "B");
                this.initData(null);
                break;
            }
            case "excessscoredpanel": 
            case "excessscorednumpanel": {
                this.getView().getPageCache().put("status", "C");
                this.initData(null);
            }
        }
    }

    private void setPanelCountNum(int outCount, int normalCount, int excessCount) {
        IDataModel model = this.getView().getModel();
        model.setValue("outnum", (Object)outCount);
        model.setValue("normalscorenum", (Object)normalCount);
        model.setValue("excessnum", (Object)excessCount);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        QFilter qFilter1;
        Set<Long> billIDs;
        QFilter qFilter;
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        DynamicObject selectRow = (DynamicObject)entryentity.get(rowIndex);
        DynamicObject material = selectRow.getDynamicObject("material");
        DynamicObject recorg = selectRow.getDynamicObject("recorg");
        Long materialId = material.getLong("id");
        Long recorgID = recorg.getLong("id");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (fieldName.equals("qty")) {
            paramMap.put("material", materialId);
            paramMap.put("recorg", recorgID);
            paramMap.put("materialnumber", material.getString("number"));
            paramMap.put("materialname", material.getString("name"));
            paramMap.put("invorgname", recorg.getString("name"));
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_vmiwarehousepane", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "qty"));
        }
        if (fieldName.equals("repqty")) {
            qFilter = new QFilter("entryentity.invorg", "=", (Object)recorgID);
            qFilter.and(new QFilter("entryentity.material", "=", (Object)materialId));
            billIDs = this.scpVMIPanelService.doDealReqQty(null, qFilter, recorgID + "_" + materialId);
            qFilter1 = new QFilter("id", "in", billIDs);
            this.setFilterMap(qFilter1, paramMap);
            OpenFormUtil.openListPage((IFormView)this.getView(), (String)"scp_replenishreq", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qFilter1, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "repqty"));
        }
        if (fieldName.equals("orderqty")) {
            qFilter = new QFilter("materialentry.entryrcvorg", "=", (Object)recorgID);
            qFilter.and(new QFilter("materialentry.material", "=", (Object)materialId));
            billIDs = this.scpVMIPanelService.doDealOrderQty(null, qFilter, recorgID + "_" + materialId);
            qFilter1 = new QFilter("id", "in", billIDs);
            this.setFilterMap(qFilter1, paramMap);
            OpenFormUtil.openListPage((IFormView)this.getView(), (String)"scp_order", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qFilter1, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orderqty"));
        }
        if (fieldName.equals("inqty")) {
            qFilter = new QFilter("materialentry.entryrcvorg", "=", (Object)recorgID);
            qFilter.and(new QFilter("materialentry.material", "=", (Object)materialId));
            billIDs = this.scpVMIPanelService.doDealInQty(null, qFilter, recorgID + "_" + materialId);
            qFilter1 = new QFilter("id", "in", billIDs);
            this.setFilterMap(qFilter1, paramMap);
            OpenFormUtil.openListPage((IFormView)this.getView(), (String)"scp_saloutstock", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qFilter1, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "inqty"));
        }
    }

    public void setFilterMap(QFilter qFilter, Map paramMap) {
        Date startDate = DateUtil.string2date((String)DateUtil.getFormatStartDate((Date)DateUtil.addMonth((Date)new Date(), (int)-12)), null);
        qFilter.and("billdate", ">=", (Object)startDate);
        qFilter.and("billdate", "<=", (Object)new Date());
        paramMap.put("fromdate", startDate);
        paramMap.put("todate", new Date());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("updatainv".equals(operateKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("updatainv", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u66f4\u65b0\u5e93\u5b58\uff1f", (String)"ScpVMIPanelPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        if ("refresh".equals(operateKey)) {
            this.getPageCache().remove("status");
            this.getPageCache().put("isrefresh", "1");
            this.initData(null);
            return;
        }
        if ("exportdata".equals(operateKey)) {
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u51fa\u4e2d\u3002", (String)"SrmScoreHelperImpExpPlugin_0", (String)"scm-srm-formplugin", (Object[])new Object[0])));
                this.export();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.getView().hideLoading();
            }
        }
        if ("replenishreq".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
            long recorg = entryRowEntity.getDynamicObject("recorg").getLong("id");
            List orgs = OrgUnitServiceHelper.getFromOrgs((String)OrgTypeEnum.INVENTORY.getVal(), (Long)recorg, (String)OrgTypeEnum.PURCHASE.getVal());
            HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (boolean)false, null, (String)"scp_replenishreq", (String)"47150e89000000ac");
            Long toOrg = OrgUnitServiceHelper.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.INVENTORY.getVal(), (Long)recorg);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
            ArrayList<Long> extrendOrgs = new ArrayList<Long>(1024);
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
                for (Long orgId : orgs) {
                    if (hasPermOrgs.contains(orgId)) continue;
                    extrendOrgs.add(orgId);
                }
                if (!hasPermOrgs.contains(toOrg)) {
                    toOrg = 0L;
                }
                orgs.removeAll(extrendOrgs);
            }
            paramMap.put("orgs", orgs);
            paramMap.put("defaultorgs", toOrg);
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"scp_purorgs", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "scp_purorgs"), (ShowType)ShowType.Modal));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        Object returnData = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        if (actionId.equals("scp_purorgs") && null != returnData) {
            Object orgId = ((Map)returnData).get("orgid");
            EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            HashMap paramMap = new HashMap(1024);
            ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>(1024);
            for (int i : selectRows) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(1024);
                this.setHeadDataMap(dataMap, orgId);
                DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", i);
                this.setEntryDataMap(dataMap, entryRowEntity);
                dataList.add(dataMap);
            }
            paramMap.put("data", dataList);
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"scp_replenishreq", (ShowType)ShowType.MainNewTabPage, null, (long)0L, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "scp_replenishreq")));
        }
    }

    private void setEntryDataMap(Map<String, Object> dataMap, DynamicObject entryRowEntity) {
        dataMap.put("material", entryRowEntity.getDynamicObject("material").getPkValue());
        dataMap.put("auxpty", entryRowEntity.getDynamicObject("auxpty") == null ? "" : entryRowEntity.getDynamicObject("auxpty").getPkValue());
        if (entryRowEntity.getDynamicObject("unit") == null) {
            dataMap.put("unit", 0);
        } else {
            dataMap.put("unit", entryRowEntity.getDynamicObject("unit").getPkValue());
        }
        dataMap.put("qty", BigDecimal.ZERO);
        dataMap.put("invorg", entryRowEntity.getDynamicObject("recorg").getPkValue());
        DynamicObject supplier = entryRowEntity.getDynamicObject("supplier");
        Object bizPartnerId = null;
        DynamicObject bizpartner = entryRowEntity.getDynamicObject("bizpartner");
        if (bizpartner != null) {
            bizPartnerId = bizpartner.getPkValue();
        }
        if (supplier != null) {
            dataMap.put("supplier", supplier.getPkValue());
            if (bizPartnerId == null) {
                DynamicObject cacheSupplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier");
                bizPartnerId = cacheSupplier.getString("bizpartner.id");
            }
        }
        dataMap.put("bizpartner", bizPartnerId);
    }

    private void export() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"ScpVMIPanelPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            excelDataEntity.setFileName(ResManager.loadKDString((String)"VIM\u770b\u677f.xlsx", (String)"ScpVMIPanelPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            this.setColumn(excelDataEntity);
            ScpVMIPanelPlugin.setExcelHeader(excelDataEntity);
            ScpVMIPanelPlugin.setEexclBody(excelDataEntity, model, selectRows);
            excelDataEntity.setExcelHeaderStyle(1, 4);
            excelDataEntity.setDataFormatForNumberic(0, 1, 1, selectRows.length);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            log.warn((Throwable)e);
            view.showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SrmScoreHelperImpExp_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        }
    }

    private static void setEexclBody(ExcelDataEntity excelDataEntity, IDataModel model, int[] selectRows) throws IOException {
        List columnKeyList = excelDataEntity.getColumnKeyList();
        int index = 0;
        DynamicObjectCollection bd_auxpropertys = QueryServiceHelper.query((String)"bd_auxproperty", (String)"valuetype,flexfield,valuesource", null);
        HashMap<String, String> auxpropertysMap = new HashMap<String, String>(1024);
        for (DynamicObject dynamicObject : bd_auxpropertys) {
            if ("3".equals(dynamicObject.getString("valuetype"))) continue;
            auxpropertysMap.put(dynamicObject.getString("flexfield"), dynamicObject.getString("valuesource"));
        }
        HashMap auxpropertyMap = new HashMap(1024);
        for (int i : selectRows) {
            DynamicObject dyObj = model.getEntryRowEntity("entryentity", i);
            if (null == dyObj.getDynamicObject("auxpty")) continue;
            String valueStr = dyObj.getDynamicObject("auxpty").get("value").toString();
            Map values = (Map)SerializationUtils.fromJsonString((String)valueStr, Map.class);
            for (Map.Entry valueMap : values.entrySet()) {
                Set<Long> valueSet;
                if (!auxpropertysMap.containsKey(valueMap.getKey())) continue;
                if (!auxpropertyMap.containsKey(valueMap.getKey())) {
                    valueSet = new HashSet<Long>(1024);
                    valueSet.add(Long.parseLong(valueMap.getValue().toString()));
                    auxpropertyMap.put(valueMap.getKey(), valueSet);
                    continue;
                }
                valueSet = (Set)auxpropertyMap.get(valueMap.getKey());
                valueSet.add(Long.parseLong(valueMap.getValue().toString()));
                auxpropertyMap.put(valueMap.getKey(), valueSet);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1024);
        for (Map.Entry map : auxpropertyMap.entrySet()) {
            String entityName = (String)map.getKey();
            if (!auxpropertysMap.containsKey(entityName)) continue;
            QFilter qFilter = new QFilter("id", "in", map.getValue());
            String selector = "";
            selector = ((String)auxpropertysMap.get(entityName)).equals("bos_assistantdata_detail") ? "id,number,name,group.name" : "id,number,name";
            DynamicObjectCollection query = QueryServiceHelper.query((String)((String)auxpropertysMap.get(entityName)), (String)selector, (QFilter[])qFilter.toArray());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)auxpropertysMap.get(entityName)));
            for (DynamicObject dyn : query) {
                if (((String)auxpropertysMap.get(entityName)).equals("bos_assistantdata_detail")) {
                    hashMap.put(dyn.getString("id"), dyn.getString("group.name") + ":" + dyn.getString("name"));
                    continue;
                }
                hashMap.put(dyn.getString("id"), (String)dataEntityType.getDisplayName().get((Object)"zh_CN") + ":" + dyn.getString("name"));
            }
        }
        for (Object i : (Object)selectRows) {
            List<String> rowData = ScpVMIPanelPlugin.getRowDataByIndex(model, columnKeyList, (int)i, hashMap, auxpropertysMap);
            excelDataEntity.createRow(0, index + 1);
            excelDataEntity.setRowValue(0, rowData, index + 1);
            ++index;
        }
    }

    private static List<String> getRowDataByIndex(IDataModel model, List<String> columnKeyList, int i, Map<String, String> ffid_nameMap, Map<String, String> ffid_baseMap) {
        ArrayList<String> rowData = new ArrayList<String>(columnKeyList.size());
        DynamicObject dyObj = model.getEntryRowEntity("entryentity", i);
        for (String column : columnKeyList) {
            Object val = "";
            if (column.equals("materialname")) {
                if (null != dyObj.get("material")) {
                    val = ((DynamicObject)dyObj.get("material")).get("name");
                }
                rowData.add(String.valueOf(val));
                continue;
            }
            if (column.equals("model")) {
                if (null != dyObj.get("material")) {
                    val = ((DynamicObject)dyObj.get("material")).get("modelnum");
                }
                rowData.add(String.valueOf(val));
                continue;
            }
            if (column.equals("auxpty")) {
                val = ScpVMIPanelPlugin.setEexclAuxpty(dyObj, ffid_baseMap, ffid_nameMap);
                rowData.add(String.valueOf(val));
                continue;
            }
            if (column.equals("updatetime")) {
                if (null != dyObj.get("updatetime")) {
                    Date updatetime = dyObj.getDate("updatetime");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    val = simpleDateFormat.format(updatetime);
                }
                rowData.add(val.toString());
                continue;
            }
            Object columnVal = dyObj.get(column);
            if (columnVal == null) {
                val = "";
            } else if (columnVal instanceof DynamicObject) {
                val = ((DynamicObject)columnVal).get("name");
                if ("material".equals(column)) {
                    val = ((DynamicObject)columnVal).get("number");
                }
            } else {
                val = columnVal instanceof BigDecimal ? (((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : columnVal) : columnVal;
            }
            if (val instanceof BigDecimal) {
                int scale = 2;
                if (null != dyObj.getDynamicObject("unit")) {
                    scale = dyObj.getDynamicObject("unit").getInt("precision");
                }
                val = ((BigDecimal)val).setScale(scale);
            }
            if ("status".equals(column)) {
                val = val.equals("A") ? ResManager.loadKDString((String)"\u7f3a\u8d27", (String)"ScpVMIPanelPlugin_27", (String)"scm-scp-formplugin", (Object[])new Object[0]) : (val.equals("B") ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ScpVMIPanelPlugin_28", (String)"scm-scp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d85\u91cf", (String)"ScpVMIPanelPlugin_29", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            }
            rowData.add(String.valueOf(val));
        }
        return rowData;
    }

    private static Object setEexclAuxpty(DynamicObject dyObj, Map<String, String> ffid_baseMap, Map<String, String> ffid_nameMap) {
        StringBuilder strBuffer = new StringBuilder();
        if (null != dyObj.get("auxpty")) {
            String valueStr = dyObj.getDynamicObject("auxpty").get("value").toString();
            Map values = (Map)SerializationUtils.fromJsonString((String)valueStr, Map.class);
            for (Map.Entry map : values.entrySet()) {
                if (ffid_baseMap.containsKey(map.getKey())) {
                    strBuffer.append(ffid_nameMap.get(String.valueOf(map.getValue())));
                    continue;
                }
                strBuffer.append(map.getValue());
            }
        }
        return strBuffer.toString();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("replenishreq".equals(operateKey)) {
            this.validateForReplenish(args);
        }
    }

    private void validateForReplenish(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        HashSet<Long> idSet = new HashSet<Long>();
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRow);
            long materialId = entryRowEntity.getDynamicObject("material").getLong("id");
            idSet.add(materialId);
        }
        QFilter filter = new QFilter("id", "in", idSet);
        StringBuilder strBuffer = new StringBuilder();
        DynamicObjectCollection bd_materials = QueryServiceHelper.query((String)"bd_material", (String)"id,name,enable", (QFilter[])filter.toArray());
        for (DynamicObject bd_material : bd_materials) {
            if (!"0".equals(bd_material.get("enable"))) continue;
            strBuffer.append(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u8865\u8d27\u3002", (String)"ScpVMIPanelPlugin_24", (String)"scm-scp-formplugin", (Object[])new Object[0]), bd_material.get("name"))).append('\n');
        }
        if (0 != strBuffer.length()) {
            this.getView().showTipNotification(strBuffer.toString());
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"updatainv", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            List curSupplierId = BizPartnerUtil.getSupplierByUserOfBizPartner();
            ScpIminventorySyncTaskUtil taskUtil = new ScpIminventorySyncTaskUtil();
            StringBuilder strBuffer = new StringBuilder();
            for (Long supId : curSupplierId) {
                Map stringStringMap = taskUtil.doTaskStart(supId.longValue());
                if (!((String)stringStringMap.get("code")).equals("500")) continue;
                String msg = (String)stringStringMap.get("error");
                strBuffer.append(msg);
            }
            if (strBuffer.length() > 0) {
                this.getView().showErrorNotification(strBuffer.toString());
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barrefresh": {
                this.getPageCache().remove("status");
                this.initData(null);
            }
        }
    }

    public void setColumn(ExcelDataEntity column) {
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("seq");
        columnList.add("material");
        columnList.add("materialname");
        columnList.add("materialgroup");
        columnList.add("model");
        columnList.add("auxpty");
        columnList.add("recorg");
        columnList.add("qty");
        columnList.add("status");
        columnList.add("minqty");
        columnList.add("maxqty");
        columnList.add("repqty");
        columnList.add("orderqty");
        columnList.add("inqty");
        columnList.add("unit");
        columnList.add("updatetime");
        column.setColumnKeyList(columnList);
    }

    private static void setExcelHeader(ExcelDataEntity excelDataEntity) throws IOException {
        ArrayList<String> columnTitle = new ArrayList<String>();
        columnTitle.add(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ScpVMIPanelPlugin_4", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"ScpVMIPanelPlugin_5", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"ScpVMIPanelPlugin_6", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"ScpVMIPanelPlugin_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ScpVMIPanelPlugin_8", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"ScpVMIPanelPlugin_9", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"ScpVMIPanelPlugin_10", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u6570\u91cf", (String)"ScpVMIPanelPlugin_11", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u72b6\u6001", (String)"ScpVMIPanelPlugin_12", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u6700\u5c0f\u5e93\u5b58", (String)"ScpVMIPanelPlugin_14", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u6700\u5927\u5e93\u5b58", (String)"ScpVMIPanelPlugin_15", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7533\u8bf7\u8865\u8d27\u6570\u91cf", (String)"ScpVMIPanelPlugin_16", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u8ba2\u5355\u5f85\u53d1\u6570\u91cf", (String)"ScpVMIPanelPlugin_17", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u53d1\u751f\u5728\u9014\u6570\u91cf", (String)"ScpVMIPanelPlugin_18", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5e93\u5b58\u5355\u4f4d", (String)"ScpVMIPanelPlugin_19", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u66f4\u65b0\u65f6\u95f4", (String)"ScpVMIPanelPlugin_20", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        excelDataEntity.setExcelHeader(columnTitle);
    }

    public void setHeadDataMap(Map<String, Object> dataMap, Object orgId) {
        dataMap.put("org", orgId);
    }
}

