/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.scp.business.ScpVMIPanelServiceHelper;

public class ScpVMIPanelService {
    public QFilter getInitCommonQfilter() {
        return ScpVMIPanelServiceHelper.getInitCommonQfilter();
    }

    public void setStatusColor(IFormView view, String keyName) {
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        IDataModel model = view.getModel();
        int entryCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryCount; ++i) {
            DynamicObject rowEntiry = model.getEntryRowEntity("entryentity", i);
            String nodeStatus = rowEntiry.getString("status");
            String foreColor = null;
            if (null != nodeStatus && nodeStatus.equals("A")) {
                foreColor = "#FB2324";
            }
            if (null != nodeStatus && nodeStatus.equals("B")) {
                foreColor = "#21A854";
            }
            if (null != nodeStatus && nodeStatus.equals("C")) {
                foreColor = "#FF991C";
            }
            CellStyle cs = new CellStyle();
            if (foreColor != null) {
                cs.setForeColor(foreColor);
            }
            cs.setRow(i);
            cs.setFieldKey(keyName);
            cellStyles.add(cs);
        }
        if (cellStyles != null && cellStyles.size() > 0) {
            grid.setCellStyle(cellStyles);
        }
    }

    public DynamicObjectCollection initImInventory(QFilter qFilter, Boolean iswarehouse) {
        return ScpVMIPanelServiceHelper.initImInventory((QFilter)qFilter, (Boolean)iswarehouse);
    }

    public DynamicObjectCollection newinitImInventory(QFilter qFilter, boolean iswarehouse, Set<Long> materialIdSet, List<Long> orgs, QFilter commaterialQfilter) {
        return ScpVMIPanelServiceHelper.newinitImInventory((QFilter)qFilter, (Boolean)iswarehouse, materialIdSet, orgs, (QFilter)commaterialQfilter);
    }

    public List<DynamicObject> newInitImInventory(QFilter qFilter, Boolean iswarehouse, Set<Long> materialIdSet, List<Long> orgs, QFilter conmaterialQfilter) {
        DynamicObjectCollection dynamicObjects = this.newinitImInventory(qFilter, iswarehouse, materialIdSet, orgs, conmaterialQfilter);
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)dynamicObjects);
    }

    public void doDealStatus(DynamicObjectCollection pur_iminventorys) {
        ScpVMIPanelServiceHelper.doDealStatus((DynamicObjectCollection)pur_iminventorys);
    }

    public void doDealMinMaxQty(DynamicObjectCollection pur_iminventorys, boolean iswarehouse) {
        ScpVMIPanelServiceHelper.doDealMinMaxQty((DynamicObjectCollection)pur_iminventorys, (boolean)iswarehouse);
    }

    public Set<Long> doDealInQty(DynamicObjectCollection pur_iminventorys, QFilter bizQFilter, String org_material) {
        return ScpVMIPanelServiceHelper.doDealInQty((DynamicObjectCollection)pur_iminventorys, (QFilter)bizQFilter, (String)org_material);
    }

    public Set<Long> doDealReqQty(DynamicObjectCollection pur_iminventorys, QFilter bizQFilter, String org_material) {
        return ScpVMIPanelServiceHelper.doDealReqQty((DynamicObjectCollection)pur_iminventorys, (QFilter)bizQFilter, (String)org_material);
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null) {
                    int numerator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        int unitPrecision = desUnit.getInt("precision");
                        RoundingMode unitPrecisionType = RoundingMode.HALF_UP;
                        desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                    }
                }
            }
            return desQty;
        }
        return BigDecimal.ZERO;
    }

    public Set<Long> doDealOrderQty(DynamicObjectCollection pur_iminventorys, QFilter bizQFilter, String org_material) {
        return ScpVMIPanelServiceHelper.doDealOrderQty((DynamicObjectCollection)pur_iminventorys, (QFilter)bizQFilter, (String)org_material);
    }

    public void doDealQtyFiled(DynamicObjectCollection pur_iminventorys) {
        ScpVMIPanelServiceHelper.doDealQtyFiled((DynamicObjectCollection)pur_iminventorys);
    }
}

