/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.edit;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.scp.business.ScpModuleConsumeHelper;
import kd.scm.scp.common.util.ScpBillUtil;

public final class ScpModuleConsumeEditPlugin
extends AbstractBillPlugIn {
    private static final String[] setColorPro = new String[]{"subcurrconbaseqty", "subcurrconqty"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String consumetype = dataEntity.getString("consumetype");
        if ("2".equals(consumetype)) {
            DynamicObjectCollection cols = dataEntity.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                DynamicObjectCollection subcols = col.getDynamicObjectCollection("subentryentity");
                DynamicObjectType colsDynamicObjectType = subcols.getDynamicObjectType();
                EntryGrid grid = (EntryGrid)this.getView().getControl("subentryentity");
                DynamicProperty decimalProp = null;
                BigDecimal entryValue = null;
                for (int i = 0; i < subcols.size(); ++i) {
                    for (String column : setColorPro) {
                        decimalProp = colsDynamicObjectType.getProperty(column);
                        if (!(decimalProp instanceof DecimalProp) || !Objects.nonNull(entryValue = ((DynamicObject)subcols.get(i)).getBigDecimal(column))) continue;
                        model.setValue(column, (Object)entryValue.abs(), i);
                    }
                }
                grid.summary();
                model.setDataChanged(false);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_revoke": {
                String billstatus = this.getModel().getDataEntity(true).getString("billstatus");
                if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                    this.getView().invokeOperation("unaudit");
                    break;
                }
                this.getView().invokeOperation("unsubmit");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String consumetype = dataEntity.getString("consumetype");
        switch (property.getName()) {
            case "subcurrconqty": {
                for (ChangeData changeData : e.getChangeSet()) {
                    int rowIndex = changeData.getRowIndex();
                    BigDecimal subcurrconqty = (BigDecimal)changeData.getNewValue();
                    Map consumeSubQty = ScpModuleConsumeHelper.assambleConsumeSubQty((DynamicObjectCollection)dataEntity.getDynamicObjectCollection("materialentry"));
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
                    if ("2".equals(consumetype)) {
                        BigDecimal consumeQty;
                        String subsrcbillentryid = entryRowEntity.getString("subsrcbillentryid");
                        BigDecimal bigDecimal = consumeQty = consumeSubQty.get(subsrcbillentryid) == null ? BigDecimal.ZERO : (BigDecimal)consumeSubQty.get(subsrcbillentryid);
                        if (subcurrconqty.compareTo(consumeQty) > 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u77ed\u8017\u9000\u56de\u672c\u6b21\u6d88\u8017\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5df2\u6d88\u8017\u6570\u91cf\u3002", (String)"ScpModuleConsumeEditPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                            this.getModel().setValue("subcurrconqty", changeData.getOldValue(), rowIndex);
                            continue;
                        }
                    }
                    ScpBillUtil.updateEntryBasicQtyByLineIndex((String)property.getName(), (String)"subcurrconbaseqty", (DynamicObject)entryRowEntity);
                }
                this.getView().updateView("subentryentity");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (operateKey) {
            case "submit": {
                String consumetype = dataEntity.getString("consumetype");
                if (!"0".equals(consumetype)) {
                    return;
                }
                DynamicObjectCollection materialentrys = dataEntity.getDynamicObjectCollection("materialentry");
                HashMap overQtyMap = new HashMap(8);
                HashMap currQtyMap = new HashMap(8);
                ScpModuleConsumeHelper.assambleSubSumConQty(overQtyMap, currQtyMap, (DynamicObjectCollection)materialentrys);
                StringBuilder sb = new StringBuilder();
                for (DynamicObject materialentry : materialentrys) {
                    int seq = materialentry.getInt("seq");
                    String materialName = "";
                    String materialNumber = "";
                    DynamicObject material = materialentry.getDynamicObject("material");
                    if (material != null) {
                        materialNumber = material.getString("number");
                        materialName = material.getString("name");
                    }
                    DynamicObjectCollection subentryentitys = materialentry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subentryentity : subentryentitys) {
                        String submaterialName = "";
                        String submaterialNumber = "";
                        DynamicObject submaterial = subentryentity.getDynamicObject("submaterial");
                        if (submaterial != null) {
                            submaterialNumber = submaterial.getString("number");
                            submaterialName = submaterial.getString("name");
                        }
                        String subsrcbillentryid = subentryentity.getString("subsrcbillentryid");
                        String isbackflush = subentryentity.getString("isbackflush");
                        String overissuecontrl = subentryentity.getString("overissuecontrl");
                        if ("B".equals(isbackflush) || !"B".equals(overissuecontrl)) continue;
                        BigDecimal overQty = (BigDecimal)overQtyMap.get(subsrcbillentryid);
                        int subseq = subentryentity.getInt("seq");
                        if (overQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        String loadKDString = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7269\u6599:{1} {2}\u7684\u7b2c{3}\u884c\u7ec4\u4ef6:{4} {5}\u5b58\u5728\u8d85\u8017\u6570\u91cf:{6}\u3002", (String)"ScpModuleConsumeEditPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]), seq, materialNumber, materialName, subseq, submaterialNumber, submaterialName, overQty);
                        sb.append(loadKDString).append(System.lineSeparator());
                    }
                }
                if (sb == null || sb.length() <= 0) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u8017\u7684\u7ec4\u4ef6\uff0c\u662f\u5426\u9700\u8981\u751f\u6210\u8d85\u8017\u5355\uff1f", (String)"ScpModuleConsumeEditPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("overcreatenewbill"));
                args.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("overcreatenewbill".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection materialentrys = dataEntity.getDynamicObjectCollection("materialentry");
            HashMap<String, BigDecimal> overQtyToCreateToMap = new HashMap<String, BigDecimal>(8);
            HashMap overQtyMap = new HashMap(8);
            HashMap currQtyMap = new HashMap(8);
            ScpModuleConsumeHelper.assambleSubSumConQty(overQtyMap, currQtyMap, (DynamicObjectCollection)materialentrys);
            for (DynamicObject materialentry : materialentrys) {
                DynamicObjectCollection subentryentitys = materialentry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subentryentity : subentryentitys) {
                    String subsrcbillentryid = subentryentity.getString("subsrcbillentryid");
                    String isbackflush = subentryentity.getString("isbackflush");
                    String overissuecontrl = subentryentity.getString("overissuecontrl");
                    if ("B".equals(isbackflush) || !"B".equals(overissuecontrl)) continue;
                    BigDecimal currQty = (BigDecimal)currQtyMap.get(subsrcbillentryid);
                    BigDecimal overQty = (BigDecimal)overQtyMap.get(subsrcbillentryid);
                    if (overQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    subentryentity.set("subcurrconqty", (Object)currQty);
                    subentryentity.set("subcurrconbaseqty", (Object)currQty);
                    ScpBillUtil.updateEntryBasicQtyByLineIndex((String)"subcurrconqty", (String)"subcurrconbaseqty", (DynamicObject)subentryentity);
                    overQtyToCreateToMap.put(subsrcbillentryid, overQty);
                }
            }
            this.getView().invokeOperation("submit");
            if (!CollectionUtils.isEmpty(overQtyToCreateToMap)) {
                HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(8);
                HashMap pushOrderData = new HashMap(8);
                HashMap paramMap = new HashMap(8);
                ScpModuleConsumeHelper.buildParam((DynamicObject[])new DynamicObject[]{dataEntity}, paramMap, pushOrderData, overQtyToCreateToMap);
                toStockParamMap.put("sourceEntity", "scp_order");
                toStockParamMap.put("targetEntity", "scp_moduleconsume");
                toStockParamMap.put("paramMap", paramMap);
                toStockParamMap.put("pushOrderData", pushOrderData);
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"scp", (String)"IScpSalOutAuditAutoModuleConsumeService", (String)"autoCreateModuleConsumeService", (Object[])new Object[]{toStockParamMap});
            }
        }
    }
}

