/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MaterialUtil;

public final class ScpModuleReceiptEditPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.setInvInfoS(dataEntity);
    }

    public void afterLoadData(EventObject e) {
        super.afterBindData(e);
    }

    private void setInvInfoS(DynamicObject dataEntity) {
        DynamicObject material;
        DynamicObjectCollection cols = dataEntity.getDynamicObjectCollection("materialentry");
        for (int i = 0; i < cols.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"suplot"});
        }
        String receipttype = dataEntity.getString("receipttype");
        if (!"0".equals(receipttype)) {
            return;
        }
        String srctype = dataEntity.getString("srctype");
        if (!"1".equals(srctype)) {
            return;
        }
        DynamicObject org = dataEntity.getDynamicObject("org");
        HashSet<Long> materialSet = new HashSet<Long>(8);
        for (DynamicObject entry : cols) {
            material = entry.getDynamicObject("material");
            if (material == null) continue;
            materialSet.add((Long)material.getPkValue());
        }
        Map materialInvInfosByBill = MaterialUtil.getMaterialInventoryinfo(materialSet, (long)((Long)org.getPkValue()), (String)"materialid,id,enablelot,enableshelflifemgr");
        for (int i = 0; i < cols.size(); ++i) {
            Object materialId;
            DynamicObject materialInvInfo;
            material = ((DynamicObject)cols.get(i)).getDynamicObject("material");
            if (material == null || (materialInvInfo = (DynamicObject)materialInvInfosByBill.get(materialId = material.getPkValue())) == null) continue;
            Boolean enablelot = materialInvInfo.getBoolean("enablelot");
            this.getView().setEnable(enablelot, i, new String[]{"suplot"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_revoke": {
                String billstatus = this.getModel().getDataEntity(true).getString("billstatus");
                if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                    this.getView().invokeOperation("unaudit");
                    break;
                }
                this.getView().invokeOperation("unsubmit");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String receipttype = dataEntity.getString("receipttype");
        switch (property.getName()) {
            case "receiptqty": {
                for (ChangeData changeData : e.getChangeSet()) {
                    BigDecimal receiptqty;
                    BigDecimal deliveryqty;
                    int rowIndex = changeData.getRowIndex();
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("materialentry", rowIndex);
                    if ("0".equals(receipttype) && (deliveryqty = entryRowEntity.getBigDecimal("deliveryqty")).compareTo(receiptqty = (BigDecimal)changeData.getNewValue()) < 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u53d1\u8d27\u901a\u77e5\u786e\u8ba4\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u53d1\u8d27\u6570\u91cf\u3002", (String)"ScpModuleReceiptEditPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("receiptqty", changeData.getOldValue(), rowIndex);
                        continue;
                    }
                    ScpModuleReceiptEditPlugin.updateEntryBasicQtyByLineIndex(property.getName(), "receiptbasicqty", entryRowEntity);
                    if (!"0".equals(receipttype)) continue;
                    this.updateEntryDiffQtyByLineIndex(entryRowEntity);
                }
                this.getView().updateView("materialentry");
                break;
            }
            case "deliveryqty": {
                for (ChangeData changeData : e.getChangeSet()) {
                    int rowIndex = changeData.getRowIndex();
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("materialentry", rowIndex);
                    ScpModuleReceiptEditPlugin.updateEntryBasicQtyByLineIndex(property.getName(), "deliverybasicqty", entryRowEntity);
                }
                break;
            }
        }
    }

    private void updateEntryDiffQtyByLineIndex(DynamicObject entryRowEntity) {
        if (entryRowEntity == null) {
            return;
        }
        BigDecimal receiptqty = entryRowEntity.getBigDecimal("receiptqty");
        BigDecimal deliveryqty = entryRowEntity.getBigDecimal("deliveryqty");
        BigDecimal receiptbasicqty = entryRowEntity.getBigDecimal("receiptbasicqty");
        BigDecimal deliverybasicqty = entryRowEntity.getBigDecimal("deliverybasicqty");
        BigDecimal diffqty = deliveryqty.subtract(receiptqty);
        entryRowEntity.set("diffqty", (Object)diffqty);
        BigDecimal diffbasicqty = deliverybasicqty.subtract(receiptbasicqty);
        entryRowEntity.set("diffbasicqty", (Object)diffbasicqty);
    }

    public static void updateEntryBasicQtyByLineIndex(String propertyName, String basePropertyName, DynamicObject entryRowEntity) {
        if (entryRowEntity == null) {
            return;
        }
        BigDecimal newQty = entryRowEntity.getBigDecimal(propertyName);
        DynamicObject materialObj = entryRowEntity.getDynamicObject("material");
        DynamicObject unitObj = entryRowEntity.getDynamicObject("unit");
        DynamicObject basicUnitObj = entryRowEntity.getDynamicObject("basicunit");
        if (materialObj == null) {
            entryRowEntity.set(basePropertyName, (Object)newQty);
        }
        if (null != materialObj && null != unitObj && null != basicUnitObj) {
            BigDecimal basicQty = null;
            basicQty = unitObj.getPkValue().equals(basicUnitObj.getPkValue()) ? newQty : CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)newQty, (DynamicObject)basicUnitObj);
            basicQty = null == basicQty ? BigDecimal.ZERO : basicQty;
            entryRowEntity.set(basePropertyName, (Object)basicQty);
        }
    }
}

