/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.QualityRectificEnum;
import kd.scm.common.enums.QualityRectificStatusEnum;
import kd.scm.scp.common.enums.SourceEnum;
import kd.scm.scp.common.helper.ScpCoreListFilterHelper;
import kd.scm.scp.formplugin.ScpCoreBillEditPlugin;

public final class ScpQualityRectificEdit
extends ScpCoreBillEditPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            boolean isExists;
            Object pkId = ((BillShowParameter)formShowParameter).getPkId();
            List qFilters = ScpCoreListFilterHelper.setFilter(new ArrayList(8));
            if (pkId != null) {
                qFilters.add(new QFilter("id", "=", (Object)Long.parseLong(pkId.toString())));
            }
            if (!(isExists = QueryServiceHelper.exists((String)"scp_qualityrectific", (QFilter[])qFilters.toArray(new QFilter[0])))) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u4e0d\u6ee1\u8db3\u5904\u7406\u6761\u4ef6\u3002", (String)"ScpQualityRectificEdit_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "feedback": {
                    this.doFeedEnableBtn(true);
                    this.setEntryFieldsStatus(true);
                    break;
                }
                case "comfirmfeedback": {
                    this.getPageCache().remove("focus");
                    this.doFeedEnableBtn(false);
                    this.setEntryFieldsStatus(false);
                    if (null != customParams.get("feedback")) {
                        this.getView().getFormShowParameter().getCustomParams().remove("feedback");
                        this.getView().invokeOperation("close");
                        break;
                    }
                    this.getView().updateView("icastatus");
                    this.getView().updateView("pcastatus");
                    this.getView().updateView("verifystatus");
                    break;
                }
                case "returnfeedback": {
                    this.getPageCache().remove("focus");
                    this.doFeedEnableBtn(false);
                    this.setEntryFieldsStatus(false);
                    if (null != customParams.get("feedback")) {
                        this.getView().getFormShowParameter().getCustomParams().remove("feedback");
                        this.getView().invokeOperation("close");
                        break;
                    }
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String icastatus = dataEntity.getString("icastatus");
        String pcastatus = dataEntity.getString("pcastatus");
        String verifystatus = dataEntity.getString("verifystatus");
        String cancelstatus = dataEntity.getString("cancelstatus");
        if ("Z".equalsIgnoreCase(cancelstatus)) {
            return QualityRectificStatusEnum.FINISH.getValue();
        }
        if (QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(icastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(pcastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.START.getValue();
        }
        if (!QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(pcastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.ICA.getValue();
        }
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.PCA.getValue();
        }
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.VILIFY.getValue();
        }
        if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
            return QualityRectificStatusEnum.FINISH.getValue();
        }
        return "";
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("feedback")) {
            this.setEntryFieldsStatus(true);
            this.doFeedEnableBtn(true);
        } else {
            this.setEntryFieldsStatus(false);
            this.doFeedEnableBtn(false);
        }
    }

    public void beforeDeleteEntry(BeforeDeleteEntryEventArgs e) {
        super.beforeDeleteEntry(e);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name;
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        switch (name = entryProp.getName()) {
            case "rectmentry": {
                this.isPurCreateEntry(e, "rectmentry", "tmsource");
                break;
            }
            case "recteamentry": {
                this.isPurCreateEntry(e, "recteamentry", "teamsource");
                break;
            }
            case "reccauseentry": {
                this.isPurCreateEntry(e, "reccauseentry", "casource");
                break;
            }
            case "recfmentry": {
                this.isPurCreateEntry(e, "recfmentry", "fmsource");
                break;
            }
            case "receventry": {
                this.isPurCreateEntry(e, "receventry", "evsource");
                break;
            }
            case "recpmentry": {
                this.isPurCreateEntry(e, "recpmentry", "pmsource");
                break;
            }
        }
    }

    private void isPurCreateEntry(BeforeDeleteRowEventArgs e, String entrykey, String fieldKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection recteamentrys = dataEntity.getDynamicObjectCollection(entrykey);
        int[] varMap = e.getRowIndexs();
        StringBuilder sb = new StringBuilder();
        for (int i : varMap) {
            DynamicObject recteamentry = (DynamicObject)recteamentrys.get(i);
            String teamsource = recteamentry.getString(fieldKey);
            if (!SourceEnum.PUR.getValue().equals(teamsource)) continue;
            sb.append(i + 1).append(",");
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u521b\u5efa\u6765\u6e90\u4e3a\u4f9b\u5e94\u5546\u7684\u6210\u5458\u3002", (String)"ScpQualityRectificEdit_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void doFeedEnableBtn(Boolean status) {
        this.getView().setVisible(status, new String[]{"sumbit", "bar_returnfeedback"});
        this.getView().setVisible(Boolean.valueOf(status == false), new String[]{"feedback", "bar_print", "bar_more", "bar_refresh", "bar_close"});
    }

    private void setEntryFieldsStatus(boolean status) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"buildateam", "tabpageap3", "tabpageap4", "tabpageap5", "tabpageap6", "tabpageap7"});
        Container baseinfo = (Container)this.getView().getControl("baseinfo");
        baseinfo.setCollapse(false);
        this.setEnableBySource(dataEntity);
        String icastatus = dataEntity.getString("icastatus");
        String pcastatus = dataEntity.getString("pcastatus");
        String verifystatus = dataEntity.getString("verifystatus");
        if (status && ScpQualityRectificEdit.isPendingConfirmation(icastatus).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(status), new String[]{"buildateam", "tabpageap3", "tabpageap4", "tabpageap5", "tabpageap6"});
            this.setContainerCollapse(status, "tabpageap3");
            this.createNewEntryDataByICA();
            this.focusOnField("rectmentry", "describe");
            return;
        }
        if (status && ScpQualityRectificEdit.isPendingConfirmation(pcastatus).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(status), new String[]{"tabpageap4", "tabpageap5"});
            this.setContainerCollapse(status, "tabpageap4");
            this.createNewEntryDataByPCA();
            this.focusOnField("reccauseentry", "suspiciousreason");
            return;
        }
        if (status && ScpQualityRectificEdit.isPendingConfirmation(verifystatus).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(status), new String[]{"tabpageap6", "tabpageap7"});
            this.setContainerCollapse(status, "tabpageap6");
            this.createNewEntryDataByVerify();
            this.focusOnField("receventry", "isthrough");
            return;
        }
    }

    private void focusOnField(String entryName, String fieldName) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryName);
        grid.focusCell(0, fieldName);
    }

    private static Boolean isPendingConfirmation(String status) {
        return QualityRectificEnum.PENDINGFEEDBACK.getValue().equals(status) || QualityRectificEnum.PENDINGREFEEDBACK.getValue().equals(status);
    }

    private void setEnableBySource(DynamicObject dataEntity) {
        this.setEnableBySource(dataEntity, "recteamentry", "teamsource");
        this.setEnableBySource(dataEntity, "rectmentry", "tmsource");
        this.setEnableBySource(dataEntity, "reccauseentry", "casource");
        this.setEnableBySource(dataEntity, "recfmentry", "fmsource");
        this.setEnableBySource(dataEntity, "receventry", "evsource");
        this.setEnableBySource(dataEntity, "recpmentry", "pmsource");
    }

    private void setEnableBySource(DynamicObject dataEntity, String entry, String source) {
        for (DynamicObject dy : dataEntity.getDynamicObjectCollection(entry)) {
            Integer seq = dy.getInt("seq");
            if (!SourceEnum.PUR.getValue().equals(dy.getString(source))) continue;
            this.getView().setEnable(Boolean.valueOf(false), seq.intValue(), new String[]{entry});
        }
    }

    private void createNewEntryDataByICA() {
        this.createNewEntryData("recteamentry");
        this.createNewEntryData("rectmentry");
        this.createNewEntryData("reccauseentry");
        this.createNewEntryData("recfmentry");
    }

    private void createNewEntryDataByPCA() {
        this.createNewEntryData("reccauseentry");
        this.createNewEntryData("recfmentry");
    }

    private void createNewEntryDataByVerify() {
        this.createNewEntryData("receventry");
        this.createNewEntryData("recpmentry");
    }

    private void createNewEntryData(String entityEntry) {
        DynamicObject dy = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entityEntryDyc = dy.getDynamicObjectCollection(entityEntry);
        if (CollectionUtils.isEmpty((Collection)entityEntryDyc)) {
            this.getView().getModel().createNewEntryRow(entityEntry);
        }
    }

    private void setContainerCollapse(boolean status, String activeTabField) {
        if (!status) {
            return;
        }
        Tab statusTab = (Tab)this.getView().getControl("tabap1");
        statusTab.activeTab(activeTabField);
        Container baseinfo = (Container)this.getView().getControl("baseinfo");
        baseinfo.setCollapse(true);
        Container problemhandling = (Container)this.getView().getControl("problemhandling");
        problemhandling.setCollapse(false);
    }
}

