/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.scp.common.util.ScpBillOfBizPersonFilter;

public class ScpMainPageMobile
extends AbstractFormPlugin {
    private static final String SUPSCOPE_ALLSUPPLIER = "1";
    private static final String SUPSCOPE_DESIGNATE = "2";
    private static final String BIZSTATUS_QUOTING = "A";
    private static final String BIZSTATUS_PENDCOMP = "B";
    private static final String BIZSTATUS_TOEXE = "C";
    private static final String CANSHOW_YES = "1";
    private static final String SUPPLIER_PROSTATUS = "supplierprostatus";
    private static final String SUPPLIER_PROSTATUS_PENDQUOTED = "A";
    private static final String SUPPLIERSTATUS_PENDQUOTE = "Y";
    private final QFilter bizPartnerQFilter = BizPartnerUtil.assembleQFilterBizPartner();
    private final List<QFilter> orderFilter = ScpBillOfBizPersonFilter.orderFilter();
    private final List<QFilter> salOutStockFilter = ScpBillOfBizPersonFilter.salOutStockFilter();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                String entityKey = "quo_notice_mob";
                Object rowPkId = evt.getCurrentListSelectedRow().getPrimaryKeyValue();
                ScpMainPageMobile.this.showBillForm(rowPkId, entityKey);
            }
        });
        this.addClickListeners(new String[]{"scp_order", "scp_saloutstock", "scp_inquiry", "scp_bidbill", "scp_check", "scp_invoice", "scp_quote", "scp_recruit", "scp_supplier", "scp_score", "tobeconfirm", "lab_tobeconfirm", "tobedelivery", "lab_tobedelivery", "tobeinquiry", "toordelivery", "lab_ordelivery", "lab_tobeinquiry", "tobeunconfirmcheck", "lab_tobeunconfirmcheck", "tobebidbill", "lab_tobidbill", "bnt_homepage", "buttonmore"});
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(entityKey);
        billShowParameter.setPkId(val);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        switch (key = control.getKey()) {
            case "scp_order": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_order");
                showParameter.setFormId("scp_order_m_list_uc");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_check": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_check");
                showParameter.setFormId("scp_check_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_invoice": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_invoice");
                showParameter.setFormId("scp_invoice_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_inquiry": {
                showParameter.setAppId("SE7/UZFDVIE");
                showParameter.setBillFormId("quo_inquiry");
                showParameter.setFormId("quo_inquiry_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("supscope", "=", (Object)"1").or(new QFilter("supscope", "=", (Object)SUPSCOPE_DESIGNATE).and(new QFilter("entryentity.supplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner()))));
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_bidbill": {
                showParameter.setAppId("SE7/UZFDVIE");
                showParameter.setBillFormId("quo_bidbill");
                showParameter.setFormId("quo_bidbill_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("biztype", "=", (Object)"1").or(new QFilter("biztype", "=", (Object)SUPSCOPE_DESIGNATE).and(new QFilter("supquoentry.entrysupplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner()))));
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_quote": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_quote_m_list");
                showParameter.setFormId("bos_moblist");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_saloutstock": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_saloutstock");
                showParameter.setFormId("scp_saloutstock_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.getListFilterParameter().getQFilters().addAll(this.salOutStockFilter);
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_recruit": {
                showParameter.setAppId("/DNEA3QW/ATD");
                showParameter.setBillFormId("adm_recruit");
                showParameter.setFormId("adm_recruit_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_supplier": {
                showParameter.setAppId("/DNEA3QW/ATD");
                showParameter.setBillFormId("adm_supplier");
                showParameter.setFormId("adm_supplier_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "scp_score": {
                showParameter.setAppId("/DNEA3QW/ATD");
                showParameter.setBillFormId("adm_score");
                showParameter.setFormId("adm_score_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.setCustomParam("activeTab", (Object)"all");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "tobeconfirm": 
            case "lab_tobeconfirm": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_order");
                showParameter.setFormId("scp_order_m_list_uc");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.setCustomParam("activeTab", (Object)"noreceipt");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "tobedelivery": 
            case "lab_tobedelivery": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_order");
                showParameter.setFormId("scp_order_m_list_us");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.setCustomParam("activeTab", (Object)"noreceipt");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "toordelivery": 
            case "lab_ordelivery": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_saloutstock");
                showParameter.setFormId("scp_saloutstock_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.getListFilterParameter().getQFilters().addAll(this.salOutStockFilter);
                showParameter.setCustomParam("activeTab", (Object)"noreceipt");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "tobeunconfirmcheck": 
            case "lab_tobeunconfirmcheck": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_check");
                showParameter.setFormId("scp_check_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(this.bizPartnerQFilter);
                showParameter.setCustomParam("activeTab", (Object)"noreceipt");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "tobeinquiry": 
            case "lab_tobeinquiry": {
                showParameter.setAppId("eae607fb000152ac");
                showParameter.setBillFormId("scp_inquiry_m_list");
                showParameter.setFormId("bos_moblist");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "tobebidbill": 
            case "lab_tobidbill": {
                showParameter.setAppId("SE7/UZFDVIE");
                showParameter.setBillFormId("quo_bidbill");
                showParameter.setFormId("quo_bidbill_m_list");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("biztype", "=", (Object)"1").or(new QFilter("biztype", "=", (Object)SUPSCOPE_DESIGNATE).and(new QFilter("supquoentry.entrysupplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner()))));
                showParameter.setCustomParam("activeTab", (Object)"noreceipt");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "bnt_homepage": {
                this.initUnConfirmData();
                this.initBeDeliveryData();
                this.initUnInqueryData();
                this.initUnBidHallData();
                break;
            }
            case "buttonmore": {
                showParameter.setAppId("SE7/UZFDVIE");
                showParameter.setBillFormId("quo_notice");
                showParameter.setFormId("quo_notice_m_list");
                showParameter.setCustomParam("activeTab", (Object)"all");
                showParameter.setCustomParam("mainappid", (Object)"scp");
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initUnConfirmData();
        this.initBeDeliveryData();
        this.initUnInqueryData();
        this.initUnBidHallData();
        this.initUnReceiptData();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getFilterParameter().getQFilters().add(QFilter.isNull((String)"duedate").or(new QFilter("duedate", ">=", (Object)TimeServiceHelper.today())).and(new QFilter("billstatus", "=", (Object)BIZSTATUS_TOEXE).and(new QFilter("cfmstatus", "=", (Object)"A").and(new QFilter("supscope", "=", (Object)SUPSCOPE_DESIGNATE).and(new QFilter("entryentity.supplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner())).or(new QFilter("supscope", "=", (Object)"1"))))));
    }

    private void initUnConfirmData() {
        ArrayList<QFilter> orderConfirm = new ArrayList<QFilter>();
        orderConfirm.addAll(this.orderFilter);
        orderConfirm.add(this.bizPartnerQFilter);
        orderConfirm.add(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()));
        orderConfirm.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        HashSet ids = new HashSet();
        try (DataSet idSet = QueryServiceHelper.queryDataSet((String)"scpMain", (String)"scp_order", (String)"id", (QFilter[])orderConfirm.toArray(new QFilter[0]), (String)"billdate");){
            idSet.forEach(row -> ids.add(row.get(0)));
        }
        Label labelap_watingv = (Label)this.getView().getControl("tobeconfirm");
        StringBuilder Count = new StringBuilder("0");
        if (ids != null && ids.size() > 0) {
            Count.setLength(0);
            Count.append(ids.size());
        }
        labelap_watingv.setText(Count.toString());
    }

    private void initBeDeliveryData() {
        ArrayList<QFilter> orderConfirm = new ArrayList<QFilter>();
        orderConfirm.addAll(this.orderFilter);
        orderConfirm.add(this.bizPartnerQFilter);
        orderConfirm.add(new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.CONFIRM.getVal()));
        orderConfirm.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        HashSet ids = new HashSet();
        try (DataSet idSet = QueryServiceHelper.queryDataSet((String)"scpMain", (String)"scp_order", (String)"id", (QFilter[])orderConfirm.toArray(new QFilter[0]), (String)"billdate");){
            idSet.forEach(row -> ids.add(row.get(0)));
        }
        Label labelap_watingv = (Label)this.getView().getControl("tobedelivery");
        StringBuilder Count = new StringBuilder("0");
        if (ids != null && ids.size() > 0) {
            Count.setLength(0);
            Count.append(ids.size());
        }
        labelap_watingv.setText(Count.toString());
    }

    private void initUnReceiptData() {
        ArrayList<QFilter> orderConfirm = new ArrayList<QFilter>();
        orderConfirm.add(this.bizPartnerQFilter);
        orderConfirm.add(QFilter.of((String)"materialentry.sumreceiptqty=0", (Object[])new Object[0]).and(QFilter.of((String)"materialentry.suminstockqty=0", (Object[])new Object[0])));
        orderConfirm.addAll(this.salOutStockFilter);
        HashSet ids = new HashSet();
        try (DataSet idSet = QueryServiceHelper.queryDataSet((String)"scpMain", (String)"scp_saloutstock", (String)"id", (QFilter[])orderConfirm.toArray(new QFilter[0]), (String)"billdate");){
            idSet.forEach(row -> ids.add(row.get(0)));
        }
        Label labelap_watingv = (Label)this.getView().getControl("toordelivery");
        StringBuilder Count = new StringBuilder("0");
        if (ids != null && ids.size() > 0) {
            Count.setLength(0);
            Count.append(ids.size());
        }
        labelap_watingv.setText(Count.toString());
    }

    private void initUnInqueryData() {
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"getInquiryTodoInfos", (Object[])new Object[0]);
        Set toQuoInquiryIds = (Set)resultMap.get("ids1");
        Label toQuoInquiryLabel = (Label)this.getView().getControl("tobeinquiry");
        toQuoInquiryLabel.setText(String.valueOf(toQuoInquiryIds.size()));
    }

    private static Set<Long> getInqMyStatusIds(DynamicObjectCollection rows) {
        HashSet<Long> ids = new HashSet<Long>();
        if (rows == null || rows.size() == 0) {
            return ids;
        }
        for (DynamicObject row : rows) {
            String bizStatus = row.getString("bizstatus");
            String supplierProStatus = row.getString(SUPPLIER_PROSTATUS);
            String supStatus = row.getString("supplierstatus");
            if (!StringUtils.equals((CharSequence)bizStatus, (CharSequence)"A") || !StringUtils.equals((CharSequence)supStatus, (CharSequence)SUPPLIERSTATUS_PENDQUOTE) || !StringUtils.equals((CharSequence)supplierProStatus, (CharSequence)"A")) continue;
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private void initUnBidHallData() {
        ORM orm = ORM.create();
        DataSet resultData = null;
        QFilter qFilter = new QFilter("bidstatus", "=", (Object)BidStatusEnum.BIDDING.getVal());
        qFilter.and(new QFilter("biztype", "=", (Object)"1").or(new QFilter("biztype", "=", (Object)SUPSCOPE_DESIGNATE).and(new QFilter("supquoentry.entrysupplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner()))));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ScpMainPageMobile", (String)"quo_bidbill", (String)"id,bidstatus", (QFilter[])new QFilter[]{qFilter}, (String)"billdate");
        resultData = dataSet.groupBy(new String[]{"bidstatus"}).count().finish();
        DynamicObjectCollection bedelivery = orm.toPlainDynamicObjectCollection(resultData);
        Label labelap_watingv = (Label)this.getView().getControl("tobebidbill");
        String Count = "0";
        if (bedelivery != null && bedelivery.size() > 0) {
            Count = ((DynamicObject)bedelivery.get(0)).getString("count");
        }
        labelap_watingv.setText(Count);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.initUnConfirmData();
        this.initBeDeliveryData();
        this.initUnInqueryData();
        this.initUnBidHallData();
    }
}

