/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile;

import java.util.EventObject;
import java.util.List;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.scp.common.util.ScpBillOfBizPersonFilter;
import kd.scm.scp.formplugin.mobile.CoreMobileBillList;

public class ScpMobileUSOrderList
extends CoreMobileBillList
implements TabSelectListener,
IListPlugin {
    private final QFilter bizPartnerQFilter = BizPartnerUtil.assembleQFilterBizPartner();
    private final List<QFilter> orderFilter = ScpBillOfBizPersonFilter.orderFilter();
    private static Log log = LogFactory.getLog(ScpMobileUSOrderList.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
            }
        });
        billList.addListRowDoubleClickListener(new ListRowClickListener(){});
        this.addClickListeners(new String[]{"bar_pushall", "bar_pushpart"});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "noreceipt": {
                this.getPageCache().put("activeTab", tabKey);
                break;
            }
            case "nostorage": {
                this.getPageCache().put("activeTab", tabKey);
                break;
            }
            case "all": {
                this.getPageCache().put("activeTab", tabKey);
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        this.initInfoVisible(billList);
        this.initBatchVisible(billList);
        this.initStatusVisible();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (key) {
            case "bar_pushall": {
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.setFormId("scp_orderpush_m");
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "send"));
                mobileFormShowParameter.setCustomParam("pkId", billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        this.initInfoVisible(billList);
        this.initStatusVisible();
    }

    public void afterCreateNewData(EventObject e) {
        String activeTab = (String)this.getView().getFormShowParameter().getCustomParam("activeTab");
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(activeTab);
        this.getPageCache().put("activeTab", activeTab);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        this.initInfoVisible(billList);
        this.initStatusVisible();
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(this.bizPartnerQFilter);
        qFilters.addAll(this.orderFilter);
        QFilter qFilter = this.getQFilter();
        if (qFilter != null) {
            qFilters.add(qFilter);
        }
    }

    public QFilter getQFilter() {
        String activeTab = this.getPageCache().get("activeTab");
        QFilter qFilter = null;
        switch (activeTab) {
            case "noreceipt": {
                qFilter = new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.CONFIRM.getVal());
                break;
            }
            case "nostorage": {
                qFilter = new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.PARTOUTSTOCK.getVal());
                break;
            }
            case "all": {
                qFilter = new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal());
            }
        }
        return qFilter;
    }
}

