/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.scm.pssc.packagegroup.pojo;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscMaterialGroupInfo;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscTagGroupRuleOrderInfo;

@SdkPublic(scriptName="\u5206\u7ec4\u6253\u5305\u4e0a\u4e0b\u6587")
public final class PsscPackageGroupContext {
    private String formId;
    private long schemaId;
    private Map<Long, String> materialNameCache = new HashMap<Long, String>(1024);
    Map<String, String> categoryToTag = new HashMap<String, String>(1024);
    private Map<String, String> materialHanderTag = new HashMap<String, String>(1024);
    Map<Long, PsscMaterialGroupInfo> materialGroupInfoMap = new HashMap<Long, PsscMaterialGroupInfo>(1024);
    Map<Long, LinkedList<PsscMaterialGroupInfo>> longNumMapByCategory = new HashMap<Long, LinkedList<PsscMaterialGroupInfo>>(1024);
    private Map<Long, TreeSet<PsscTagGroupRuleOrderInfo>> rules = new HashMap<Long, TreeSet<PsscTagGroupRuleOrderInfo>>(1024);
    private Map<Long, JSONObject> unDealTask = new HashMap<Long, JSONObject>(1024);
    private Map<Long, JSONObject> dealTask = new HashMap<Long, JSONObject>();
    private Map<String, Object> customPrepareData = new HashMap<String, Object>();
    private Set<Long> handlers = new HashSet<Long>();
    private Map<Object, DynamicObject> schema;

    public static final PsscPackageGroupContext initContext(Map<Long, JSONObject> unDealTask, long schemaId) {
        PsscPackageGroupContext context = new PsscPackageGroupContext();
        Iterator<Map.Entry<Long, JSONObject>> iterator = unDealTask.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, JSONObject> next = iterator.next();
            JSONObject param = next.getValue();
            if (param == null || !param.containsKey((Object)"hander") || !param.containsKey((Object)"material")) {
                iterator.remove();
                continue;
            }
            Long hander = param.getLong("hander");
            context.handlers.add(hander);
        }
        context.schemaId = schemaId;
        context.schema = context.getSchema(schemaId);
        context.setUnDealTask(unDealTask);
        return context;
    }

    public void loadPackageGroupInfo(List<PsscTagGroupRuleOrderInfo> plugins) {
        Map<Object, DynamicObject> schemas = this.getSchema();
        if (schemas == null) {
            return;
        }
        for (Map.Entry<Object, DynamicObject> next : schemas.entrySet()) {
            DynamicObject schema = next.getValue();
            long handleuser = schema.getLong("handleuser_id");
            Map<Long, TreeSet<PsscTagGroupRuleOrderInfo>> rules = this.getRules();
            TreeSet<PsscTagGroupRuleOrderInfo> handelRules = rules.get(handleuser);
            if (handelRules == null) {
                handelRules = new TreeSet();
                rules.put(handleuser, handelRules);
            }
            for (PsscTagGroupRuleOrderInfo plugin : plugins) {
                PsscTagGroupRuleOrderInfo rule = (PsscTagGroupRuleOrderInfo)TypesContainer.createInstance(plugin.getClass());
                rule.init(schema);
                handelRules.add(rule);
            }
        }
    }

    private Map<Object, DynamicObject> getSchema(long schemaId) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (schemaId == 0L && this.handlers.size() > 0) {
            qFilter.and("default", "=", (Object)Boolean.TRUE);
            qFilter.and("handleuser", "in", this.handlers);
        } else if (schemaId != 0L) {
            qFilter.and("id", "=", (Object)schemaId);
        } else {
            return null;
        }
        return BusinessDataServiceHelper.loadFromCache((String)"pssc_grouppackage", (QFilter[])new QFilter[]{qFilter});
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public Map<Long, TreeSet<PsscTagGroupRuleOrderInfo>> getRules() {
        return this.rules;
    }

    public void setRules(Map<Long, TreeSet<PsscTagGroupRuleOrderInfo>> rules) {
        this.rules = rules;
    }

    public Map<Long, JSONObject> getUnDealTask() {
        return this.unDealTask;
    }

    public void setUnDealTask(Map<Long, JSONObject> unDealTask) {
        this.unDealTask = unDealTask;
    }

    public Map<Long, JSONObject> getDealTask() {
        return this.dealTask;
    }

    public void setDealTask(Map<Long, JSONObject> dealTask) {
        this.dealTask = dealTask;
    }

    public Map<String, String> getCategoryToTag() {
        return this.categoryToTag;
    }

    public void setCategoryToTag(Map<String, String> categoryToTag) {
        this.categoryToTag = categoryToTag;
    }

    public Map<String, String> getMaterialHanderTag() {
        return this.materialHanderTag;
    }

    public void setMaterialHanderTag(Map<String, String> materialHanderTag) {
        this.materialHanderTag = materialHanderTag;
    }

    public Map<Long, PsscMaterialGroupInfo> getMaterialGroupInfoMap() {
        return this.materialGroupInfoMap;
    }

    public void setMaterialGroupInfoMap(Map<Long, PsscMaterialGroupInfo> materialGroupInfoMap) {
        this.materialGroupInfoMap = materialGroupInfoMap;
    }

    public Map<Long, LinkedList<PsscMaterialGroupInfo>> getLongNumMapByCategory() {
        return this.longNumMapByCategory;
    }

    public void setLongNumMapByCategory(Map<Long, LinkedList<PsscMaterialGroupInfo>> longNumMapByCategory) {
        this.longNumMapByCategory = longNumMapByCategory;
    }

    public Map<String, Object> getCustomPrepareData() {
        return this.customPrepareData;
    }

    public void setCustomPrepareData(Map<String, Object> customPrepareData) {
        this.customPrepareData = customPrepareData;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public Set<Long> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Set<Long> handlers) {
        this.handlers = handlers;
    }

    public Map<Object, DynamicObject> getSchema() {
        return this.schema;
    }

    public void setSchema(Map<Object, DynamicObject> schema) {
        this.schema = schema;
    }

    public Map<Long, String> getMaterialNameCache() {
        return this.materialNameCache;
    }

    public void setMaterialNameCache(Map<Long, String> materialNameCache) {
        this.materialNameCache = materialNameCache;
    }
}

