/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.scm.sou.entity;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic(scriptName="\u91c7\u7eb3\u89c4\u5219\u5b9e\u4f53")
public class AdoptionRule {
    private static Map<String, String> ruleKey = new HashMap<String, String>(4);
    private static Map<String, String[]> quoteOrderMap = new HashMap<String, String[]>(4);
    private String compareKey;
    private Object initValue;
    private DynamicObject row;
    private DynamicObjectCollection quoteEntry;
    private Map<String, DynamicObject> quoteInfoMap;
    private DynamicObject currRow;
    private Set<Integer> adoptSet = new HashSet<Integer>();

    public final void initRule(DynamicObjectCollection quoteEntry, Map<String, DynamicObject> quoteInfoMap) {
        this.row = null;
        this.currRow = null;
        this.initValue = null;
        if (this.adoptSet != null) {
            this.adoptSet.clear();
        }
        this.quoteEntry = quoteEntry;
        this.quoteInfoMap = quoteInfoMap;
    }

    public String getRule(String operate) {
        return ruleKey.getOrDefault(operate, operate);
    }

    public String[] getOrderByRule(String rule) {
        String[] orders = quoteOrderMap.get(rule);
        if (orders == null) {
            orders = quoteOrderMap.get("adopttaxprice");
        }
        return Arrays.copyOf(orders, orders.length);
    }

    @SdkInternal
    public final void adopt() {
        if (this.getQuoteEntry() != null && this.getQuoteEntry().size() > 0) {
            String entryId = ((DynamicObject)this.getQuoteEntry().get(this.getQuoteEntry().size() - 1)).getString("entryid2");
            this.setCurrRow((DynamicObject)this.getQuoteEntry().get(this.getQuoteEntry().size() - 1));
            this.setRow(this.getQuoteInfoMap().get(entryId));
            if (this.getQuoteEntry().size() - 2 < 0) {
                this.setInitValue(this.getRow().get(this.getCompareKey()));
                this.getAdoptSet().add(this.getCurrRow().getInt("seq"));
                return;
            }
            this.compareAndSet();
        }
    }

    protected void compareAndSet() {
        Object nextValue = this.getRow().get(this.getCompareKey());
        if (nextValue instanceof BigDecimal && ((BigDecimal)nextValue).compareTo((BigDecimal)this.getInitValue()) < 0) {
            this.setInitValue(nextValue);
            this.getAdoptSet().clear();
            if (this.getCurrRow() != null) {
                this.getAdoptSet().add(this.getCurrRow().getInt("seq"));
            }
        }
    }

    public final void setRow(DynamicObject row) {
        this.row = row;
    }

    public final void addCompareInfo(String compareKey, Object initValue) {
        this.compareKey = StringUtils.isEmpty((CharSequence)compareKey) ? "settletaxprice" : this.getRule(compareKey);
        this.initValue = initValue;
    }

    public final Set<Integer> getAdoptSet() {
        return this.adoptSet;
    }

    protected final Object getInitValue() {
        return this.initValue;
    }

    protected final void setInitValue(Object initValue) {
        this.initValue = initValue;
    }

    protected final DynamicObject getCurrRow() {
        return this.currRow;
    }

    protected final DynamicObject getRow() {
        return this.row;
    }

    public final DynamicObjectCollection getQuoteEntry() {
        return this.quoteEntry;
    }

    @SdkInternal
    public final void setCurrRow(DynamicObject currRow) {
        this.currRow = currRow;
    }

    protected final String getCompareKey() {
        return this.compareKey;
    }

    @SdkInternal
    protected final Map<String, DynamicObject> getQuoteInfoMap() {
        return this.quoteInfoMap;
    }

    static {
        ruleKey.put("adopttaxprice", "settletaxprice");
        ruleKey.put("adoptprice", "settleprice");
        ruleKey.put("adopttaxamount", "sumtaxamount");
        ruleKey.put("adoptamount", "sumamount");
        ruleKey.put("1", "adopttaxprice");
        ruleKey.put("2", "adoptprice");
        ruleKey.put("3", "adopttaxamount");
        ruleKey.put("4", "adoptamount");
        quoteOrderMap.put("adopttaxprice", new String[]{"srcentryid asc", "settletaxprice asc", "settletaxamount asc", "settleprice asc"});
        quoteOrderMap.put("adoptprice", new String[]{"srcentryid asc", "settleprice asc"});
        quoteOrderMap.put("adopttaxamount", new String[]{"srcentryid asc", "sumtaxamount asc", "supplier asc"});
        quoteOrderMap.put("adoptamount", new String[]{"srcentryid asc", "sumamount asc", "supplier asc"});
    }
}

