/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.scm.srm.extpoint.portait;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticContainer;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticInfo;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;

@SdkPublic(scriptName="\u57fa\u4e8eAlgo\u65b9\u5f0f\u7edf\u8ba1\u4f9b\u5e94\u5546\u753b\u50cf\u62bd\u8c61\u63a5\u53e3")
public abstract class AbstractSrmPortraitDataSetStatistic
implements ISrmPortraitStatistic {
    @Override
    public abstract void startStatistic(SrmPortraitContext var1, SrmPortraitStatisticContainer var2);

    @Override
    public final SrmPortraitStatisticContainer process(SrmPortraitContext context, SrmPortraitStatisticContainer container) {
        if (this.isAsync()) {
            SrmPortraitStatisticContainer container1 = new SrmPortraitStatisticContainer();
            this.startStatistic(context, container1);
            return container1;
        }
        this.startStatistic(context, container);
        return container;
    }

    protected final GroupbyDataSet groupBy(DataSet dataSet) {
        if (dataSet != null) {
            return dataSet.groupBy(new String[]{"supplier", "curr"});
        }
        return null;
    }

    protected final SrmPortraitStatisticInfo createStatisticInfo(Row row, Map<String, SrmPortraitStatisticInfo> statisticInfoMap) {
        SrmPortraitStatisticInfo info = new SrmPortraitStatisticInfo();
        info.setSupplierId(row.getLong("supplier"));
        info.setCurrId(row.getLong("curr"));
        statisticInfoMap.put(this.makeRowKey(row), info);
        return info;
    }

    protected final String makeRowKey(Row row) {
        StringBuilder result = new StringBuilder().append(row.getString("supplier")).append("-").append(row.getString("curr"));
        return result.toString();
    }

    public static QFilter wrapCommonFilter(String supplier, String org, String billDate, SrmPortraitContext context) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (context != null) {
            List<Long> supplierIds = context.getBdSupplierIds();
            List<Long> orgIds = context.getOrgIds();
            if (supplierIds != null && supplierIds.size() > 0 && StringUtils.isNotBlank((CharSequence)supplier)) {
                qFilter.and(supplier, "in", supplierIds);
                qFilter.and(supplier, ">", (Object)0L);
            }
            if (orgIds != null && orgIds.size() > 0 && StringUtils.isNotBlank((CharSequence)org)) {
                qFilter.and(org, "in", orgIds);
            }
            Date dateFrom = context.getDateFrom();
            Date dateTo = context.getDateTo();
            if (StringUtils.isNotBlank((CharSequence)billDate)) {
                if (dateFrom != null) {
                    qFilter.and(billDate, ">=", (Object)dateFrom);
                }
                if (dateTo != null) {
                    qFilter.and(billDate, "<", (Object)dateTo);
                }
            }
        }
        return qFilter;
    }

    protected final void wrapStatisticMapWidthSet(DataSet dataSet, Map<String, Map<String, Object>> statisticInfoMap, String statisticLable, String statisticValue) {
        for (Row row : dataSet) {
            this.wrapStatisticMap(statisticInfoMap, row.getString("supplier"), statisticLable, row.get(statisticValue));
        }
    }

    protected final void wrapStatisticMap(Map<String, Map<String, Object>> statisticInfoMap, String supplierValue, String statisticLable, Object statisticValue) {
        if (statisticInfoMap == null) {
            return;
        }
        Map<String, Object> statisticMap = statisticInfoMap.get(supplierValue);
        if (statisticMap == null) {
            statisticMap = new HashMap<String, Object>();
            statisticInfoMap.put(supplierValue, statisticMap);
        }
        if (statisticMap.get(statisticLable) == null) {
            statisticMap.put(statisticLable, statisticValue);
        }
    }

    public static final String dealQueryTime(SrmPortraitContext context, Date dateFrom, Date dateTo) {
        if (dateFrom == null || dateTo == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u65e5\u671f\u67e5\u8be2\u533a\u95f4\u8303\u56f4", (String)"AbstractSrmPortraitDataSetStatistic_0", (String)"scm-srm-formplugin", (Object[])new Object[0]);
        }
        dateFrom = AbstractSrmPortraitDataSetStatistic.formatDate(dateFrom);
        dateTo = AbstractSrmPortraitDataSetStatistic.formatDate(dateTo);
        Calendar calendarTo = Calendar.getInstance();
        calendarTo.setTime(dateTo);
        calendarTo.add(5, 1);
        context.setDateFrom(dateFrom);
        context.setDateTo(calendarTo.getTime());
        return "";
    }

    public static final void setBeforeMonth(SrmPortraitContext context, Date dateTo, int month) {
        if (dateTo == null) {
            return;
        }
        dateTo = AbstractSrmPortraitDataSetStatistic.formatDate(dateTo);
        Calendar calendarTo = Calendar.getInstance();
        calendarTo.setTime(dateTo);
        calendarTo.add(2, -month);
        context.setDateFrom(calendarTo.getTime());
        context.setDateTo(dateTo);
    }

    public static final Date formatDate(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd"});
        return DateUtils.parseDateTime((String)dateStr, (String)"yyyy-MM-dd");
    }
}

