/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.scm.srm.extpoint.portait;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticContainer;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;

@SdkInternal
public interface ISrmPortraitStatistic {
    public void startStatistic(SrmPortraitContext var1, SrmPortraitStatisticContainer var2);

    public SrmPortraitStatisticContainer process(SrmPortraitContext var1, SrmPortraitStatisticContainer var2);

    public static SrmPortraitContext getContextFromCache(IPageCache cache) {
        String contextStr;
        SrmPortraitContext context = new SrmPortraitContext();
        if (cache != null && StringUtils.isNotBlank((CharSequence)(contextStr = cache.get("srmPortraitContext")))) {
            context = (SrmPortraitContext)SerializationUtils.fromJsonString((String)contextStr, SrmPortraitContext.class);
        }
        return context;
    }

    public static void putContextToCache(IPageCache cache, SrmPortraitContext context) {
        cache.put("srmPortraitContext", SerializationUtils.toJsonString((Object)context));
    }

    public static void viewPortraitIndicatorDetail(String entity, IFormView view, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        if (view == null) {
            return;
        }
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache(view.getPageCache());
        QFilter qFilter = null;
        ListShowParameter listShowParameter = new ListShowParameter();
        switch (entity) {
            case "src_contract": {
                qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter("entryentity.supplier", "org", "billdate", context);
                break;
            }
            case "src_analysetool": {
                qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter("supplier", "org", "project.billdate", context);
                break;
            }
            case "srm_improve": 
            case "srm_examine": {
                qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter("supplier", "org", "billdate", context);
                break;
            }
            case "pur_order": {
                qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter("supplier", "org", "billdate", context);
                qFilter.and("billstatus", "=", (Object)"C");
                break;
            }
            case "srm_supplier": {
                if (paramMap != null) {
                    Object billid = paramMap.get("billid");
                    qFilter = new QFilter("id", "=", billid);
                }
                entity = "srm_supplier";
                break;
            }
            case "conm_purcontract": {
                listShowParameter.getCustomParams().put("checkRightAppId", "pcm");
                listShowParameter.setUseOrgIds(context.getOrgIds());
                HashSet<String> validstatus = new HashSet<String>();
                validstatus.add("B");
                validstatus.add("C");
                listShowParameter.setIsolationOrg(true);
                qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter("supplier", "org", "createtime", context);
                qFilter.and("validstatus", "in", validstatus);
                qFilter.and("billstatus", "=", (Object)"C");
                qFilter.and("settlecurrency", "=", (Object)context.getCurrId());
                break;
            }
        }
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (pkIds != null && !pkIds.isEmpty()) {
            for (Object pkId : pkIds) {
                listShowParameter.addLinkQueryPkId(pkId);
            }
        }
        listShowParameter.setBillFormId(entity);
        listShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        if (paramMap != null) {
            listShowParameter.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            listShowParameter.setCloseCallBack(closeCallBack);
        }
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (qFilter != null) {
            qFilters.add(qFilter);
        }
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void viewSrmPortraitInfo(DynamicObject obj, IFormView view) {
        if (obj == null || view == null) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        SrmPortraitContext context = new SrmPortraitContext();
        String createOrg = view.getPageCache().get("createOrg");
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            createOrg = (String)view.getFormShowParameter().getCustomParam("useorgId");
        }
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            context.getOrgIds().add(Long.valueOf(createOrg));
            param.getCustomParams().put("billid", obj.getLong("id"));
            param.getCustomParams().put("context", SerializationUtils.toJsonString((Object)context));
            param.setFormId("srm_portrait_supplier");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setStatus(OperationStatus.EDIT);
            view.showForm(param);
        }
    }

    default public boolean isAsync() {
        return false;
    }
}

