/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ExchangeCurrUtil {
    public static BigDecimal exchangeTaxprice(long compareCurrId, long inquiryCurrId, long extableId, BigDecimal taxprice, Map<Long, BigDecimal> cacheRateMap) {
        BigDecimal exchangeRate;
        if (inquiryCurrId == compareCurrId) {
            exchangeRate = BigDecimal.ONE;
        } else {
            exchangeRate = cacheRateMap.get(compareCurrId);
            if (exchangeRate == null && (exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)extableId, (Long)compareCurrId, (Long)inquiryCurrId, (Date)TimeServiceHelper.now())) != null) {
                cacheRateMap.put(compareCurrId, exchangeRate);
            }
        }
        if (exchangeRate == null || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
            return null;
        }
        taxprice = taxprice.multiply(exchangeRate);
        return taxprice;
    }

    public static long getexrateid(DynamicObject bill) {
        DynamicObject extable = bill.getDynamicObject("exchtype");
        long extableId = extable == null ? 0L : extable.getLong("id");
        return extableId;
    }
}

