/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.IParseEvtSource;

public abstract class AbstractParseSourceToSupenroll
implements IParseEvtSource {
    public String setBasedataName() {
        return "bd_supplier";
    }

    abstract String getSupEntryStatus();

    public Map<String, Set<Long>> batchParseSourceToOthers(String billKey, String source, String fieldName, String bosOrg) {
        String bdSupplier = fieldName + ".bizpartner";
        return this.parseSourceToUserIds(source, bdSupplier);
    }

    public Set<Long> parseSourceToOthers(String billKey, String source) {
        String bdSupplier = this.parseFieldNameByBillKey(source, billKey, "bd_supplier");
        return this.getResultByMap(billKey, source, bdSupplier, null);
    }

    private Map<String, Set<Long>> parseSourceToUserIds(String source, String bdSupplier) {
        HashMap ids = new HashMap(8);
        HashSet<Long> userIds = new HashSet<Long>();
        HashMap<Long, Long> mapList = new HashMap<Long, Long>(1024);
        String[] bdSupplierKey = bdSupplier.split("\\.");
        if (bdSupplierKey.length >= 3) {
            JSONArray array = JSONArray.parseArray((String)source);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                HashSet<Long> supenrollIds = new HashSet<Long>();
                String bussinessKey = jsonObject.getString("businesskey");
                JSONArray entryentity = jsonObject.getJSONArray(bdSupplierKey[0]);
                for (int j = 0; j < entryentity.size(); ++j) {
                    JSONObject entryObj = entryentity.getJSONObject(j);
                    String supEntryStatus = entryObj.getString("supentrystatus");
                    if (!this.getSupEntryStatus().equals(supEntryStatus)) continue;
                    JSONObject supenroll = entryObj.getJSONObject("supenroll");
                    Long supenrollId = supenroll.getLong("id");
                    userIds.add(supenrollId);
                    supenrollIds.add(supenrollId);
                    JSONObject supplier = entryObj.getJSONObject(bdSupplierKey[1]);
                    JSONObject bizpartner = supplier.getJSONObject(bdSupplierKey[2]);
                    Long bizpartnerId = bizpartner.getLong("id");
                    mapList.put(supenrollId, bizpartnerId);
                }
                ids.put(bussinessKey, supenrollIds);
            }
        }
        Map<Object, Object> adminSupUserIdsByBizPartner = new HashMap(8);
        if (!userIds.isEmpty()) {
            DynamicObjectCollection enableUserIds = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("id", "in", userIds)});
            for (DynamicObject enableUser : enableUserIds) {
                long enableUserId = enableUser.getLong("id");
                if (enableUserId == 0L) continue;
                mapList.replace(enableUserId, 0L);
            }
            HashSet<Long> bizpartnerIds = new HashSet<Long>();
            for (Map.Entry next : mapList.entrySet()) {
                Long bizpartnerId = (Long)next.getValue();
                if (bizpartnerId == 0L) continue;
                bizpartnerIds.add(bizpartnerId);
            }
            if (!bizpartnerIds.isEmpty()) {
                adminSupUserIdsByBizPartner = this.getEnableAdminSupUserIdsByBizPartner(bizpartnerIds);
            }
        }
        HashMap<String, Set<Long>> resultIds = new HashMap<String, Set<Long>>(8);
        for (Map.Entry entry : ids.entrySet()) {
            Set supenrollIds = (Set)entry.getValue();
            HashSet<Long> newSupenrollIds = new HashSet<Long>(8);
            String bussinessKey = (String)entry.getKey();
            for (Long supenrollId : supenrollIds) {
                Long bizpartnerId = (Long)mapList.get(supenrollId);
                if (bizpartnerId != 0L) {
                    Long userId = (Long)adminSupUserIdsByBizPartner.get(bizpartnerId);
                    if (userId == null) continue;
                    newSupenrollIds.add(userId);
                    continue;
                }
                newSupenrollIds.add(supenrollId);
            }
            resultIds.put(bussinessKey, newSupenrollIds);
        }
        return resultIds;
    }

    private Map<Long, Long> getEnableAdminSupUserIdsByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", bizpartnerIdSet)).and(new QFilter("enable", "=", (Object)"1"))};
        HashMap<Long, Long> map = new HashMap<Long, Long>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractParseSourceToSupenroll", (String)"pur_supuser", (String)"user,bizpartner", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> {
                Long userId = row.getLong("user");
                Long bizpartner = row.getLong("bizpartner");
                map.put(bizpartner, userId);
            });
        }
        return map;
    }
}

