/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.IParseEvtSource;

public class ParseSourceToQuoteSups
implements IParseEvtSource {
    public String setBasedataName() {
        return "bd_supplier";
    }

    public Map<String, Set<Long>> batchParseSourceToOthers(String billKey, String source, String fieldName, String bosOrg) {
        String bdSupplier = fieldName + ".bizpartner";
        return this.parseSourceToUserIds(source, bdSupplier);
    }

    public Set<Long> parseSourceToOthers(String billKey, String source) {
        String bdSupplier = this.parseFieldNameByBillKey(source, billKey, "bd_supplier");
        return this.getResultByMap(billKey, source, bdSupplier, null);
    }

    private Map<String, Set<Long>> parseSourceToUserIds(String source, String bdSupplier) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        JSONArray array = JSONArray.parseArray((String)source);
        for (int i = 0; i < array.size(); ++i) {
            HashSet<Long> userIds = new HashSet<Long>(1024);
            JSONObject jsonObject = array.getJSONObject(i);
            String bussinessKey = jsonObject.getString("businesskey");
            Long creator = jsonObject.getJSONObject("creator").getLong("id");
            userIds.add(creator);
            Long modifier = jsonObject.getJSONObject("modifier").getLong("id");
            userIds.add(modifier);
            Long auditor = jsonObject.getJSONObject("auditor").getLong("id");
            userIds.add(auditor);
            Set origin = (Set)map.get(bussinessKey);
            if (origin != null) {
                origin.addAll(userIds);
                map.put(bussinessKey, origin);
                continue;
            }
            map.put(bussinessKey, userIds);
        }
        String[] supplierKeys = bdSupplier.split("\\.");
        Map ids = this.parseUserIds(source, supplierKeys);
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                String bussinessKey = (String)entry.getKey();
                Set userIds = (Set)entry.getValue();
                DynamicObjectCollection userDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user.id", (QFilter[])new QFilter[]{new QFilter("user.id", "in", (Object)userIds).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")});
                Set enableUsers = userDyns.stream().map(userDyn -> userDyn.getLong("user.id")).collect(Collectors.toSet());
                userIds.retainAll(enableUsers);
                if (userIds.isEmpty()) {
                    Set supplierUserIds = (Set)ids.get(bussinessKey);
                    List adminSupUserIdsByBizPartner = BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner((Set)supplierUserIds);
                    map.put(bussinessKey, new HashSet(adminSupUserIdsByBizPartner));
                    continue;
                }
                map.put(bussinessKey, new HashSet(userIds));
            }
        }
        return map;
    }
}

