/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.IParseEvtSource;

public class ParseSourceToQuoteUsers
implements IParseEvtSource {
    public Map<String, Set<Long>> batchParseSourceToOthers(String billKey, String source, String fieldName, String bosOrg) {
        return this.parseSourceToUserIds(source);
    }

    public Set<Long> parseSourceToOthers(String billKey, String source) {
        return this.getResultByMap(billKey, source, null, null);
    }

    private Map<String, Set<Long>> parseSourceToUserIds(String source) {
        Set<Long> userIds;
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        HashMap<String, String> bussinessKeyMap = new HashMap<String, String>(8);
        ArrayList<String> billnos = new ArrayList<String>(8);
        JSONArray array = JSONArray.parseArray((String)source);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            String bussinessKey = jsonObject.getString("businesskey");
            String billno = jsonObject.getString("billno");
            billnos.add(billno);
            bussinessKeyMap.put(billno, bussinessKey);
        }
        DynamicObjectCollection quoteBills = QueryServiceHelper.query((String)"quo_quote", (String)"id,billno,inquiryno,creator,modifier,auditor", (QFilter[])new QFilter[]{new QFilter("inquiryno", "in", billnos), new QFilter("billstatus", "=", (Object)"C"), new QFilter("materialentry.entrystatus", "=", (Object)"A")});
        for (DynamicObject quoteBill : quoteBills) {
            userIds = new HashSet<Long>(8);
            String billno = quoteBill.getString("inquiryno");
            String bussinessKey = (String)bussinessKeyMap.get(billno);
            userIds.add(quoteBill.getLong("creator"));
            userIds.add(quoteBill.getLong("modifier"));
            userIds.add(quoteBill.getLong("auditor"));
            if (map.containsKey(bussinessKey)) {
                Set origin = (Set)map.get(bussinessKey);
                origin.addAll(userIds);
                map.put(bussinessKey, origin);
                continue;
            }
            map.put(bussinessKey, userIds);
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                userIds = (Set)entry.getValue();
                DynamicObjectCollection userDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user.id", (QFilter[])new QFilter[]{new QFilter("user.id", "in", userIds).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")});
                Set enableUsers = userDyns.stream().map(userDyn -> userDyn.getLong("user.id")).collect(Collectors.toSet());
                userIds.retainAll(enableUsers);
                map.put((String)entry.getKey(), userIds);
            }
        }
        return map;
    }
}

