/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.common.entity.QuoteWinInfo;
import org.apache.commons.lang.StringUtils;

public class SouBidBillUtil {
    public static final String SUPQUOENTRY = "supquoentry";
    public static final String QUOENTRY = "quoentry";

    public static void setbidBill(DynamicObject bidBill) {
        Map<String, BigDecimal> supQuoAmtMap = SouBidBillUtil.getNewestSupQuoAmtMap(bidBill);
        List<Map.Entry<String, BigDecimal>> supQuoAmtList = SouBidBillUtil.rankSupQuoAmt(supQuoAmtMap);
        if (!supQuoAmtList.isEmpty()) {
            SouBidBillUtil.rankSup(bidBill, supQuoAmtList);
            SouBidBillUtil.confirmBid(bidBill, supQuoAmtList.get(0));
        }
    }

    public static void confirmBidEntryQuote(DynamicObject bidBill, boolean isConfirm) {
        HashSet<Long> supplierSet = new HashSet<Long>();
        Map<String, QuoteWinInfo> resultMap = SouBidBillUtil.getSupQuoWinMap(bidBill.getDynamicObjectCollection(QUOENTRY), "materialrowid", supplierSet, null);
        HashMap<Long, BigDecimal> supQuoteAmountMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection materialEntry = bidBill.getDynamicObjectCollection("materialentry");
        BigDecimal totalWin = SouBidBillUtil.setMaterialConfirmInfo(materialEntry, resultMap, supQuoteAmountMap, isConfirm);
        SouBidBillUtil.setSupQuoteEntry(bidBill.getDynamicObjectCollection(SUPQUOENTRY), supplierSet, supQuoteAmountMap, isConfirm);
        if (isConfirm) {
            bidBill.set("bidamount", (Object)totalWin);
            bidBill.set("bidprofit", (Object)bidBill.getBigDecimal("sumtaxamount").subtract(totalWin));
        }
        bidBill.set("bidnum", (Object)supplierSet.size());
    }

    public static void setSupQuoteEntry(DynamicObjectCollection quoteEntry, Set<Long> supplierSet, Map<Long, BigDecimal> supQuoteAmountMap, boolean setStatus) {
        if (quoteEntry == null || supplierSet == null || supQuoteAmountMap == null) {
            return;
        }
        quoteEntry.forEach(info -> {
            Long supplierId = info.getLong("entrysupplier_id");
            if (supplierSet.contains(supplierId)) {
                info.set("supamount", supQuoteAmountMap.get(supplierId));
            }
            if (setStatus) {
                info.set("supentrystatus", (Object)SupBidStatusEnum.NOTBIDDING);
            }
        });
    }

    public static BigDecimal setMaterialConfirmInfo(DynamicObjectCollection materialEntry, Map<String, QuoteWinInfo> paramMap, Map<Long, BigDecimal> supQuoteAmountMap, boolean isSetRowInfo) {
        if (materialEntry == null || paramMap == null || supQuoteAmountMap == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject info : materialEntry) {
            QuoteWinInfo quoteWinInfo = paramMap.get(String.valueOf(info.getPkValue()));
            if (quoteWinInfo == null) continue;
            if (isSetRowInfo) {
                info.set("winprice", (Object)quoteWinInfo.getWinPrice());
                info.set("wintaxprice", (Object)quoteWinInfo.getWinTaxPrice());
            }
            quoteWinInfo.setTaxAmount(quoteWinInfo.getWinTaxPrice().multiply(info.getBigDecimal("qty")));
            BigDecimal amount = supQuoteAmountMap.get(quoteWinInfo.getSupplierId());
            if (amount == null) {
                amount = quoteWinInfo.getTaxAmount();
                supQuoteAmountMap.put(quoteWinInfo.getSupplierId(), amount);
            }
            total = total.add(quoteWinInfo.getTaxAmount());
        }
        return total;
    }

    public static Map<String, QuoteWinInfo> getSupQuoWinMap(DynamicObjectCollection quoteInfo, String key, Set<Long> supplierSet, Function<DynamicObject, IPageCache> cacheFunction) {
        HashMap<String, QuoteWinInfo> resultMap = new HashMap<String, QuoteWinInfo>();
        if (supplierSet == null) {
            return resultMap;
        }
        SouBidHallUtil.sortByQuoteDate((DynamicObjectCollection)quoteInfo, (int)-1);
        HashMap mapMap = new HashMap();
        if (quoteInfo != null) {
            for (DynamicObject info : quoteInfo) {
                String rowId;
                QuoteWinInfo quoteWinInfo;
                if (cacheFunction != null) {
                    cacheFunction.apply(info);
                }
                if ((quoteWinInfo = (QuoteWinInfo)resultMap.get(rowId = info.getString(key))) == null) {
                    quoteWinInfo = new QuoteWinInfo();
                    resultMap.put(info.getString(key), quoteWinInfo);
                }
                HashMap<Long, String> supplierMap = (HashMap<Long, String>)mapMap.get(rowId);
                long quotesupplier_id = info.getLong("quotesupplier_id");
                supplierSet.add(quotesupplier_id);
                if (Objects.isNull(supplierMap)) {
                    supplierMap = new HashMap<Long, String>();
                    supplierMap.put(quotesupplier_id, "");
                    mapMap.put(rowId, supplierMap);
                } else {
                    if (supplierMap.containsKey(quotesupplier_id)) continue;
                    supplierMap.put(quotesupplier_id, "");
                    if (quoteWinInfo.getTaxAmount().compareTo(info.getBigDecimal("quoteamount")) < 0) continue;
                }
                quoteWinInfo.setSupplierId(quotesupplier_id);
                quoteWinInfo.setQuoteDate(info.getDate("quotedate"));
                quoteWinInfo.setWinPrice(info.getBigDecimal("quoteprice"));
                quoteWinInfo.setTaxAmount(info.getBigDecimal("quoteamount"));
                quoteWinInfo.setWinTaxPrice(info.getBigDecimal("quotetaxprice"));
            }
        }
        return resultMap;
    }

    public static void confirmBid(DynamicObject bidBill, Map.Entry<String, BigDecimal> supQuoAmtEntry) {
        boolean bidForShowWinAmount;
        BigDecimal amount = supQuoAmtEntry.getValue();
        BigDecimal sumTaxAmount = CommonUtil.getBigDecimalPro((Object)bidBill.get("sumtaxamount"));
        bidBill.set("bidamount", (Object)amount);
        bidBill.set("supplier", (Object)supQuoAmtEntry.getKey());
        bidBill.set("bidprofit", (Object)sumTaxAmount.subtract(amount));
        DynamicObject quoBidBill = BusinessDataServiceHelper.loadSingle((Object)bidBill.getPkValue(), (String)"quo_bidbill");
        boolean bidForShowWinCompany = bidBill.getBoolean("open3");
        if (bidForShowWinCompany) {
            quoBidBill.set("supplier1", (Object)supQuoAmtEntry.getKey());
        }
        if (bidForShowWinAmount = bidBill.getBoolean("open4")) {
            quoBidBill.set("amount1", (Object)amount);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{quoBidBill});
        DynamicObjectCollection supQuoEntrys = bidBill.getDynamicObjectCollection(SUPQUOENTRY);
        for (DynamicObject supQuoEntry : supQuoEntrys) {
            DynamicObject quoSup = supQuoEntry.getDynamicObject("entrysupplier");
            if (quoSup != null && quoSup.getPkValue().toString().equals(supQuoAmtEntry.getKey())) {
                supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.WINTHEBID);
                continue;
            }
            supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.FAILTHEBID);
        }
        bidBill.set("bidnum", (Object)SouBidBillUtil.countQuoSup(bidBill));
    }

    public static int countQuoSup(DynamicObject bidBill) {
        DynamicObjectCollection quoCols = bidBill.getDynamicObjectCollection(QUOENTRY);
        HashSet<String> quoSupPkSet = new HashSet<String>();
        for (DynamicObject quoCol : quoCols) {
            Object quoSupObj = quoCol.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            if (null == quoSupplierPk) continue;
            quoSupPkSet.add(quoSupplierPk.toString());
        }
        return quoSupPkSet.size();
    }

    public static void rankSup(DynamicObject bidBill, List<Map.Entry<String, BigDecimal>> supQuoAmtList) {
        DynamicObjectCollection supQuoCols = bidBill.getDynamicObjectCollection(SUPQUOENTRY);
        int rank = 1;
        for (Map.Entry<String, BigDecimal> supQuoAmtEntry : supQuoAmtList) {
            boolean isMatched = false;
            for (DynamicObject supQuoCol : supQuoCols) {
                DynamicObject entrySup = supQuoCol.getDynamicObject("entrysupplier");
                if (isMatched || !entrySup.getPkValue().toString().equals(supQuoAmtEntry.getKey())) continue;
                supQuoCol.set("supamount", (Object)supQuoAmtEntry.getValue());
                supQuoCol.set("ranking", (Object)rank);
                isMatched = true;
            }
            ++rank;
        }
    }

    public static Map<String, BigDecimal> getSupQuoAmtMap(DynamicObject bidBill) {
        DynamicObjectCollection quoCols = bidBill.getDynamicObjectCollection(QUOENTRY);
        HashMap<String, BigDecimal> supQuoAmtMap = new HashMap<String, BigDecimal>();
        for (DynamicObject quoCol : quoCols) {
            Object quoSupObj = quoCol.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            String quoSupplierPkStr = quoSupplierPk.toString();
            BigDecimal newQuoAmt = quoCol.getBigDecimal("quoteamount");
            BigDecimal supNewQuoAmt = (BigDecimal)supQuoAmtMap.get(quoSupplierPkStr);
            if (supNewQuoAmt != null && newQuoAmt.compareTo(supNewQuoAmt) >= 0) continue;
            supQuoAmtMap.put(quoSupplierPkStr, newQuoAmt);
        }
        return supQuoAmtMap;
    }

    public static Map<String, BigDecimal> getNewestSupQuoAmtMap(DynamicObject bidBill) {
        DynamicObjectCollection quoCols = bidBill.getDynamicObjectCollection(QUOENTRY);
        LinkedHashMap<String, BigDecimal> supQuoAmtMap = new LinkedHashMap<String, BigDecimal>();
        LinkedHashMap<String, Date> quoteDatMap = new LinkedHashMap<String, Date>();
        BigDecimal newQuoAmt = BigDecimal.ZERO;
        Date newQuoteDate = new Date();
        for (DynamicObject quoCol : quoCols) {
            Object quoSupObj = quoCol.get("quotesupplier");
            Long quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? (Long)((DynamicObject)quoSupObj).getPkValue() : (Long)quoSupObj;
            newQuoteDate = quoCol.getDate("quotedate");
            newQuoAmt = quoCol.getBigDecimal("quoteamount");
            Date supNewQuoDate = (Date)quoteDatMap.get(String.valueOf(quoSupplierPk));
            if (supNewQuoDate == null) {
                quoteDatMap.put(String.valueOf(quoSupplierPk), newQuoteDate);
                supQuoAmtMap.put(String.valueOf(quoSupplierPk), newQuoAmt);
                continue;
            }
            if (!newQuoteDate.after(supNewQuoDate)) continue;
            quoteDatMap.put(String.valueOf(quoSupplierPk), newQuoteDate);
            supQuoAmtMap.remove(String.valueOf(quoSupplierPk));
            supQuoAmtMap.put(String.valueOf(quoSupplierPk), newQuoAmt);
        }
        return supQuoAmtMap;
    }

    public static List<Map.Entry<String, BigDecimal>> rankSupQuoAmt(Map<String, BigDecimal> supQuoAmtMap) {
        ArrayList<Map.Entry<String, BigDecimal>> supQuoAmtList = new ArrayList<Map.Entry<String, BigDecimal>>(supQuoAmtMap.entrySet());
        Collections.sort(supQuoAmtList, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return supQuoAmtList;
    }

    public static String getBotpRule(DynamicObject[] objs, String targetBillType) {
        Map<String, Object> billInfoMap = SouBidBillUtil.getBillIdInfo(objs);
        String rules = "";
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            billInfoMap.put("targetBillType", targetBillType);
            param.put("data", billInfoMap);
            param.put("code", "200");
            rules = ApiUtil.botpQuery(param);
            if (StringUtils.isEmpty((String)rules) || "[]".equals(rules)) {
                return null;
            }
        }
        return rules;
    }

    public static Map<String, Object> getBillIdInfo(DynamicObject[] objs) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                Object sb = null;
                Object sbei = null;
                sb = entry.get("srcbillid");
                sbei = entry.get("srcentryid");
                if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
                String srcBillId = sb.toString();
                String srcBillEntryId = sbei.toString();
                entryIdSet.add(srcBillEntryId);
                billIdSet.add(srcBillId);
            }
        }
        dataMap.put("billId", billIdSet);
        dataMap.put("entryId", entryIdSet);
        return dataMap;
    }

    public static void toOrder(DynamicObject[] objs, String botpNumber, IFormView view) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("code", "200");
        param.put("billtype", "sou_bidbill");
        param.put("action", "souBidToOrder");
        param.put("botpnumber", botpNumber);
        param.put("data", SouBidBillUtil.getBillInfo(objs));
        String msg = ApiUtil.souBidBillToOrder(param);
        StringBuilder msgSB = new StringBuilder();
        StringBuilder successMsg = new StringBuilder();
        if (msg != null && !msg.isEmpty()) {
            Map returnDataMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            for (DynamicObject obj : objs) {
                String billno = obj.getString("billno");
                successMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u7ade\u4ef7\u5355\u53f7\uff1a{0}\u751f\u6210\u7684\u91c7\u8d2d\u8ba2\u5355\u5355\u636e\u7f16\u53f7\uff1a", (String)"SouBidBillUtil_0", (String)"scm-sou-common", (Object[])new Object[0]), billno));
                DynamicObjectCollection cols = obj.getDynamicObjectCollection("materialentry");
                DynamicObject col = null;
                for (int i = 0; i < cols.size(); ++i) {
                    col = (DynamicObject)cols.get(i);
                    Object detail = returnDataMap.get(col.getPkValue().toString());
                    if (detail instanceof Map) {
                        Map detailMap = (Map)returnDataMap.get(col.getPkValue().toString());
                        Object error = detailMap.get("error");
                        if (error == null || error.toString().isEmpty()) {
                            Object poBillNo = detailMap.get("billno");
                            col.set("pobillno", poBillNo);
                            col.set("pobillid", detailMap.get("billid"));
                            col.set("poentryid", detailMap.get("entryid"));
                            if (successMsg.toString().contains(poBillNo.toString())) continue;
                            successMsg.append(poBillNo);
                            continue;
                        }
                        msgSB.append(error).append(";\n");
                        continue;
                    }
                    msgSB.append(MessageFormat.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\uff1a{0}", (String)"SouBidBillUtil_1", (String)"scm-sou-common", (Object[])new Object[0]), detail)).append(";\n");
                }
                successMsg.append(";\n");
            }
        } else {
            msgSB.append(ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u6570\u636e\u3002", (String)"SouBidBillUtil_2", (String)"scm-sou-common", (Object[])new Object[0]));
        }
        if (msgSB.length() == 0) {
            view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"SouBidBillUtil_3", (String)"scm-sou-common", (Object[])new Object[0]), successMsg.toString(), MessageTypes.Default);
            SaveServiceHelper.save((DynamicObject[])objs);
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u5355\u636e\u751f\u6210\u5931\u8d25\u3002", (String)"SouBidBillUtil_4", (String)"scm-sou-common", (Object[])new Object[0]), msgSB.toString(), MessageTypes.Default);
        }
        view.updateView();
    }

    public static List<Map<String, Object>> getBillInfo(DynamicObject[] objs) {
        ArrayList<Map<String, Object>> billList = new ArrayList<Map<String, Object>>(objs.length);
        for (DynamicObject obj : objs) {
            Map<String, Object> detailMap = SouBidBillUtil.getInfo(obj);
            detailMap.put("billid", String.valueOf(obj.getPkValue()));
            detailMap.put("billno", obj.get("billno").toString());
            billList.add(detailMap);
        }
        return billList;
    }

    public static Map<String, Object> getInfo(DynamicObject bill) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        ArrayList entryList = new ArrayList();
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("materialentry");
        String srcbilltype = "pur_apply";
        for (DynamicObject entry : entryCol) {
            HashMap<String, Object> entryDetailMap = new HashMap<String, Object>(8);
            Object sb = entry.get("srcbillid");
            Object sbei = entry.get("srcentryid");
            if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            String srcBillId = sb.toString();
            String srcBillEntryId = sbei.toString();
            entryDetailMap.put("entryid", entry.getPkValue().toString());
            entryDetailMap.put("srcbilltype", srcbilltype);
            entryDetailMap.put("srcbillid", srcBillId);
            entryDetailMap.put("srcentryid", srcBillEntryId);
            entryDetailMap.put("taxprice", CommonUtil.getBigDecimalPro((Object)entry.get("taxprice")));
            entryDetailMap.put("taxamount", CommonUtil.getBigDecimalPro((Object)entry.get("taxamount")));
            entryList.add(entryDetailMap);
        }
        detailMap.put("entry", entryList);
        return detailMap;
    }

    public static void bidAlertDate(IFormView view, DynamicObject bidBill, CloseCallBack callBack) {
        String bidstatus = bidBill.getString("bidstatus");
        Date enrollDate = bidBill.getDate("enrolldate");
        Date openDate = bidBill.getDate("opendate");
        Date resultDate = bidBill.getDate("resultdate");
        Date deliDate1 = bidBill.getDate("delidate1");
        HashSet<String> bidStatusSet = new HashSet<String>();
        bidStatusSet.add(BidStatusEnum.ENROLMENT.getVal());
        bidStatusSet.add(BidStatusEnum.DEADLINE.getVal());
        bidStatusSet.add(BidStatusEnum.BEENEXAMINED.getVal());
        bidStatusSet.add(BidStatusEnum.BIDDING.getVal());
        bidStatusSet.add(BidStatusEnum.EVALUATING.getVal());
        bidStatusSet.add(BidStatusEnum.CONFIRMED.getVal());
        if (!bidStatusSet.contains(bidstatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5f53\u524d\u72b6\u6001\u4e0d\u7b26\u5408\u53d8\u66f4\u65f6\u95f4\u7684\u72b6\u6001\u6761\u4ef6\u3002", (String)"SouBidBillUtil_11", (String)"scm-sou-common", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("billid", bidBill.getPkValue());
        paramMap.put("bidstatus", bidstatus);
        paramMap.put("opendate", openDate);
        paramMap.put("enrolldate", enrollDate);
        paramMap.put("resultdate", resultDate);
        paramMap.put("delidate1", deliDate1);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCloseCallBack(callBack);
        fsp.setCustomParams(paramMap);
        fsp.setFormId("sou_bidalertdate");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(fsp);
    }

    public static void updateBidStatus() {
        DynamicObject[] bidBills;
        QFilter bidStatus = new QFilter("bidstatus", "=", (Object)BidStatusEnum.ENROLMENT.getVal());
        QFilter openDateStatus = new QFilter("enrolldate", "<=", (Object)TimeServiceHelper.now());
        for (DynamicObject bidBill : bidBills = BusinessDataServiceHelper.load((String)"sou_bidbill", (String)"bidstatus", (QFilter[])new QFilter[]{bidStatus, openDateStatus})) {
            bidBill.set("bidstatus", (Object)BidStatusEnum.DEADLINE.getVal());
        }
        SaveServiceHelper.save((DynamicObject[])bidBills);
    }

    public static void updateSupEntryNotBiddingStatus(DynamicObject bidBill) {
        DynamicObjectCollection quoEntryCol = bidBill.getDynamicObjectCollection(QUOENTRY);
        DynamicObjectCollection supQuoEntryCol = bidBill.getDynamicObjectCollection(SUPQUOENTRY);
        BigDecimal cashDeposit = bidBill.getBigDecimal("cashdeposit");
        HashSet<String> quoSet = new HashSet<String>();
        for (DynamicObject quoEntry : quoEntryCol) {
            quoSet.add(quoEntry.getString("quotesupplier.id"));
        }
        for (DynamicObject supQuoEntry : supQuoEntryCol) {
            String supentrystatus = supQuoEntry.getString("supentrystatus");
            String supplierId = supQuoEntry.getString("entrysupplier.id");
            boolean isNotBidding = !quoSet.contains(supplierId) && (BigDecimal.ZERO.compareTo(cashDeposit) == 0 && (SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus) || SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus)) || SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus));
            if (!isNotBidding) continue;
            supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.NOTBIDDING.getVal());
        }
    }

    public static void openBidHall(String sourceBillKey, IFormView view, DynamicObject bidBill, CloseCallBack cb) {
        if (null == bidBill) {
            return;
        }
        String bidStatus = bidBill.getString("bidstatus");
        boolean autoConfirm = bidBill.getBoolean("autoconfirm");
        StringBuilder sb = new StringBuilder();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)bidBill.getPkValue(), sourceBillKey, "sou_bidhall")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709[\u7ade\u4ef7\u5927\u5385(\u53d1\u8d77\u65b9)]\u7684[\u67e5\u8be2]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"SouBidBillUtil_10", (String)"scm-sou-common", (Object[])new Object[0]));
            return;
        }
        if (autoConfirm && (BidStatusEnum.CONFIRMED.compareTo((Enum)BidStatusEnum.fromVal((String)bidStatus)) > 0 || BidStatusEnum.PAUSED.getVal().equals(bidStatus))) {
            sb.append(ResManager.loadKDString((String)"\u81ea\u52a8\u5b9a\u6807\u7684\u9879\u76ee\u5728\u5b9a\u6807\u524d\u4e0d\u80fd\u67e5\u770b\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillUtil_5", (String)"scm-sou-common", (Object[])new Object[0]));
            view.showMessage(ResManager.loadKDString((String)"\u81ea\u52a8\u5b9a\u6807\u7684\u9879\u76ee\u5728\u5b9a\u6807\u524d\u4e0d\u80fd\u67e5\u770b\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillUtil_5", (String)"scm-sou-common", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return;
        }
        if (bidStatus.equals(BidStatusEnum.ENROLMENT.getVal()) || bidStatus.equals(BidStatusEnum.DEADLINE.getVal())) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u8d44\u8d28\u5ba1\u6838\u3001\u6536\u4fdd\u8bc1\u91d1\uff0c\u4ee5\u53ca\u7ade\u4ef7\u542f\u52a8\u540e\u65b9\u80fd\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillUtil_6", (String)"scm-sou-common", (Object[])new Object[0]));
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u62a5\u540d\u4e2d\u6216\u62a5\u540d\u622a\u6b62\uff0c\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillUtil_7", (String)"scm-sou-common", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return;
        }
        if (bidStatus.equals(BidStatusEnum.BEENEXAMINED.getVal())) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u6536\u53d6\u4fdd\u8bc1\u91d1\u6216\u8005\u7ade\u4ef7\u542f\u52a8\u540e\u65b9\u80fd\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillUtil_8", (String)"scm-sou-common", (Object[])new Object[0]));
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u5df2\u8d44\u5ba1\uff0c\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillUtil_9", (String)"scm-sou-common", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("bidBillId", bidBill.getPkValue());
        String quotemode = bidBill.getString("quotemode");
        if ("1".equals(quotemode)) {
            view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_bidhall", paramMap, (CloseCallBack)cb, (ShowType)ShowType.MainNewTabPage));
        } else {
            view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_bidhallbyentry", paramMap, (CloseCallBack)cb, (ShowType)ShowType.MainNewTabPage));
        }
    }

    public static void updateSupplierInfo(DynamicObject bidBill) {
        if ("2".equals(bidBill.getString("quotemode"))) {
            SouBidBillUtil.confirmBidEntryQuote(bidBill, false);
        } else {
            Map<String, BigDecimal> supQuoAmtMap = SouBidBillUtil.getNewestSupQuoAmtMap(bidBill);
            List<Map.Entry<String, BigDecimal>> supQuoAmtList = SouBidBillUtil.rankSupQuoAmt(supQuoAmtMap);
            if (supQuoAmtList.size() > 0) {
                SouBidBillUtil.rankSup(bidBill, supQuoAmtList);
            }
            bidBill.set("bidnum", (Object)SouBidBillUtil.countQuoSup(bidBill));
        }
    }
}

