/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.BizPartnerUtil;

public class SouPermUtil {
    private static String HASRIGHT = "hasRight";
    private static String TRUE = "1";
    private static String FALSE = "0";
    private static String MSG = "msg";

    public static boolean hasSouBillViewRightForOrg(Long sourceBillPkId, String sourceBillKey, String targetBillKey) {
        return SouPermUtil.hasBillViewRightForOrg(sourceBillPkId, sourceBillKey, targetBillKey, "SE7SAP7HR2N");
    }

    public static boolean hasBillViewRightForOrg(String entityId, long pk, MainEntityType mainEntityType) {
        String mainOrgField = mainEntityType.getMainOrg();
        DynamicObject dyn = QueryServiceHelper.queryOne((String)entityId, (String)(mainOrgField + ".id"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pk)});
        if (null == dyn) {
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"SouPermUtil_0", (String)"scm-sou-common", (Object[])new Object[]{entityId});
            throw new KDBizException(msg);
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appId = mainEntityType.getAppId();
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)dyn.getLong(mainOrgField + ".id"), (String)appId, (String)entityId, (String)"47150e89000000ac");
        return 1 == result;
    }

    public static Map<String, String> checkBillViewRightForOrg(Map<String, HashSet<Long>> entitiyIdMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (entitiyIdMap.isEmpty()) {
            resultMap.put(HASRIGHT, TRUE);
            resultMap.put(MSG, ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"SouPermUtil_1", (String)"scm-sou-common", (Object[])new Object[0]));
            return resultMap;
        }
        StringBuilder sb = new StringBuilder();
        int[] hasNoRightCount = new int[]{0};
        ArrayList emptyEntityIds = new ArrayList();
        entitiyIdMap.forEach((entityId, pkSet) -> {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (!pkSet.isEmpty()) {
                pkSet.removeIf(noticeId -> !SouPermUtil.hasBillViewRightForOrg(entityId, noticeId, mainEntityType));
                if (pkSet.isEmpty()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u641c\u7d22\u5230\u4e86\u5173\u8054\u7684\u201c%s\u201d\uff0c\u4f46\u672a\u88ab\u6388\u4e88\u67e5\u770b\u6743\u3002", (String)"SouPermUtil_2", (String)"scm-sou-common", (Object[])new Object[0]), mainEntityType.getDisplayName().toString());
                    sb.append(msg).append("\n\t");
                    hasNoRightCount[0] = hasNoRightCount[0] + 1;
                    emptyEntityIds.add(entityId);
                } else {
                    entitiyIdMap.put((String)entityId, (HashSet<Long>)pkSet);
                    resultMap.put(HASRIGHT, TRUE);
                }
            }
        });
        if (hasNoRightCount[0] == entitiyIdMap.size()) {
            resultMap.put(HASRIGHT, FALSE);
            resultMap.put(MSG, sb.toString());
        }
        for (String entityId2 : emptyEntityIds) {
            entitiyIdMap.remove(entityId2);
        }
        return resultMap;
    }

    public static Map<String, String> hasBillViewRight(List<String> entityIds) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        StringBuilder sb = new StringBuilder();
        for (String entityId : entityIds) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (PermissionServiceHelper.hasSpecificPerm((long)userId, (String)mainEntityType.getAppId(), (String)entityId, (String)"47150e89000000ac")) {
                resultMap.put(HASRIGHT, TRUE);
                continue;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouPermUtil_3", (String)"scm-sou-common", (Object[])new Object[0]), mainEntityType.getDisplayName().toString());
            sb.append(msg).append("\n\t");
        }
        if (!TRUE.equals(resultMap.get(HASRIGHT))) {
            resultMap.put(HASRIGHT, FALSE);
            resultMap.put(MSG, sb.toString());
        }
        return resultMap;
    }

    public static boolean hasBillViewRightForOrg(Long sourceBillPkId, String sourceBillKey, String targetBillKey, String appId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillKey);
        String mainOrgField = mainEntityType.getMainOrg();
        DynamicObject dyn = QueryServiceHelper.queryOne((String)sourceBillKey, (String)(mainOrgField + ".id"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillPkId)});
        if (dyn != null) {
            int i = PermissionServiceHelper.checkPermission((Long)Long.valueOf(RequestContext.get().getUserId()), (Long)dyn.getLong(mainOrgField + ".id"), (String)appId, (String)targetBillKey, (String)"47150e89000000ac");
            return 1 == i;
        }
        return false;
    }

    public static boolean validateRule(IFormView view, DynamicObject inquiry, Map<Integer, Integer> map, Map<Long, Integer> roleInfoMap) {
        boolean hasRule = true;
        if (view != null) {
            DynamicObject inquiryBill = SouPermUtil.getSouInquiryBill(view);
            if (null == inquiryBill) {
                view.showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be2\u4ef7\u5355\u3002", (String)"SouPermUtil_4", (String)"scm-sou-common", (Object[])new Object[0]));
                return false;
            }
            boolean checkperm = inquiryBill.getBoolean("checkperm");
            if (!checkperm) {
                return true;
            }
            int i = 0;
            DynamicObjectCollection info = inquiry.getDynamicObjectCollection("entrysupplier");
            StringBuilder errors = new StringBuilder();
            Integer ruleId = null;
            if (info != null && roleInfoMap != null) {
                for (DynamicObject dynamicObject : info) {
                    long supplierId = dynamicObject.getLong("suppliernumber_id");
                    if (supplierId == 0L || map != null && !map.containsKey(++i - 1)) continue;
                    ruleId = roleInfoMap.get(supplierId);
                    if (ruleId != null && ruleId.equals(0)) {
                        errors.append(String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u7b2c%1$s\u884c\uff1a%2$s\uff0c\u6ca1\u6709%3$s\u7684\u7684\u8be2\u4ef7\u67e5\u8be2\u6743\u9650\u65f6\u5c06\u65e0\u6cd5\u67e5\u770b\u672c\u8be2\u4ef7\u5355\uff0c\u8bf7\u5148\u7ed9\u4f9b\u5e94\u5546\u7528\u6237\u6388\u4e88\u5bf9\u5e94\u7ec4\u7ec7\u6743\u9650\u3002", (String)"SouPermUtil_5", (String)"scm-sou-common", (Object[])new Object[0]), i, dynamicObject.getDynamicObject("suppliernumber").getString("name"), inquiryBill.getString("org.name"))).append('\n');
                        hasRule = false;
                    }
                    Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)supplierId);
                    HashSet<Long> set = new HashSet<Long>(1);
                    set.add(bizPartnerId);
                    List supUserIds = BizPartnerUtil.getSupEnableUserIdsByBizPartner(set);
                    boolean flag = false;
                    if (supUserIds.size() > 0) {
                        for (Long supUserId : supUserIds) {
                            ruleId = PermissionServiceHelper.checkPermission((Long)supUserId, (Long)inquiryBill.getLong("org.id"), (String)"SE7/UZFDVIE", (String)"quo_inquiry", (String)"47150e89000000ac");
                            if (!ruleId.equals(1)) continue;
                            roleInfoMap.put(supplierId, ruleId);
                            flag = true;
                            break;
                        }
                    }
                    if (flag) continue;
                    errors.append(String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u7b2c%1$s\u884c\uff1a%2$s\uff0c\u6ca1\u6709%3$s\u7684\u7684\u8be2\u4ef7\u67e5\u8be2\u6743\u9650\u65f6\u5c06\u65e0\u6cd5\u67e5\u770b\u672c\u8be2\u4ef7\u5355\uff0c\u8bf7\u5148\u7ed9\u4f9b\u5e94\u5546\u7528\u6237\u6388\u4e88\u5bf9\u5e94\u7ec4\u7ec7\u6743\u9650\u3002", (String)"SouPermUtil_5", (String)"scm-sou-common", (Object[])new Object[0]), i, dynamicObject.getDynamicObject("suppliernumber").getString("name"), inquiryBill.getString("org.name"))).append('\n');
                    hasRule = false;
                }
            }
            if (!hasRule) {
                view.showTipNotification(errors.toString());
            }
        } else {
            hasRule = false;
        }
        return hasRule;
    }

    public static boolean validateBizpartner(DynamicObject dataEntity, IFormView view) {
        boolean checkOk = true;
        DynamicObjectCollection entrysupplier = dataEntity.getDynamicObjectCollection("entrysupplier");
        HashMap<Long, ArrayList<String>> bizpartnerMap = new HashMap<Long, ArrayList<String>>(8);
        for (DynamicObject entry : entrysupplier) {
            long bizpartnerid = entry.getLong("suppliernumber.bizpartner.id");
            ArrayList<String> suppliers = (ArrayList<String>)bizpartnerMap.get(bizpartnerid);
            if (suppliers == null) {
                suppliers = new ArrayList<String>(8);
                suppliers.add(entry.getString("suppliernumber.name"));
                bizpartnerMap.put(bizpartnerid, suppliers);
                continue;
            }
            suppliers.add(entry.getString("suppliernumber.name"));
        }
        StringBuilder message = new StringBuilder();
        for (Map.Entry mapentry : bizpartnerMap.entrySet()) {
            ArrayList value = (ArrayList)mapentry.getValue();
            if (value.size() <= 1) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4f9b\u5e94\u5546\u540c\u5c5e\u4e00\u4e2a\u5546\u52a1\u4f19\u4f34\uff1a%1s,\u5b58\u5728\u4e32\u6807\u98ce\u9669,\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u786e\u8ba4\u3002", (String)"SouPermUtil_6", (String)"scm-sou-common", (Object[])new Object[0]), value)).append('\n');
        }
        if (!StringUtils.isEmpty((String)message.toString())) {
            view.showTipNotification(message.toString());
            checkOk = false;
        }
        return checkOk;
    }

    public static DynamicObject getSouInquiryBill(IFormView view) {
        if (view != null) {
            FormShowParameter parameter = view.getFormShowParameter();
            Map param = parameter.getCustomParams();
            Long billId = (Long)param.get("billid");
            if (billId == null) {
                return null;
            }
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"sou_inquiry");
            return billObj;
        }
        return null;
    }

    private SouPermUtil() {
    }
}

