/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BizPartnerUtil;

public class SouSendMessageUtil {
    private static Log log = LogFactory.getLog(SouSendMessageUtil.class);
    private static final String TITLE = "title";
    private static final String CONTENT = "content";

    public static void sendMessage(Set<Long> bizPartnerPkIds, List<Long> userIds, Map<String, String> messageParams) {
        List<Long> ids = SouSendMessageUtil.validateUser(bizPartnerPkIds, userIds, messageParams);
        SouSendMessageUtil.startSendMessageToWeb(ids, messageParams);
    }

    private static void startSendMessageToWeb(List<Long> userIds, Map<String, String> messageParams) {
        if (ApiConfigUtil.hasOldMsgConfig() && !userIds.isEmpty()) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTitle(messageParams.get(TITLE));
            String content = messageParams.get(CONTENT);
            log.info(content);
            messageInfo.setContent(content);
            messageInfo.setSignleEmail(true);
            messageInfo.setPubaccNumber(messageParams.getOrDefault("pubaccNumber", "systempubacc"));
            messageInfo.setMessageType(messageParams.getOrDefault("messageType", "message"));
            messageInfo.setSenderId(Long.valueOf(messageParams.getOrDefault("senderId", RequestContext.get().getUserId())));
            messageInfo.setSenderName(messageParams.getOrDefault("senderName", RequestContext.get().getUserName()));
            if ("true".equals(messageParams.get("hasBizDataId"))) {
                messageInfo.setBizDataId(Long.valueOf(messageParams.get("bizDataId")));
                messageInfo.setEntityNumber(messageParams.get("entityNumber"));
                messageInfo.setTplScene(messageParams.get("tplScene"));
            }
            messageInfo.setUserIds(userIds);
            if ("true".equals(messageParams.get("toMob"))) {
                messageInfo.setMobContentUrl(messageParams.get("mobContentUrl"));
                log.info("mobContentUrl:" + messageParams.get("mobContentUrl"));
            }
            String url = messageParams.get("contentUrl");
            log.info(url);
            messageInfo.setContentUrl(url);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private static List<Long> validateUser(Set<Long> bizPartnerPkIds, List<Long> userIds, Map<String, String> messageParams) {
        DynamicObjectCollection enableUserIds = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("id", "in", userIds)});
        List<Long> validUserIds = new ArrayList<Long>(enableUserIds.size());
        for (DynamicObject enableUserId : enableUserIds) {
            validUserIds.add(enableUserId.getLong("id"));
        }
        if (!validUserIds.isEmpty()) {
            List userId = BizPartnerUtil.getSupUserIdsByBizPartner(bizPartnerPkIds);
            validUserIds.retainAll(userId);
        }
        if (validUserIds.isEmpty()) {
            messageParams.put(TITLE, messageParams.getOrDefault("failMsgTitle", messageParams.get(TITLE)));
            messageParams.put(CONTENT, messageParams.getOrDefault("failMsgContent", messageParams.get(CONTENT)));
            validUserIds = BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizPartnerPkIds);
        }
        return validUserIds;
    }

    private SouSendMessageUtil() {
    }
}

