/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.JacksonJsonUtil;

public class BidBillCfmToSupplierPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("entryentity.qty");
        filds.add("entryentity.taxamount");
        filds.add("entryentity.taxrate");
        filds.add("entryentity.srcbillid");
        filds.add("entryentity.srcentryid");
        filds.add("entryentity.material");
        filds.add("entryentity.material.number");
        filds.add("entryentity.unit");
        filds.add("entryentity.isUpdateASInfo");
        filds.add("entryentity.wintaxprice");
        filds.add("entryentity.winprice");
        filds.add("entryentity.winsupplier");
        filds.add("entryentity.seq");
        filds.add("org");
        filds.add("paycond");
        filds.add("curr");
        filds.add("loccurr");
        filds.add("person");
        filds.add("taxtype");
        filds.add("settletype");
        filds.add("billno");
        filds.add("supplier");
        filds.add("billstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        String entityType = null;
        if (objs.length == 0) {
            return;
        }
        entityType = objs[0].getDataEntityType().getName();
        DynamicObject obj = null;
        DynamicObjectCollection entrys = null;
        DynamicObject entry = null;
        HashMap<String, DynamicObject> id_entryMap = new HashMap<String, DynamicObject>();
        boolean is2Supplier = true;
        for (int i = 0; i < objs.length; ++i) {
            obj = objs[i];
            entrys = obj.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entrys.size(); ++j) {
                entry = (DynamicObject)entrys.get(j);
                id_entryMap.put(String.valueOf(entry.getLong("id")), entry);
                if (entry.getBoolean("isUpdateASInfo")) continue;
                is2Supplier = false;
            }
        }
        if (is2Supplier) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4f9b\u8d27\u6e05\u5355\uff0c\u4e0d\u5141\u8bb8\u591a\u6b21\u751f\u6210\u3002", (String)"BidBillCfmToSupplierPlugin_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Map<String, Map<String, Object>> billInfoMap = this.getBillParam(objs);
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("data", billInfoMap);
            this.sendData(param, entityType, e, id_entryMap);
            SaveServiceHelper.save((DynamicObject[])objs);
        }
    }

    private void sendData(Map<String, Object> param, String entityType, BeforeOperationArgs e, Map<String, DynamicObject> id_entryMap) {
        if (param.isEmpty()) {
            return;
        }
        param.put("billtype", entityType);
        param.put("action", "toOrder");
        param.put("code", "200");
        if (entityType.equals("sou_bidbillcfm")) {
            String msg = ApiUtil.souCompareUpdateSupp(param);
            if (!msg.isEmpty()) {
                Map map = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
                boolean isSuccess = true;
                StringBuilder errorStr = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    DynamicObject dyns;
                    Map msgmap = (Map)entry.getValue();
                    String status = msgmap.get("status").toString();
                    if ("200".equals(status)) {
                        dyns = id_entryMap.get(entry.getKey());
                        if (dyns == null) continue;
                        dyns.set("isUpdateASInfo", (Object)"1");
                        continue;
                    }
                    isSuccess = false;
                    dyns = id_entryMap.get(entry.getKey());
                    if (null == msgmap.get("error")) continue;
                    if (null != dyns) {
                        errorStr.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c{1}", (String)"BidBillCfmToSupplierPlugin_1", (String)"scm-sou-opplugin", (Object[])new Object[0]), dyns.getInt("seq"), msgmap.get("error").toString())).append('\n');
                        continue;
                    }
                    errorStr.append(msgmap.get("error")).append('\n');
                }
                if (!isSuccess) {
                    if (errorStr.length() > 0) {
                        e.setCancelMessage(errorStr.toString());
                    } else {
                        e.setCancelMessage(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBillCfmToSupplierPlugin_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    }
                    e.setCancel(true);
                }
            } else {
                e.setCancelMessage(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u5f02\u5e38", (String)"BidBillCfmToSupplierPlugin_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private Map<String, Map<String, Object>> getBillParam(DynamicObject[] objs) {
        HashMap<String, Map<String, Object>> billMap = new HashMap<String, Map<String, Object>>((int)((double)objs.length / 0.75));
        Map<Object, Object> detailMap = new HashMap();
        for (DynamicObject obj : objs) {
            detailMap = this.getParam(obj);
            String billIdStr = String.valueOf(obj.getPkValue());
            billMap.put(billIdStr, detailMap);
        }
        return billMap;
    }

    private Map<String, Object> getParam(DynamicObject bill) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection("entryentity");
        this.setHeadParam(paramMap, bill);
        HashMap billMap = new HashMap();
        int index = 1;
        for (DynamicObject entryCol : entryCols) {
            String entryIdStr = String.valueOf(entryCol.getPkValue());
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            DynamicObject supplier = entryCol.getDynamicObject("winsupplier");
            if (supplier == null) continue;
            entryMap.put("supplier", supplier == null ? "" : supplier.getString("number"));
            entryMap.put("confirmqty", entryCol.get("qty"));
            entryMap.put("unit", entryCol.getDynamicObject("unit").getString("number"));
            entryMap.put("material", entryCol.getDynamicObject("material").getString("number"));
            entryMap.put("price", entryCol.get("wintaxprice"));
            entryMap.put("confirmtaxprice", entryCol.get("wintaxprice"));
            entryMap.put("taxrate", entryCol.get("taxrate"));
            entryMap.put("seq", String.valueOf(index));
            entryMap.put("number", bill.getString("billno"));
            ++index;
            billMap.put(entryIdStr, entryMap);
        }
        paramMap.put("entry", billMap);
        return paramMap;
    }

    private void setHeadParam(Map<String, Object> headMap, DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        headMap.put("purorg", org == null ? "" : org.getString("number"));
        DynamicObject curr = bill.getDynamicObject("curr");
        headMap.put("settlecurr", curr == null ? "" : curr.getString("number"));
        DynamicObject loccurr = bill.getDynamicObject("loccurr");
        headMap.put("localcurr", loccurr == null ? "" : loccurr.getString("number"));
        DynamicObject payCond = bill.getDynamicObject("paycond");
        headMap.put("paycond", payCond == null ? "" : payCond.getString("number"));
        DynamicObject person = bill.getDynamicObject("person");
        headMap.put("purperson", person == null ? "" : person.getString("number"));
        String taxType = bill.getString("taxtype");
        headMap.put("taxtype", taxType);
        DynamicObject settleType = bill.getDynamicObject("settletype");
        headMap.put("settletype", settleType == null ? "" : settleType.getString("number"));
    }

    private DynamicObject[] querySrcBillInfo(DynamicObjectCollection entryCol, String entryEntity) {
        DynamicObject[] dynamicObjects = null;
        String selectFields = "id,billno,materialentry.id,materialentry.srcbillid,materialentry.srcentryid";
        HashMap paramMap = new HashMap();
        HashMap<String, Set<Object>> idMap = new HashMap<String, Set<Object>>();
        idMap.put("in", this.getIdList(entryCol, entryEntity));
        paramMap.put("id", idMap);
        dynamicObjects = ORMUtil.query((String)"sou_quote", (String)selectFields, paramMap);
        return dynamicObjects;
    }

    private Set<Object> getIdList(DynamicObjectCollection entryCol, String entryEntity) {
        HashSet<Object> idList = new HashSet<Object>();
        for (DynamicObject entry : entryCol) {
            Object sb = null;
            Object sbi = null;
            sb = entry.get("srcbillid");
            sbi = entry.get("srcentryid");
            if (sbi == null || sbi.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            Long srcBillId = Long.valueOf(sb.toString());
            idList.add(srcBillId);
        }
        return idList;
    }

    private DynamicObject getSrcBillEntry(DynamicObject[] srcBillObjs, Object srcBillId, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String billId = String.valueOf(srcBill.getPkValue());
            if (!srcBillId.equals(billId)) continue;
            DynamicObjectCollection entryCols = srcBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryCol : entryCols) {
                String billEntryId = String.valueOf(entryCol.getPkValue());
                if (!srcBillEntryId.equals(billEntryId)) continue;
                return entryCol;
            }
        }
        return entry;
    }
}

