/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ApiConfigUtil;

public class SouBizpersonSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("publisher");
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("phone");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if (ApiConfigUtil.hasEASConfig() && !ApiConfigUtil.hasCQScmConfig()) {
            HashSet<String> publishers = new HashSet<String>();
            HashMap<Long, String> billMap = new HashMap<Long, String>();
            HashMap<String, String> publisherMap = new HashMap<String, String>();
            List validExtDataEntities = e.getValidExtDataEntities();
            for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
                DynamicObject dynamicObject = validExtDataEntity.getDataEntity();
                long billId = dynamicObject.getLong("id");
                String publisher = dynamicObject.getString("publisher");
                if (!StringUtils.isNotEmpty((CharSequence)publisher)) continue;
                if (publisher.contains("_")) {
                    String[] str = publisher.split("_");
                    publisher = str[str.length - 1];
                }
                publishers.add(publisher);
                billMap.put(billId, publisher);
            }
            DynamicObjectCollection personDyns = QueryServiceHelper.query((String)"pur_bizperson", (String)"id,user,name,group,phone", (QFilter[])new QFilter[]{new QFilter("name", "in", publishers).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")}, (String)"id");
            if (personDyns != null && !personDyns.isEmpty()) {
                for (DynamicObject personDyn : personDyns) {
                    String name = personDyn.getString("name");
                    long personId = personDyn.getLong("id");
                    String phone = personDyn.getString("phone");
                    publisherMap.put(name, personId + "_" + phone);
                }
                for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
                    String personInfo;
                    DynamicObject dynamicObject = validExtDataEntity.getDataEntity();
                    long billId = dynamicObject.getLong("id");
                    String publisher = (String)billMap.get(billId);
                    if (publisher == null || !StringUtils.isNotEmpty((CharSequence)(personInfo = (String)publisherMap.get(publisher)))) continue;
                    String[] infos = personInfo.split("_");
                    dynamicObject.set("person", (Object)infos[0]);
                    if (infos.length <= 1) continue;
                    dynamicObject.set("phone", (Object)infos[1]);
                }
            }
        }
    }
}

