/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.helper.pmapply.CompareFactory;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.sou.opplugin.validator.SouCompareValidator;

public class SouCompareUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("inquiryno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("materialentry.material");
        e.getFieldKeys().add("materialentry.supplier");
        e.getFieldKeys().add("materialentry.qty");
        e.getFieldKeys().add("materialentry.price");
        e.getFieldKeys().add("materialentry.taxprice");
        e.getFieldKeys().add("materialentry.srcbillid");
        e.getFieldKeys().add("materialentry.srcentryid");
        e.getFieldKeys().add("materialentry.pobillno");
        e.getFieldKeys().add("materialentry.pcbillno");
        e.getFieldKeys().add("materialentry.prentryid");
        e.getFieldKeys().add("materialentry.prbillid");
        e.getFieldKeys().add("materialentry.note");
        e.getFieldKeys().add("materialentry.taxrateid");
        e.getFieldKeys().add("billdate");
        e.getFieldKeys().add("isupdateasinfo");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List dataEntity = e.getValidExtDataEntities();
        StringBuilder entryResult = new StringBuilder();
        for (ExtendedDataEntity extDataEntity : dataEntity) {
            DynamicObject obj = extDataEntity.getDataEntity();
            DynamicObjectCollection materialCol = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialCol) {
                String poBillno = entry.getString("pobillno");
                String pcbillno = entry.getString("pcbillno");
                if (poBillno != null && poBillno.trim().length() > 0 && !entryResult.toString().contains(poBillno)) {
                    entryResult.append(poBillno).append('\n');
                }
                if (pcbillno == null || pcbillno.trim().length() <= 0 || entryResult.toString().contains(pcbillno)) continue;
                entryResult.append(pcbillno).append(' ');
            }
            if (entryResult.toString().length() <= 0) continue;
            e.cancel = true;
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\u5355\u636e\uff0c%1$s\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SouCompareUnAuditOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0]), entryResult));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] compareBillObs = e.getDataEntities();
        switch (operationKey) {
            case "unaudit": {
                ArrayList<String> inquiryBillNoList = new ArrayList<String>();
                HashMap<String, ArrayList<String>> quoteBillMap = new HashMap<String, ArrayList<String>>();
                ArrayList<Long> quoteBillIdList = new ArrayList<Long>();
                for (DynamicObject compareBill : compareBillObs) {
                    String inquiryBillNo = compareBill.getString("inquiryno");
                    if (!inquiryBillNoList.contains(inquiryBillNo) && StringUtils.isNotBlank((CharSequence)inquiryBillNo)) {
                        inquiryBillNoList.add(inquiryBillNo);
                    }
                    DynamicObjectCollection entryCols = compareBill.getDynamicObjectCollection("materialentry");
                    ArrayList<String> entryIdList = null;
                    for (DynamicObject entryCol : entryCols) {
                        String srcBillId = entryCol.getString("srcbillid");
                        if (!quoteBillIdList.contains(srcBillId) && StringUtils.isNotBlank((CharSequence)srcBillId)) {
                            quoteBillIdList.add(Long.valueOf(srcBillId));
                        }
                        String srcentryid = entryCol.getString("srcentryid");
                        entryIdList = (ArrayList<String>)quoteBillMap.get(srcBillId);
                        if (entryIdList != null) {
                            entryIdList.add(srcentryid);
                            continue;
                        }
                        entryIdList = new ArrayList<String>();
                        entryIdList.add(srcentryid);
                        quoteBillMap.put(srcBillId, entryIdList);
                    }
                    quoteBillIdList.clear();
                }
                if (inquiryBillNoList.size() <= 0) break;
                DynamicObject[] souQuoteObjs = InquiryUtil.getQuoteBillByInquiryBillNo(inquiryBillNoList);
                this.updateQuoteBill(souQuoteObjs);
                DynamicObject[] souInquiryObjs = InquiryUtil.getInquiryBillByBillNo(inquiryBillNoList);
                this.updateInquiry(souInquiryObjs);
                if (ApiConfigUtil.hasEASConfig() || !ApiConfigUtil.hasCQScmConfig()) break;
                CompareFactory pmApplyStatusUpdateFactory = new CompareFactory();
                PmApplyStatusUpdate pmApplyStatusUpdate = pmApplyStatusUpdateFactory.create("sou_compare", e.getOperationKey(), "A", e.getDataEntities());
                pmApplyStatusUpdate.execute();
                break;
            }
        }
    }

    private void updateQuoteBill(DynamicObject[] souQuoteBillObjs) {
        if (souQuoteBillObjs.length > 0) {
            for (DynamicObject souQuoteBill : souQuoteBillObjs) {
                DynamicObjectCollection entryCols = souQuoteBill.getDynamicObjectCollection("materialentry");
                souQuoteBill.set("bizstatus", (Object)SupInquiryStatusEnum.OPENEDTHEBID.getVal());
                for (DynamicObject entryCol : entryCols) {
                    entryCol.set("result", null);
                    entryCol.set("cfmqty", (Object)0);
                    entryCol.set("cfmprice", (Object)0);
                    entryCol.set("cfmtaxprice", (Object)0);
                    entryCol.set("cfmnote", (Object)"");
                    entryCol.set("cfmtaxrateid", null);
                    entryCol.set("cfmtaxrate", null);
                }
            }
            SaveServiceHelper.save((DynamicObject[])souQuoteBillObjs);
        }
    }

    private void updateInquiry(DynamicObject[] souInquiryObjs) {
        for (DynamicObject souInquiry : souInquiryObjs) {
            souInquiry.set("bizstatus", (Object)BizStatusEnum.OPENEDTHEBID.getVal());
            souInquiry.set("audit", null);
            ArrayList<String> billNoList = new ArrayList<String>(1);
            billNoList.add(souInquiry.getString("billno"));
            DynamicObject[] quoBills = InquiryUtil.getQuoteBillByInquiryBillNo(billNoList);
            HashMap<String, String> supplierQuoTurnsMap = new HashMap<String, String>((int)((double)quoBills.length / 0.75));
            for (DynamicObject quoBill : quoBills) {
                String quoTurns = quoBill.getString("turns");
                supplierQuoTurnsMap.put(quoBill.getString("supplier.id"), String.valueOf(quoTurns));
            }
            DynamicObjectCollection quoteSupEntryCols = souInquiry.getDynamicObjectCollection("entryentity");
            for (DynamicObject quoteSupEntryCol : quoteSupEntryCols) {
                String supentrystatus = quoteSupEntryCol.getString("supentrystatus");
                String supplierId = quoteSupEntryCol.getString("supplier.id");
                if (SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal().equals(supentrystatus) || !SupInquiryStatusEnum.HAVEADOPTED.getVal().equals(supentrystatus) && !SupInquiryStatusEnum.NOTADOPTED.getVal().equals(supentrystatus) && !SupInquiryStatusEnum.PARTICALADOPTION.getVal().equals(supentrystatus) || !StringUtils.equals((CharSequence)quoteSupEntryCol.getString("entryturns"), (CharSequence)((CharSequence)supplierQuoTurnsMap.get(supplierId)))) continue;
                quoteSupEntryCol.set("supentrystatus", (Object)SupInquiryStatusEnum.OPENEDTHEBID.getVal());
            }
        }
        SaveServiceHelper.save((DynamicObject[])souInquiryObjs);
    }

    private DynamicObject[] getSouQuoteBillByBillId(List<Object> billIdList) {
        HashMap params = new HashMap(2);
        HashMap<String, Object[]> idMap = new HashMap<String, Object[]>(1);
        idMap.put("in", billIdList.toArray(new Object[0]));
        params.put("id", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_quote", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_quote", (String)"materialentry", (boolean)false);
        return ORMUtil.load((String)"sou_quote", (String)selectFields, params);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouCompareValidator());
    }
}

