/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.helper.pmapply.InquiryFactory;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.InquiryUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import kd.scm.sou.opplugin.validator.SouInquiryAuditValidator;

public class SouInquiryAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SouInquiryAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizstatus");
        fieldKeys.add("billno");
        fieldKeys.add("billdate");
        fieldKeys.add("org");
        fieldKeys.add("supscope");
        fieldKeys.add("entryentity.supplier");
        fieldKeys.add("entryentity.deadline");
        fieldKeys.add("entryentity.entryturns");
        fieldKeys.add("billstatus");
        fieldKeys.add("enddate");
        fieldKeys.add("entryentity");
        fieldKeys.add("srcbilltype");
        fieldKeys.add("srcbillid");
        fieldKeys.add("srcentryid");
        fieldKeys.add("prbillid");
        fieldKeys.add("prentryid");
        fieldKeys.add("datefrom");
        fieldKeys.add("dateto");
        fieldKeys.add("delidate");
        fieldKeys.add("entrylog");
        fieldKeys.add("entrylog.turns_log");
        fieldKeys.add("entrylog.handler");
        fieldKeys.add("entrylog.handletime");
        fieldKeys.add("entrylog.note_log");
        fieldKeys.add("entrylog.seq");
        fieldKeys.add("entrylog.logdeadline");
        fieldKeys.add("entrylog.entrylogscope");
        fieldKeys.add("turns");
        fieldKeys.add("person");
        fieldKeys.add("creator");
        fieldKeys.add("entryentity.entryturns");
        fieldKeys.add("entryentity.entrycount");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            dynamicObject.set("billdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("bizstatus", (Object)BizStatusEnum.ENROLMENT.getVal());
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                String srcBillId = row.getString("srcbillid");
                String srcEntryId = row.getString("srcentryid");
                if (!row.getString("prbillid").isEmpty() && !row.getString("prentryid").isEmpty()) continue;
                row.set("prbillid", (Object)srcBillId);
                row.set("prentryid", (Object)srcEntryId);
            }
            DynamicObjectCollection supplierEntry = dynamicObject.getDynamicObjectCollection("entryentity");
            if (supplierEntry == null || !"2".equals(dynamicObject.getString("supscope"))) continue;
            Date endDate = dynamicObject.getDate("enddate");
            supplierEntry.forEach(info -> {
                InquirySupParticipateUtils.setSupEntryDeadLine((DynamicObject)info, (Date)endDate);
                info.set("entryturns", (Object)"1");
                info.set("entrycount", (Object)"1");
            });
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        this.billEntityType.getName();
        if ("audit".equalsIgnoreCase(operationKey)) {
            List selectedRows = e.getSelectedRows();
            DynamicObject[] objs = new DynamicObject[selectedRows.size()];
            int index = 0;
            for (ExtendedDataEntity extendedDataEntity : selectedRows) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                objs[index++] = dataEntity;
                String supscope = dataEntity.getString("supscope");
                if (!"2".equalsIgnoreCase(supscope)) continue;
                DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
                HashSet<Long> bizPartnerPks = new HashSet<Long>();
                for (DynamicObject row : entryCol) {
                    if (row.getDynamicObject("supplier") == null) continue;
                    InquirySupParticipateUtils.setSupEntryDeadLine((DynamicObject)row, (Date)dataEntity.getDate("enddate"));
                    row.set("entryturns", (Object)dataEntity.getString("turns"));
                    bizPartnerPks.add(row.getDynamicObject("supplier").getLong("bizpartner_id"));
                }
                this.beforeSendMessage(bizPartnerPks, dataEntity);
            }
            InquiryFactory pmApplyStatusUpdateFactory = new InquiryFactory();
            PmApplyStatusUpdate pmApplyStatusUpdate = pmApplyStatusUpdateFactory.create(this.billEntityType.getName(), e.getOperationKey(), "A", e.getDataEntities());
            pmApplyStatusUpdate.execute();
            InquiryUtil.logTurnsQuote((DynamicObject[])objs, (String)ResManager.loadKDString((String)"\u9996\u8f6e", (String)"SouInquiryAuditOp_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
        }
    }

    private void beforeSendMessage(Set<Long> bizPartnerPks, DynamicObject dataEntity) {
        List adminPks = BizPartnerUtil.getAdminSupUserIdsByBizPartner(bizPartnerPks);
        if (!adminPks.isEmpty()) {
            StringBuilder content = new StringBuilder();
            content.append(dataEntity.getDynamicObject("org").getString("name")).append(ResManager.loadKDString((String)"\u901a\u77e5\uff1a\u4f60\u6709\u8be2\u4ef7\u5355", (String)"SouInquiryAuditOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append(dataEntity.getString("billno")).append(ResManager.loadKDString((String)"\u5f85\u62a5\u4ef7\uff0c\u8bf7\u5904\u7406\u3002", (String)"SouInquiryAuditOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            StringBuilder mobUrl = new StringBuilder();
            String domainContextUrl = UrlService.getDomainContextUrl();
            mobUrl.append(domainContextUrl);
            mobUrl.append("/index.html?formId=quo_inquiry&pkId=").append(dataEntity.getPkValue()).append("&type=report");
            String accountId = RequestContext.get().getAccountId();
            if (accountId != null) {
                mobUrl.append('&').append("accountId=").append(accountId);
            }
            HashMap<String, String> msgParams = new HashMap<String, String>();
            DynamicObject person = dataEntity.getDynamicObject("person");
            if (person != null) {
                msgParams.put("senderId", String.valueOf(person.getPkValue()));
                msgParams.put("senderName", person.getString("name"));
            } else {
                DynamicObject creator = dataEntity.getDynamicObject("creator");
                msgParams.put("senderId", String.valueOf(creator.getPkValue()));
                msgParams.put("senderName", creator.getString("name"));
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u5df2\u751f\u6548\uff0c\u8bf7\u53ca\u65f6\u62a5\u4ef7\u3002", (String)"SouInquiryAuditOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            msgParams.put("content", content.toString());
            msgParams.put("toMob", "true");
            msgParams.put("hasBizDataId", "false");
            msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_inquiry" + "&pkId=" + dataEntity.getLong("id"));
            msgParams.put("mobContentUrl", mobUrl.toString());
            SouSendMessageUtil.sendMessage(bizPartnerPks, (List)adminPks, msgParams);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouInquiryAuditValidator());
    }
}

