/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.scm.sou.opplugin.SouInvalidNumUpgradePlugin;

public class SouInquiryMaterialUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SouInvalidNumUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("begin to upgrade inquiry entry materialname info!\n");
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append("end to upgrade inquiry entry materialname info!\n").toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            logger.error("upgrade inquiry entry materialname exception!\n", (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        ArrayList idList = new ArrayList(1024);
        try (DataSet ds = this.queryDataSet(new DBRoute(dbKey), "select FMaterialID from T_PUR_INQUIRYENTRY where fmaterialnametext = ' ' group by FMaterialID");){
            ds.forEach(row -> {
                if (row.get("FMaterialID") != null) {
                    idList.add(row.get("FMaterialID"));
                }
            });
        }
        pProcessInfo.append("need to update rows size : ").append(idList.size());
        List enabledLang = InteServiceHelper.getEnabledLang();
        String lang = "zh_CN";
        for (EnabledLang eblang : enabledLang) {
            if (eblang.isDefault == null || !eblang.isDefault.booleanValue()) continue;
            lang = eblang.number;
            break;
        }
        if (!idList.isEmpty()) {
            int pageSize = 200;
            int count = idList.size();
            int totalPages = count / pageSize;
            if (count % pageSize != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
                this.upateMaterialInfo(subIdList, dbKey, lang);
            }
        }
        pProcessInfo.append("update finish!");
        return true;
    }

    private void upateMaterialInfo(List<Object> subIdList, String dbKey, String lang) {
        String join = StringUtils.join((Object[])subIdList.toArray(), (String)",");
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fname fname,b.fid fid from T_BD_Material a inner join T_BD_Material_l b on a.fid=b.fid where flocaleid=? and a.fid in").append("(").append(join).append(")");
        HashMap paramMap = new HashMap();
        Object[] param = new Object[]{lang};
        try (DataSet ds = DB.queryDataSet((String)"SouInquiryMaterialUpgradePlugin", (DBRoute)new DBRoute("basedata"), (String)sb.toString(), (Object[])param);){
            ds.forEach(row -> {
                if (row.getLong("fid") != null) {
                    Object[] obj = new Object[]{row.getString("fname"), row.getLong("fid")};
                    paramMap.put(row.getLong("fid"), obj);
                }
            });
        }
        if (paramMap.size() > 0) {
            Collection values = paramMap.values();
            DB.executeBatch((DBRoute)new DBRoute(dbKey), (String)"update T_PUR_INQUIRYENTRY set fmaterialnametext = ? where FMaterialID = ?", new ArrayList(values));
        }
    }

    private DataSet queryDataSet(DBRoute dbRoute, String s) {
        return DB.queryDataSet((String)"SouInquiryMaterialUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)s, (Object[])null);
    }
}

