/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SouInvalidNumUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SouInvalidNumUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6bd4\u4ef7\u5355\u7684\u6709\u6548\u62a5\u4ef7\u4f9b\u5e94\u5546\u6570\u91cf\u5347\u7ea7", (String)"SouInvalidNumUpgradePlugin_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5b8c\u6bd5\u3002", (String)"SouMultiCurrUpgradePlugin_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"SouMultiCurrUpgradePlugin_3", (String)"scm-sou-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        int pageSize = 200;
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"sou_compare", (QFilter[])new QFilter[0], (String)"id", (int)Integer.MAX_VALUE);
        pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"SouMultiCurrUpgradePlugin_4", (String)"scm-sou-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
        int count = idList.size();
        int totalPages = count / pageSize;
        if (count % pageSize != 0) {
            ++totalPages;
        }
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            List subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
            if (subIdList.size() <= 0) continue;
            DynamicObject[] compareBills = BusinessDataServiceHelper.load((String)"sou_compare", (String)"id,billno,inquiryno,materialentry.srcbillid,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", subIdList)});
            HashSet<String> inquiryNoSet = new HashSet<String>(compareBills.length);
            for (DynamicObject dynamicObject : compareBills) {
                String inquiryNo = dynamicObject.getString("inquiryno");
                if (inquiryNo == null || "".equals(inquiryNo)) continue;
                inquiryNoSet.add(inquiryNo);
            }
            DynamicObjectCollection inquiryCollections = QueryServiceHelper.query((String)"sou_inquiry", (String)"id, billno, materialentry.id, materialentry.srcbillid, materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("billno", "in", inquiryNoSet)});
            DynamicObjectCollection quoteCollections = QueryServiceHelper.query((String)"quo_quote", (String)"id, billno, inquiryno, materialentry.id, materialentry.srcbillid, materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("inquiryno", "in", inquiryNoSet).and("materialentry.entrystatus", "=", (Object)"A").and("materialentry.price", ">", (Object)BigDecimal.ZERO).and("billstatus", "=", (Object)"C")}, (String)"materialentry.seq asc");
            HashMap<Long, Integer> sqlParms = new HashMap<Long, Integer>(compareBills.length * 20);
            for (DynamicObject compareBill3 : compareBills) {
                String billNo = compareBill3.getString("billno");
                String inquiryNo2 = compareBill3.getString("inquiryno");
                if (inquiryNo2 == null || "".equals(inquiryNo2)) {
                    pProcessInfo.append(billNo).append(ResManager.loadKDString((String)"\u8be5\u6bd4\u4ef7\u5355\u7684\u8be2\u4ef7\u5355\u53f7\u4e3a\u7a7a\u3002", (String)"SouInvalidNumUpgradePlugin_0", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("\n");
                    continue;
                }
                pProcessInfo.append("-------start compareBillNo:").append(billNo).append("\n");
                DynamicObjectCollection compareMaterialEntry = compareBill3.getDynamicObjectCollection("materialentry");
                List inquiryCollection = inquiryCollections.stream().filter(obj -> inquiryNo2.equals(obj.getString("billno"))).collect(Collectors.toList());
                List quoteCollection = quoteCollections.stream().filter(obj -> inquiryNo2.equals(obj.getString("inquiryno"))).collect(Collectors.toList());
                if (inquiryCollection.isEmpty()) {
                    pProcessInfo.append("inquiryCollection is empty, inquiryno:").append(inquiryNo2).append("\n");
                }
                if (quoteCollection.isEmpty()) {
                    pProcessInfo.append("quoteCollection is empty, inquiryno:").append(inquiryNo2).append("\n");
                }
                if (compareMaterialEntry.isEmpty()) {
                    pProcessInfo.append("compareMaterialEntry is empty, billNo:").append(billNo).append("\n");
                }
                HashMap<String, Integer> quoteEntryIdMap = new HashMap<String, Integer>(quoteCollection.size());
                for (DynamicObject inquiryBill : inquiryCollection) {
                    String inquiryId = inquiryBill.getString("id");
                    String inquiryEntryId = inquiryBill.getString("materialentry.id");
                    String inquiryEntrySrcbillid = inquiryBill.getString("materialentry.srcbillid");
                    String inquiryEntrySrcentryid = inquiryBill.getString("materialentry.srcentryid");
                    int validNum = 0;
                    ArrayList<String> quotebillSrcbillids = new ArrayList<String>(quoteCollection.size());
                    ArrayList<String> quotebillSrcentryids = new ArrayList<String>(quoteCollection.size());
                    ArrayList<String> quoteEntryIdList = new ArrayList<String>(quoteCollection.size());
                    for (DynamicObject quoBill : quoteCollection) {
                        String quotebillSrcbillid = quoBill.getString("materialentry.srcbillid");
                        String quotebillSrcentryid = quoBill.getString("materialentry.srcentryid");
                        quotebillSrcbillids.add(quotebillSrcbillid);
                        quotebillSrcentryids.add(quotebillSrcentryid);
                        if ((!inquiryId.equals(quotebillSrcbillid) || !inquiryEntryId.equals(quotebillSrcentryid)) && (inquiryEntrySrcbillid == null || inquiryEntrySrcentryid == null || !inquiryEntrySrcbillid.equals(quotebillSrcbillid) || !inquiryEntrySrcentryid.equals(quotebillSrcentryid))) continue;
                        ++validNum;
                        quoteEntryIdList.add(quoBill.getString("materialentry.id"));
                    }
                    if (validNum == 0) {
                        pProcessInfo.append("inquiry no valid quote:").append("inquiryId:").append(inquiryId).append("inquiryEntryId:").append(inquiryEntryId).append("billno:").append(inquiryNo2).append("quotebillSrcbillids:").append(quotebillSrcbillids).append("quotebillSrcentryids:").append(quotebillSrcentryids).append("\n");
                    }
                    for (String quoteEntryId : quoteEntryIdList) {
                        quoteEntryIdMap.put(quoteEntryId, validNum);
                    }
                }
                for (DynamicObject compareMaterialRow : compareMaterialEntry) {
                    String compareEntrySrcentryid = compareMaterialRow.getString("srcentryid");
                    if (quoteEntryIdMap.containsKey(compareEntrySrcentryid)) {
                        int newData = (Integer)quoteEntryIdMap.get(compareEntrySrcentryid);
                        Long entryId = compareMaterialRow.getLong("id");
                        sqlParms.put(entryId, newData);
                        pProcessInfo.append("prepare to update,parms:").append(newData).append(",").append(entryId).append("\n");
                        continue;
                    }
                    pProcessInfo.append("quote entryid not found,compareEntrySrcentryid:").append(compareEntrySrcentryid).append("quoteEntryIdMap:").append(quoteEntryIdMap).append("\n");
                }
                pProcessInfo.append("-------finish compareBillNo:").append(billNo).append("\n");
            }
            DBRoute dBRoute = new DBRoute(dbKey);
            ArrayList<Object[]> parms = new ArrayList<Object[]>(sqlParms.size());
            for (Map.Entry entry : sqlParms.entrySet()) {
                Object[] parm = new Object[]{entry.getValue(), entry.getKey()};
                parms.add(parm);
            }
            if (parms.isEmpty()) {
                return true;
            }
            this.updateDate(dBRoute, parms);
        }
        return true;
    }

    private void updateDate(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update T_PUR_COMPARENTRY set fvalidnum = ? where fentryId = ?", parms);
    }
}

