/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SouMultiCurrUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SouMultiCurrUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u591a\u5e01\u79cd\u65e7\u6570\u636e\u5347\u7ea7\u3002", (String)"SouMultiCurrUpgradePlugin_1", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5b8c\u6bd5\u3002", (String)"SouMultiCurrUpgradePlugin_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"SouMultiCurrUpgradePlugin_3", (String)"scm-sou-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        int pageSize = 1000;
        pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"SouMultiCurrUpgradePlugin_4", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("\n");
        DBRoute dbRoute1 = new DBRoute(dbKey);
        ArrayList idList = new ArrayList();
        try (DataSet ds = this.queryDataSet(dbRoute1, "select fid from t_pur_quote order by fid");){
            ds.forEach(row -> {
                if (row.get("fid") != null) {
                    idList.add(row.get("fid"));
                }
            });
        }
        int count = 0;
        if (null != idList) {
            count = idList.size();
        }
        if (0 >= count) {
            return true;
        }
        pProcessInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u5171\u83b7\u53d6{0}\u6761\u6570\u636e\u3002", (String)"SouMultiCurrUpgradePlugin_5", (String)"scm-sou-opplugin", (Object[])new Object[0]), count)).append("\n");
        int totalPages = count / pageSize;
        if (count % pageSize != 0) {
            ++totalPages;
        }
        HashMap<String, BigDecimal> multCurrRateMap = new HashMap<String, BigDecimal>();
        String sql = "select i.fid fid,i.FCurrID fcurr from t_pur_quote i inner join t_pur_inquiry q on i.finquiryno = q.fbillno where i.fcurrid = q.fcurrid and i.fid in";
        String unEqulesSql = "select distinct i.fid fid,i.finquiryno finquiryno from t_pur_quote i inner join t_pur_inquiry q on i.finquiryno = q.fbillno inner join T_PUR_QUOTENTRY b on i.fid=b.fid where i.fcurrid != q.fcurrid and b.fquotecurr = 0 and i.fid in";
        List<Object> subIdList = null;
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            ArrayList<Object> unEqulesIdList = new ArrayList<Object>();
            ArrayList<Object> unEqulesNoList = new ArrayList<Object>();
            DBRoute dbRoute = new DBRoute(dbKey);
            subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
            if (subIdList.size() <= 0) continue;
            ArrayList<Object[]> sameIdList = new ArrayList<Object[]>();
            String idStr = this.dealList(subIdList);
            try (DataSet ds = this.queryDataSet(dbRoute, sql + idStr);){
                ds.forEach(row -> {
                    if (row.get("fid") != null) {
                        Object[] objects = new Object[]{row.get("fcurr"), row.get("fid")};
                        sameIdList.add(objects);
                    }
                });
            }
            if (sameIdList.size() > 0) {
                String updateSql = "update T_PUR_QUOTENTRY set fquotecurr = ?,fexrate=1 where fid = ? and fquotecurr = 0";
                this.updateData(dbRoute, updateSql, sameIdList);
            }
            ds = this.queryDataSet(dbRoute, unEqulesSql + idStr);
            var19_25 = null;
            try {
                ds.forEach(row -> {
                    if (row.get("fid") != null) {
                        unEqulesIdList.add(row.get("fid"));
                    }
                    if (row.get("finquiryno") != null) {
                        unEqulesNoList.add(row.get("finquiryno"));
                    }
                });
            }
            catch (Throwable throwable) {
                var19_25 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var19_25 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var19_25.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (unEqulesIdList.size() <= 0 || unEqulesNoList.size() <= 0) continue;
            String uneqIdStr = this.dealList(unEqulesIdList);
            ArrayList uneaList = new ArrayList();
            try (DataSet ds = this.queryDataSet(dbRoute, "select i.fid,i.fsumtaxamount,i.fsumamount,i.fsumtax,i.finquiryno,i.fratedate,i.fcurrid  from t_pur_quote i where i.fid in" + uneqIdStr);){
                ds.forEach(row -> {
                    if (row.get("fid") != null) {
                        Object[] objects = new Object[]{row.get("fsumtaxamount"), row.get("fsumamount"), row.get("fsumtax"), row.get("fcurrid"), row.get("fid"), row.get("finquiryno"), row.get("fratedate")};
                        uneaList.add(objects);
                    }
                });
            }
            String selectSql = "select fbillno,FCurrID,FExchTypeID from T_PUR_INQUIRY where fbillno in " + this.dealList(unEqulesNoList);
            HashMap billNoCurrMap = new HashMap(64);
            try (DataSet ds = this.queryDataSet(dbRoute, selectSql);){
                ds.forEach(row -> {
                    Object[] objs = new Object[]{row.getString("fbillno"), row.getLong("FCurrID"), row.getLong("FExchTypeID")};
                    billNoCurrMap.put(row.getString("fbillno"), objs);
                });
            }
            ArrayList<Object[]> quoteList = new ArrayList<Object[]>(uneaList.size());
            ArrayList<Object[]> entryList = new ArrayList<Object[]>(uneaList.size());
            for (Object[] obj : uneaList) {
                Object[] inquiry = (Object[])billNoCurrMap.get(obj[5]);
                if (inquiry == null) continue;
                Long currId = (Long)obj[3];
                BigDecimal rate = BigDecimal.ONE;
                Long quotecurr = (Long)obj[3];
                if (inquiry != null) {
                    currId = (Long)inquiry[1];
                }
                if (quotecurr != null) {
                    String key = quotecurr.toString() + "-" + currId.toString();
                    rate = (BigDecimal)multCurrRateMap.get(key);
                    if (rate == null) {
                        rate = this.getExrate(quotecurr, currId, (Date)obj[6], (Long)inquiry[2]);
                        rate = rate == null ? BigDecimal.ONE : rate;
                        multCurrRateMap.put(key, rate);
                    }
                    obj[0] = this.flushValue((BigDecimal)obj[0], rate);
                    obj[1] = this.flushValue((BigDecimal)obj[1], rate);
                    obj[2] = this.flushValue((BigDecimal)obj[2], rate);
                }
                Object[] quoteObj = new Object[]{obj[0], obj[1], obj[2], currId, obj[4]};
                quoteList.add(quoteObj);
                Object[] entryObj = new Object[]{obj[3], rate, obj[4]};
                entryList.add(entryObj);
            }
            if (entryList.size() > 0) {
                String updateSql = "update T_PUR_QUOTENTRY set fquotecurr = ?,fexrate=? where fid = ?";
                this.updateData(dbRoute, updateSql, entryList);
            }
            if (quoteList.size() <= 0) continue;
            String updateQuoteSql = "update t_pur_quote set fsumtaxamount = ?, fsumamount = ? ,fsumtax = ?,FCurrID = ? where fid= ?";
            this.updateData(dbRoute, updateQuoteSql, quoteList);
        }
        return true;
    }

    private BigDecimal getExrate(Long quoteCurr, Long curr, Date ratedate, Long exchtype) {
        if (quoteCurr != null && curr != null && exchtype != null) {
            return quoteCurr.compareTo(curr) == 0 ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exchtype, (Long)quoteCurr, (Long)curr, (Date)ratedate);
        }
        return null;
    }

    private DataSet queryDataSet(DBRoute dbRoute, String s) {
        return DB.queryDataSet((String)"SouMultiCurrUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)s, (Object[])null);
    }

    private void updateData(DBRoute dbRoute, String updateQuoteSql, List<Object[]> quoteList) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateQuoteSql, quoteList);
    }

    private String dealList(List<Object> subIdList) {
        List list = subIdList.stream().map(value -> {
            if (value instanceof String) {
                return "'" + String.valueOf(value) + "'";
            }
            return String.valueOf(value);
        }).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(String.join((CharSequence)",", list)).append(")");
        return stringBuilder.toString();
    }

    private BigDecimal flushValue(BigDecimal value, BigDecimal rate) {
        if (value != null && rate.compareTo(BigDecimal.ZERO) > 0) {
            value = value.multiply(rate).setScale(8, 4);
        }
        return value;
    }
}

