/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SouNoticeUnAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SouNoticeUnAuditOp.class);
    private static final String ISTOP = "istop";
    private static final String SOUNOTICE = "sou_notice";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(ISTOP);
        fieldKeys.add("entryentity");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.handleReplyInfo(e);
        List topRowsPkIds = Arrays.asList(e.getDataEntities()).stream().filter(row -> (Boolean)row.get(ISTOP)).map(row -> row.getPkValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(topRowsPkIds)) {
            log.info("SouNoticeUnAuditOp  select untop data is null");
            return;
        }
        DynamicObject[] dbTops = BusinessDataServiceHelper.load((String)SOUNOTICE, (String)ISTOP, (QFilter[])new QFilter[]{new QFilter("id", "in", topRowsPkIds)});
        if (dbTops.length == 0) {
            log.info("SouNoticeUnAuditOp  db untop data is null");
            return;
        }
        List<DynamicObject> dbTopsList = Arrays.asList(dbTops);
        dbTopsList.forEach(row -> row.set(ISTOP, (Object)false));
        SaveServiceHelper.update((DynamicObject[])dbTopsList.toArray(new DynamicObject[dbTopsList.size()]));
    }

    private void handleReplyInfo(BeginOperationTransactionArgs e) {
        DynamicObject[] notices;
        List noticeIds = Arrays.stream(e.getDataEntities()).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        for (DynamicObject notice : notices = BusinessDataServiceHelper.load((String)SOUNOTICE, (String)this.getselectedFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", noticeIds)})) {
            DynamicObjectCollection entryentity = notice.getDynamicObjectCollection("entryentity");
            for (DynamicObject supEntry : entryentity) {
                supEntry.set("replystatus", (Object)"1");
            }
            notice.set("replyentity", null);
        }
        SaveServiceHelper.save((DynamicObject[])notices);
    }

    private String getselectedFields() {
        return "istop,entryentity.replystatus,replyentity.attachment, replyentity.replyname, replyentity.replytime,replyentity.replytext";
    }
}

