/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public final class SouUpdateBaseQtyOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billtype");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject data = dataEntities[0];
        DynamicObject bill = data.getDynamicObject("billtype");
        String billtype = bill.getString("number");
        QFilter filter = new QFilter("billdate", ">=", (Object)data.getDate("startdate"));
        filter.and("billdate", "<=", (Object)data.getDate("enddate"));
        String baseunitstr = "materialentry.basicunit";
        String unitstr = "materialentry.unit";
        QFilter filter2 = new QFilter(unitstr, "!=", (Object)baseunitstr, true);
        filter.and(filter2);
        HashSet<Long> ids = new HashSet<Long>(1024);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"SouUpdateBaseQtyOp", (String)billtype, (String)"id", (QFilter[])filter.toArray(), null);){
            while (dataset.hasNext()) {
                ids.add(dataset.next().getLong("id"));
                if (ids.size() <= 100) continue;
                this.doSaveBaseQty(ids, billtype);
                ids.clear();
            }
        }
        if (ids.size() > 0) {
            this.doSaveBaseQty(ids, billtype);
        }
    }

    private void doSaveBaseQty(Set<Long> ids, String entityName) {
        QFilter filter = new QFilter("id", "in", ids);
        String selector = "id,materialentry.material,materialentry.material.baseunit.*,materialentry.basicunit,materialentry.unit,materialentry.basicunit.precisionaccount,materialentry.basicunit.unitPrecision,materialentry.basicqty,materialentry.qty";
        if ("sou_quote".equals(entityName)) {
            selector = "id,materialentry.cfmqty,materialentry.cfmbaseqty,materialentry.material,materialentry.material.baseunit.*,materialentry.basicunit,materialentry.unit,materialentry.basicunit.precisionaccount,materialentry.basicunit.unitPrecision,materialentry.basicqty,materialentry.qty";
        }
        Object[] billdatas = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])filter.toArray());
        DynamicObject material = null;
        DynamicObject baseunit = null;
        DynamicObject unit = null;
        for (DynamicObject dynamicObject : billdatas) {
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                material = entry.getDynamicObject("material");
                baseunit = entry.getDynamicObject("basicunit");
                if (baseunit == null && material != null) {
                    baseunit = material.getDynamicObject("baseunit");
                    entry.set("basicunit", (Object)baseunit);
                }
                unit = entry.getDynamicObject("unit");
                BigDecimal baseqty = SouUpdateBaseQtyOp.getDesQtyConv(material, unit, entry.getBigDecimal("qty"), baseunit);
                entry.set("basicqty", (Object)baseqty);
                if (!"sou_quote".equals(entityName)) continue;
                BigDecimal cfmbaseqty = SouUpdateBaseQtyOp.getDesQtyConv(material, unit, entry.getBigDecimal("cfmqty"), baseunit);
                entry.set("cfmbaseqty", (Object)cfmbaseqty);
            }
        }
        BusinessDataServiceHelper.save((IDataEntityType)billdatas[0].getDataEntityType(), (Object[])billdatas);
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            Long materialId = material.getLong("masterid");
            qty = BaseDataServiceHelper.getDesmuCount((Long)materialId, (Long)srcUnit.getLong("id"), (BigDecimal)srcQty, (Long)desUnit.getLong("id"));
        }
        return qty;
    }
}

