/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.sou.opplugin.botp.SouToNoticePlugin;
import org.apache.commons.lang.StringEscapeUtils;

public class SouBidToNoticePlugin
extends SouToNoticePlugin {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] entityRows;
        if (this.afterFieldMappByTemplate(e)) {
            return;
        }
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entityRow : entityRows = entitySet.FindByEntityKey("sou_notice")) {
            StringBuilder content = new StringBuilder();
            DynamicObject targetRow = entityRow.getDataEntity();
            List srcRows = (List)entityRow.getValue("ConvertSource");
            content.append("<table style='border:1px solid #A6C1E4; text-align:center; font-family:Arial; height:20px; font-size:15px; border-collapse:collapse;'>").append("<tr>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:200px'>").append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"SouBidToNoticePlugin_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:200px'>").append(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"SouBidToNoticePlugin_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:300px'>").append(ResManager.loadKDString((String)"\u8be6\u7ec6\u63cf\u8ff0", (String)"SouBidToNoticePlugin_3", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"SouBidToNoticePlugin_4", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u8ba2\u8d27\u6570\u91cf", (String)"SouBidToNoticePlugin_5", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u53d1\u5e03\u65e5\u671f", (String)"SouBidToNoticePlugin_6", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u62a5\u540d\u622a\u81f3\u65e5\u671f", (String)"SouBidToNoticePlugin_7", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:200px'>").append(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SouBidToNoticePlugin_8", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>");
            StringBuilder billNo = new StringBuilder();
            for (DynamicObject row : srcRows) {
                long id = row.getLong("id");
                String selectFields = "billno,materialentry.material,materialentry.material.number,materialentry.material.name,materialentry.material.modelnum,materialentry.materialdesc,materialentry.unit.name,materialentry.unit.precisionaccount,materialentry.unit.precision,materialentry.qty,materialentry.note,billdate,enrolldate,materialentry.materialnametext";
                DynamicObjectCollection bidBillDC = QueryServiceHelper.query((String)"sou_bidbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                for (DynamicObject bidBillDO : bidBillDC) {
                    RoundingMode rm;
                    String name = StringEscapeUtils.escapeHtml((String)bidBillDO.getString("materialentry.material.name"));
                    String materialnametext = StringEscapeUtils.escapeHtml((String)bidBillDO.getString("materialentry.materialnametext"));
                    if (!StringUtils.isBlank((CharSequence)materialnametext)) {
                        name = materialnametext;
                    }
                    String model = StringEscapeUtils.escapeHtml((String)bidBillDO.getString("materialentry.material.modelnum"));
                    String desc = StringEscapeUtils.escapeHtml((String)bidBillDO.getString("materialentry.materialdesc"));
                    int precisionaccount = bidBillDO.getInt("materialentry.unit.precisionaccount");
                    switch (precisionaccount) {
                        case 1: {
                            rm = RoundingMode.HALF_UP;
                            break;
                        }
                        case 2: {
                            rm = RoundingMode.FLOOR;
                            break;
                        }
                        case 3: {
                            rm = RoundingMode.CEILING;
                            break;
                        }
                        default: {
                            rm = RoundingMode.HALF_UP;
                        }
                    }
                    String unit = StringEscapeUtils.escapeHtml((String)bidBillDO.getString("materialentry.unit.name"));
                    int newScale = bidBillDO.getInt("materialentry.unit.precision");
                    String qty = String.valueOf(new BigDecimal(bidBillDO.getString("materialentry.qty")).setScale(newScale, rm));
                    String billdate = DateUtil.date2str((Date)bidBillDO.getDate("billdate"), (String)"yyyy-MM-dd");
                    String enddate = DateUtil.date2str((Date)bidBillDO.getDate("enrolldate"), (String)"yyyy-MM-dd");
                    String note = StringEscapeUtils.escapeHtml((String)bidBillDO.getString("materialentry.note"));
                    if (!billNo.toString().contains(row.getString("billno"))) {
                        billNo.append(this.getSrcMainType().getDisplayName().getLocaleValue()).append('\uff1a').append(row.getString("billno"));
                    }
                    content.append("<tr><td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(name).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(model).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(desc).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(unit).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(qty).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(billdate).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(enddate).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(note).append("</td>");
                }
            }
            targetRow.set("content", (Object)content.append("</table>").toString());
            targetRow.set("srcbillno", (Object)billNo.toString());
        }
    }
}

