/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.sou.opplugin.botp.SouToNoticePlugin;
import org.apache.commons.lang.StringEscapeUtils;

public class SouInquiryToNoticePlugin
extends SouToNoticePlugin {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entityRows = entitySet.FindByEntityKey("sou_notice");
        if (this.afterFieldMappByTemplate(e)) {
            return;
        }
        for (ExtendedDataEntity entityRow : entityRows) {
            StringBuilder content = new StringBuilder();
            DynamicObject targetRow = entityRow.getDataEntity();
            List srcRows = (List)entityRow.getValue("ConvertSource");
            content.append("<table style='border:1px solid #A6C1E4; text-align:center; font-family:Arial; height:20px; font-size:15px; border-collapse:collapse;'>").append("<tr>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:200px'>").append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"SouInquiryToNoticePlugin_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:200px'>").append(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"SouInquiryToNoticePlugin_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:300px'>").append(ResManager.loadKDString((String)"\u8be6\u7ec6\u63cf\u8ff0", (String)"SouInquiryToNoticePlugin_3", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"SouInquiryToNoticePlugin_4", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u8ba2\u8d27\u6570\u91cf", (String)"SouInquiryToNoticePlugin_5", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u8be2\u4ef7\u65e5\u671f", (String)"SouInquiryToNoticePlugin_6", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:120px'>").append(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u81f3\u65e5\u671f", (String)"SouInquiryToNoticePlugin_7", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>").append("<th style='height:24px; font-size:16px; border:1px solid #A6C1E4; width:200px'>").append(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SouInquiryToNoticePlugin_8", (String)"scm-sou-opplugin", (Object[])new Object[0])).append("</th>");
            StringBuilder billNo = new StringBuilder();
            for (DynamicObject row : srcRows) {
                long id = row.getLong("id");
                String selectFields = "billno,materialentry.material,materialentry.material.number,materialentry.material.name,materialentry.material.modelnum,materialentry.materialdesc,materialentry.unit.name,materialentry.unit.precisionaccount,materialentry.unit.precision,materialentry.qty,materialentry.note,billdate,enddate,materialentry.materialnametext";
                DynamicObjectCollection inquiryDC = QueryServiceHelper.query((String)"sou_inquiry", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                for (DynamicObject inquiryDO : inquiryDC) {
                    RoundingMode rm;
                    String name = StringEscapeUtils.escapeHtml((String)inquiryDO.getString("materialentry.material.name"));
                    String model = StringEscapeUtils.escapeHtml((String)inquiryDO.getString("materialentry.material.modelnum"));
                    String desc = StringEscapeUtils.escapeHtml((String)inquiryDO.getString("materialentry.materialdesc"));
                    String materialnametext = StringEscapeUtils.escapeHtml((String)inquiryDO.getString("materialentry.materialnametext"));
                    if (!StringUtils.isBlank((CharSequence)materialnametext)) {
                        name = materialnametext;
                    }
                    int precisionaccount = inquiryDO.getInt("materialentry.unit.precisionaccount");
                    switch (precisionaccount) {
                        case 1: {
                            rm = RoundingMode.HALF_UP;
                            break;
                        }
                        case 2: {
                            rm = RoundingMode.FLOOR;
                            break;
                        }
                        case 3: {
                            rm = RoundingMode.CEILING;
                            break;
                        }
                        default: {
                            rm = RoundingMode.HALF_UP;
                        }
                    }
                    String unit = StringEscapeUtils.escapeHtml((String)inquiryDO.getString("materialentry.unit.name"));
                    int newScale = inquiryDO.getInt("materialentry.unit.precision");
                    String qty = String.valueOf(new BigDecimal(inquiryDO.getString("materialentry.qty")).setScale(newScale, rm));
                    String billdate = DateUtil.date2str((Date)inquiryDO.getDate("billdate"), (String)"yyyy-MM-dd");
                    String enddate = DateUtil.date2str((Date)inquiryDO.getDate("enddate"), (String)"yyyy-MM-dd");
                    String note = StringEscapeUtils.escapeHtml((String)inquiryDO.getString("materialentry.note"));
                    if (!billNo.toString().contains(row.getString("billno"))) {
                        billNo.append(this.getSrcMainType().getDisplayName().getLocaleValue()).append('\uff1a').append(row.getString("billno"));
                    }
                    content.append("<tr><td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(name).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(model).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(desc).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(unit).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(qty).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(billdate).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(enddate).append("</td>").append("<td style='height:24px; font-size:14px; border:1px solid #A6C1E4;'>").append(note).append("</td>");
                }
                targetRow.set("content", (Object)content.append("</table>").toString());
                targetRow.set("srcbillno", (Object)billNo.toString());
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObjectCollection collection;
            DynamicObjectCollection entrylog;
            DynamicObject[] dynamicObjects;
            DynamicObject noticeDT = entity.getDataEntity();
            String id = String.valueOf(entity.getValue("SourceRowsGroupKey"));
            if (StringUtils.isNotBlank((CharSequence)id) && (dynamicObjects = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)"id,billno,supscope,entryentity.supplier,entrylog.entrylogscope", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id))}, (String)"entrylog.entrylogscope desc")).length > 0 && (entrylog = dynamicObjects[0].getDynamicObjectCollection("entrylog")) != null && entrylog.size() > 0) {
                noticeDT.set("supscope", (Object)((DynamicObject)entrylog.get(entrylog.size() - 1)).getString("entrylogscope"));
            }
            if (!"2".equals(noticeDT.getString("supscope")) || (collection = noticeDT.getDynamicObjectCollection("entryentity")) == null || collection.size() <= 0) continue;
            Iterator dynamicObjectIterator = collection.iterator();
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
            while (dynamicObjectIterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectIterator.next();
                String key = dynamicObject.getString("supplier_id");
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                if (map.get(key) != null) {
                    dynamicObjectIterator.remove();
                    continue;
                }
                map.put(key, dynamicObject);
            }
        }
    }
}

